/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.getfilesrowscount;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.getfilesrowscount.GetFilesRowsCount;
import org.pentaho.di.trans.steps.getfilesrowscount.GetFilesRowsCountData;
import org.pentaho.di.trans.steps.getfilesrowscount.Messages;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetFilesRowsCountMeta
extends BaseStepMeta
implements StepMetaInterface {
    public static final String DEFAULT_ROWSCOUNT_FIELDNAME = "rowscount";
    private String[] fileName;
    private String[] fileMask;
    private boolean includeFilesCount;
    private String filesCountFieldName;
    private String rowsCountFieldName;
    private String RowSeparator_format;
    private String RowSeparator;
    private boolean filefield;
    private boolean isaddresult;
    private String outputFilenameField;

    public String getRowSeparator() {
        return this.RowSeparator;
    }

    public void setRowSeparator(String RowSeparatorin) {
        this.RowSeparator = RowSeparatorin;
    }

    public String getRowSeparatorFormat() {
        return this.RowSeparator_format;
    }

    public void setAddResultFile(boolean isaddresult) {
        this.isaddresult = isaddresult;
    }

    public boolean isAddResultFile() {
        return this.isaddresult;
    }

    public String setOutputFilenameField() {
        return this.outputFilenameField;
    }

    public void setOutputFilenameField(String outputFilenameField) {
        this.outputFilenameField = outputFilenameField;
    }

    public boolean isFileField() {
        return this.filefield;
    }

    public void setFileField(boolean filefield) {
        this.filefield = filefield;
    }

    public void setRowSeparatorFormat(String RowSeparator_formatin) {
        this.RowSeparator_format = RowSeparator_formatin;
    }

    public String[] getFileMask() {
        return this.fileMask;
    }

    public void setFileMask(String[] fileMask) {
        this.fileMask = fileMask;
    }

    public String[] getFileName() {
        return this.fileName;
    }

    public void setFileName(String[] fileName) {
        this.fileName = fileName;
    }

    public boolean includeCountFiles() {
        return this.includeFilesCount;
    }

    public void setIncludeCountFiles(boolean includeFilesCount) {
        this.includeFilesCount = includeFilesCount;
    }

    public String getFilesCountFieldName() {
        return this.filesCountFieldName;
    }

    public String getRowsCountFieldName() {
        return this.rowsCountFieldName;
    }

    public void setFilesCountFieldName(String filesCountFieldName) {
        this.filesCountFieldName = filesCountFieldName;
    }

    public void setRowsCountFieldName(String rowsCountFieldName) {
        this.rowsCountFieldName = rowsCountFieldName;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        GetFilesRowsCountMeta retval = (GetFilesRowsCountMeta)super.clone();
        int nrFiles = this.fileName.length;
        retval.allocate(nrFiles);
        for (int i = 0; i < nrFiles; ++i) {
            retval.fileName[i] = this.fileName[i];
            retval.fileMask[i] = this.fileMask[i];
        }
        return retval;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append("    ").append(XMLHandler.addTagValue((String)"files_count", (boolean)this.includeFilesCount));
        retval.append("    ").append(XMLHandler.addTagValue((String)"files_count_fieldname", (String)this.filesCountFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rows_count_fieldname", (String)this.rowsCountFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rowseparator_format", (String)this.RowSeparator_format));
        retval.append("    ").append(XMLHandler.addTagValue((String)"row_separator", (String)this.RowSeparator));
        retval.append("    ").append(XMLHandler.addTagValue((String)"isaddresult", (boolean)this.isaddresult));
        retval.append("    ").append(XMLHandler.addTagValue((String)"filefield", (boolean)this.filefield));
        retval.append("    ").append(XMLHandler.addTagValue((String)"filename_Field", (String)this.outputFilenameField));
        retval.append("    <file>").append(Const.CR);
        for (int i = 0; i < this.fileName.length; ++i) {
            retval.append("      ").append(XMLHandler.addTagValue((String)"name", (String)this.fileName[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"filemask", (String)this.fileMask[i]));
        }
        retval.append("    </file>").append(Const.CR);
        return retval.toString();
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.includeFilesCount = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"files_count"));
            this.filesCountFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"files_count_fieldname");
            this.rowsCountFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"rows_count_fieldname");
            this.RowSeparator_format = XMLHandler.getTagValue((Node)stepnode, (String)"rowseparator_format");
            this.RowSeparator = XMLHandler.getTagValue((Node)stepnode, (String)"row_separator");
            String addresult = XMLHandler.getTagValue((Node)stepnode, (String)"isaddresult");
            this.isaddresult = Const.isEmpty((String)addresult) ? true : "Y".equalsIgnoreCase(addresult);
            this.filefield = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"filefield"));
            this.outputFilenameField = XMLHandler.getTagValue((Node)stepnode, (String)"filename_Field");
            Node filenode = XMLHandler.getSubNode((Node)stepnode, (String)"file");
            int nrFiles = XMLHandler.countNodes((Node)filenode, (String)"name");
            this.allocate(nrFiles);
            for (int i = 0; i < nrFiles; ++i) {
                Node filenamenode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"name", (int)i);
                Node filemasknode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"filemask", (int)i);
                this.fileName[i] = XMLHandler.getNodeValue((Node)filenamenode);
                this.fileMask[i] = XMLHandler.getNodeValue((Node)filemasknode);
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public void allocate(int nrfiles) {
        this.fileName = new String[nrfiles];
        this.fileMask = new String[nrfiles];
    }

    @Override
    public void setDefault() {
        this.outputFilenameField = "";
        this.filefield = false;
        this.isaddresult = true;
        this.includeFilesCount = false;
        this.filesCountFieldName = "";
        this.rowsCountFieldName = DEFAULT_ROWSCOUNT_FIELDNAME;
        this.RowSeparator_format = "CR";
        this.RowSeparator = "";
        int nrFiles = 0;
        this.allocate(nrFiles);
        for (int i = 0; i < nrFiles; ++i) {
            this.fileName[i] = "filename" + (i + 1);
            this.fileMask[i] = "";
        }
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        ValueMeta v = new ValueMeta(space.environmentSubstitute(this.rowsCountFieldName), 5);
        v.setLength(10, 0);
        v.setOrigin(name);
        r.addValueMeta((ValueMetaInterface)v);
        if (this.includeFilesCount) {
            v = new ValueMeta(space.environmentSubstitute(this.filesCountFieldName), 5);
            v.setLength(10, 0);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.includeFilesCount = rep.getStepAttributeBoolean(id_step, "files_count");
            this.filesCountFieldName = rep.getStepAttributeString(id_step, "files_count_fieldname");
            this.rowsCountFieldName = rep.getStepAttributeString(id_step, "rows_count_fieldname");
            this.RowSeparator_format = rep.getStepAttributeString(id_step, "rowseparator_format");
            this.RowSeparator = rep.getStepAttributeString(id_step, "row_separator");
            String addresult = rep.getStepAttributeString(id_step, "isaddresult");
            this.isaddresult = Const.isEmpty((String)addresult) ? true : rep.getStepAttributeBoolean(id_step, "isaddresult");
            this.filefield = rep.getStepAttributeBoolean(id_step, "filefield");
            this.outputFilenameField = rep.getStepAttributeString(id_step, "filename_Field");
            int nrFiles = rep.countNrStepAttributes(id_step, "file_name");
            this.allocate(nrFiles);
            for (int i = 0; i < nrFiles; ++i) {
                this.fileName[i] = rep.getStepAttributeString(id_step, i, "file_name");
                this.fileMask[i] = rep.getStepAttributeString(id_step, i, "file_mask");
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("GetFilesRowsCountMeta.Exception.ErrorReadingRepository"), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "files_count", this.includeFilesCount);
            rep.saveStepAttribute(id_transformation, id_step, "files_count_fieldname", this.filesCountFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "rows_count_fieldname", this.rowsCountFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "rowseparator_format", this.RowSeparator_format);
            rep.saveStepAttribute(id_transformation, id_step, "row_separator", this.RowSeparator);
            rep.saveStepAttribute(id_transformation, id_step, "isaddresult", this.isaddresult);
            rep.saveStepAttribute(id_transformation, id_step, "filefield", this.filefield);
            rep.saveStepAttribute(id_transformation, id_step, "filename_Field", this.outputFilenameField);
            for (int i = 0; i < this.fileName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "file_name", this.fileName[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "file_mask", this.fileMask[i]);
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("GetFilesRowsCountMeta.Exception.ErrorSavingToRepository", "" + id_step), (Throwable)e);
        }
    }

    public FileInputList getFiles(VariableSpace space) {
        String[] required = new String[this.fileName.length];
        boolean[] subdirs = new boolean[this.fileName.length];
        for (int i = 0; i < required.length; ++i) {
            required[i] = "Y";
        }
        return FileInputList.createFileList((VariableSpace)space, (String[])this.fileName, (String[])this.fileMask, (String[])required, (boolean[])subdirs);
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (input.length > 0) {
            cr = new CheckResult(4, Messages.getString("GetFilesRowsCountMeta.CheckResult.NoInputExpected"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, Messages.getString("GetFilesRowsCountMeta.CheckResult.NoInput"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        FileInputList fileInputList = this.getFiles(transMeta);
        if (fileInputList == null || fileInputList.getFiles().size() == 0) {
            cr = new CheckResult(4, Messages.getString("GetFilesRowsCountMeta.CheckResult.NoFiles"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, Messages.getString("GetFilesRowsCountMeta.CheckResult.FilesOk", "" + fileInputList.getFiles().size()), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.RowSeparator_format.equals("CUSTOM") && this.RowSeparator == null) {
            cr = new CheckResult(4, Messages.getString("GetFilesRowsCountMeta.CheckResult.NoSeparator"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, Messages.getString("GetFilesRowsCountMeta.CheckResult.SeparatorOk"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new GetFilesRowsCount(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new GetFilesRowsCountData();
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository) throws KettleException {
        try {
            FileInputList fileList;
            ArrayList<FileObject> newFilenames = new ArrayList<FileObject>();
            if (!this.filefield && (fileList = this.getFiles(space)).getFiles().size() > 0) {
                for (FileObject fileObject : fileList.getFiles()) {
                    if (!fileObject.exists()) continue;
                    newFilenames.add(fileObject);
                }
                this.fileName = new String[newFilenames.size()];
                this.fileMask = new String[newFilenames.size()];
                for (int i = 0; i < newFilenames.size(); ++i) {
                    FileObject fileObject;
                    fileObject = (FileObject)newFilenames.get(i);
                    this.fileName[i] = resourceNamingInterface.nameResource(fileObject.getName().getBaseName(), fileObject.getParent().getName().getPath(), space.toString(), ResourceNamingInterface.FileNamingType.DATA_FILE);
                    this.fileMask[i] = null;
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }
}

