/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.Arrays;
import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css3.CssFontFamily;
import org.w3c.css.properties.css3.CssFontSize;
import org.w3c.css.properties.css3.CssFontStretch;
import org.w3c.css.properties.css3.CssFontStyle;
import org.w3c.css.properties.css3.CssFontVariant;
import org.w3c.css.properties.css3.CssFontWeight;
import org.w3c.css.properties.css3.CssLineHeight;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;

public class CssFont
extends org.w3c.css.properties.css.CssFont {
    public CssFontStretch fontStretch = null;
    public static final CssIdent normal;
    public static final CssIdent[] systemFonts;
    static final String[] _systemFonts;

    public static final CssIdent getSystemFont(CssIdent ident) {
        int idx = Arrays.binarySearch(systemFonts, ident);
        if (idx >= 0) {
            return systemFonts[idx];
        }
        return null;
    }

    public CssFont() {
        this.value = initial;
    }

    public CssFont(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        this.setByUser();
        boolean gotNormal = false;
        int state = 0;
        block9: while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            switch (val.getType()) {
                case 0: {
                    CssExpression nex;
                    CssIdent id = val.getIdent();
                    if (CssIdent.isCssWide(id)) {
                        if (expression.getCount() != 1) {
                            throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                        }
                        this.value = val;
                        break;
                    }
                    if (CssFont.getSystemFont(id) != null) {
                        if (expression.getCount() != 1) {
                            throw new InvalidParamException("system-font-keyword-not-sole-value", val.toString(), val.toString(), ac);
                        }
                        this.value = val;
                        break;
                    }
                    if (state == 0) {
                        if (normal.equals(id)) {
                            gotNormal = true;
                            break;
                        }
                        if (CssFontStyle.getMatchingIdent(id) != null) {
                            if (this.fontStyle != null) {
                                throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                            }
                            CssValue nextVal = expression.getNextValue();
                            if (nextVal != null && nextVal.getType() == 7) {
                                nex = new CssExpression();
                                nex.addValue(val);
                                expression.next();
                                nex.addValue(nextVal);
                                try {
                                    this.fontStyle = new CssFontStyle(ac, nex, false);
                                    break;
                                }
                                catch (Exception ex) {
                                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                                }
                            }
                            this.fontStyle = new CssFontStyle();
                            this.fontStyle.value = val;
                            break;
                        }
                        if (org.w3c.css.properties.css21.CssFontVariant.getAllowedFontVariant(id) != null) {
                            if (this.fontVariant != null) {
                                throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                            }
                            this.fontVariant = new CssFontVariant();
                            this.fontVariant.value = val;
                            break;
                        }
                        if (CssFontWeight.getAllowedValue(id) != null) {
                            if (this.fontWeight != null) {
                                throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                            }
                            this.fontWeight = new CssFontWeight();
                            this.fontWeight.value = val;
                            break;
                        }
                        if (CssFontStretch.getAllowedValue(id) != null) {
                            if (this.fontStretch != null) {
                                throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                            }
                            this.fontStretch = new CssFontStretch();
                            this.fontStretch.value = val;
                            break;
                        }
                    }
                    if (state == 0 && CssFontSize.getAllowedValue(id) != null) {
                        state = 1;
                        if (this.fontSize != null) {
                            throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                        }
                        this.fontSize = new CssFontSize();
                        this.fontSize.value = val;
                        break;
                    }
                    if (state == 1) {
                        this.fontFamily = new CssFontFamily(ac, expression, check);
                        state = 2;
                        continue block9;
                    }
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
                case 14: {
                    if (this.fontSize == null || state != 1 || this.lineHeight != null) {
                        throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                    }
                    expression.next();
                    if (expression.end()) {
                        throw new InvalidParamException("value", expression.toString(), this.getPropertyName(), ac);
                    }
                    CssExpression nex = new CssExpression();
                    nex.addValue(expression.getValue());
                    this.lineHeight = new CssLineHeight(ac, nex, false);
                    state = 1;
                    break;
                }
                case 5: {
                    CssExpression nex;
                    if (!val.getCheckableValue().isZero()) {
                        if (state == 0 && this.fontWeight == null) {
                            nex = new CssExpression();
                            nex.addValue(val);
                            this.fontWeight = new CssFontWeight(ac, nex, false);
                            break;
                        }
                        throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                    }
                }
                case 4: 
                case 6: {
                    CssExpression nex;
                    if (state == 0 && this.fontSize == null) {
                        nex = new CssExpression();
                        nex.addValue(val);
                        this.fontSize = new CssFontSize(ac, nex, false);
                        state = 1;
                        break;
                    }
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
                case 1: {
                    if (state == 1) {
                        this.fontFamily = new CssFontFamily(ac, expression, check);
                        state = 2;
                        continue block9;
                    }
                }
                default: {
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
            }
            if (op != ' ') {
                throw new InvalidParamException("operator", Character.toString(op), ac);
            }
            expression.next();
        }
        if (gotNormal) {
            if (this.fontSize == null) {
                this.fontSize = new CssFontSize();
                this.fontSize.value = normal;
            }
            if (this.fontVariant == null) {
                this.fontVariant = new CssFontVariant();
                this.fontVariant.value = normal;
            }
            if (this.fontWeight == null) {
                this.fontWeight = new CssFontWeight();
                this.fontWeight.value = normal;
            }
            if (this.fontStretch == null) {
                this.fontStretch = new CssFontStretch();
                this.fontStretch.value = normal;
            }
        }
    }

    public CssFont(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    @Override
    public String toString() {
        if (this.value != null) {
            return this.value.toString();
        }
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        if (this.fontStyle != null) {
            sb.append(this.fontStyle);
            first = false;
        }
        if (this.fontVariant != null) {
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(this.fontVariant);
        }
        if (this.fontWeight != null) {
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(this.fontWeight);
        }
        if (this.fontStretch != null) {
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(this.fontStretch);
        }
        if (this.fontSize != null) {
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(this.fontSize);
        }
        if (this.lineHeight != null) {
            sb.append('/');
            sb.append(this.lineHeight);
        }
        if (this.fontFamily != null) {
            sb.append(' ');
            sb.append(this.fontFamily);
        }
        return sb.toString();
    }

    @Override
    public void addToStyle(ApplContext ac, CssStyle style) {
        super.addToStyle(ac, style);
        if (this.fontStretch != null) {
            this.fontStretch.addToStyle(ac, style);
        }
    }

    static {
        _systemFonts = new String[]{"caption", "icon", "menu", "message-box", "small-caption", "status-bar"};
        normal = CssIdent.getIdent("normal");
        systemFonts = new CssIdent[_systemFonts.length];
        int i = 0;
        for (String s : _systemFonts) {
            CssFont.systemFonts[i++] = CssIdent.getIdent(s);
        }
        Arrays.sort(systemFonts);
    }
}

