/*
 * Decompiled with CFR 0.152.
 */
package liquibase.statement.core;

import liquibase.change.ColumnConfig;
import liquibase.statement.AbstractSqlStatement;
import liquibase.statement.core.DatabaseTableIdentifier;
import liquibase.util.StringUtil;
import lombok.Generated;

public class AddPrimaryKeyStatement
extends AbstractSqlStatement {
    private String tablespace;
    private final ColumnConfig[] columns;
    private final String constraintName;
    private Boolean clustered;
    private String forIndexName;
    private String forIndexSchemaName;
    private String forIndexCatalogName;
    private boolean shouldValidate = true;
    private DatabaseTableIdentifier databaseTableIdentifier = new DatabaseTableIdentifier(null, null, null);

    public AddPrimaryKeyStatement(String catalogName, String schemaName, String tableName, String columnNames, String constraintName) {
        this(catalogName, schemaName, tableName, ColumnConfig.arrayFromNames(columnNames), constraintName);
    }

    public AddPrimaryKeyStatement(String catalogName, String schemaName, String tableName, ColumnConfig[] columns, String constraintName) {
        this.databaseTableIdentifier.setCatalogName(catalogName);
        this.databaseTableIdentifier.setSchemaName(schemaName);
        this.databaseTableIdentifier.setTableName(tableName);
        this.columns = columns;
        this.constraintName = constraintName;
    }

    public AddPrimaryKeyStatement setTablespace(String tablespace) {
        this.tablespace = tablespace;
        return this;
    }

    public String getColumnNames() {
        return StringUtil.join(this.columns, ", ", obj -> obj.getName() + (obj.getDescending() != null && obj.getDescending() != false ? " DESC" : ""));
    }

    public Boolean isClustered() {
        return this.clustered;
    }

    public AddPrimaryKeyStatement setClustered(Boolean clustered) {
        this.clustered = clustered;
        return this;
    }

    public boolean shouldValidate() {
        return this.shouldValidate;
    }

    public AddPrimaryKeyStatement setShouldValidate(boolean shouldValidate) {
        this.shouldValidate = shouldValidate;
        return this;
    }

    public String getCatalogName() {
        return this.databaseTableIdentifier.getCatalogName();
    }

    public String getSchemaName() {
        return this.databaseTableIdentifier.getSchemaName();
    }

    public String getTableName() {
        return this.databaseTableIdentifier.getTableName();
    }

    @Generated
    public String getTablespace() {
        return this.tablespace;
    }

    @Generated
    public ColumnConfig[] getColumns() {
        return this.columns;
    }

    @Generated
    public String getConstraintName() {
        return this.constraintName;
    }

    @Generated
    public String getForIndexName() {
        return this.forIndexName;
    }

    @Generated
    public void setForIndexName(String forIndexName) {
        this.forIndexName = forIndexName;
    }

    @Generated
    public String getForIndexSchemaName() {
        return this.forIndexSchemaName;
    }

    @Generated
    public void setForIndexSchemaName(String forIndexSchemaName) {
        this.forIndexSchemaName = forIndexSchemaName;
    }

    @Generated
    public String getForIndexCatalogName() {
        return this.forIndexCatalogName;
    }

    @Generated
    public void setForIndexCatalogName(String forIndexCatalogName) {
        this.forIndexCatalogName = forIndexCatalogName;
    }
}

