/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.builders;

import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Connection;
import redis.clients.jedis.DefaultJedisClientConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.builders.AbstractClientBuilder;
import redis.clients.jedis.providers.ConnectionProvider;
import redis.clients.jedis.providers.SentineledConnectionProvider;

public abstract class SentinelClientBuilder<C>
extends AbstractClientBuilder<SentinelClientBuilder<C>, C> {
    private String masterName = null;
    private Set<HostAndPort> sentinels = null;
    private JedisClientConfig sentinelClientConfig = null;

    public SentinelClientBuilder<C> masterName(String masterName) {
        this.masterName = masterName;
        return this;
    }

    public SentinelClientBuilder<C> sentinels(Set<HostAndPort> sentinels) {
        this.sentinels = sentinels;
        return this;
    }

    public SentinelClientBuilder<C> sentinelClientConfig(JedisClientConfig sentinelClientConfig) {
        this.sentinelClientConfig = sentinelClientConfig;
        return this;
    }

    @Override
    protected SentinelClientBuilder<C> self() {
        return this;
    }

    @Override
    protected ConnectionProvider createDefaultConnectionProvider() {
        return new SentineledConnectionProvider(this.masterName, this.clientConfig, this.cache, (GenericObjectPoolConfig<Connection>)this.poolConfig, this.sentinels, this.sentinelClientConfig);
    }

    @Override
    protected void validateSpecificConfiguration() {
        this.validateCommonConfiguration();
        if (this.masterName == null || this.masterName.trim().isEmpty()) {
            throw new IllegalArgumentException("Master name is required for Sentinel mode");
        }
        if (this.sentinels == null || this.sentinels.isEmpty()) {
            throw new IllegalArgumentException("At least one sentinel must be specified for Sentinel mode");
        }
    }

    @Override
    public C build() {
        if (this.sentinelClientConfig == null) {
            this.sentinelClientConfig = DefaultJedisClientConfig.builder().build();
        }
        return super.build();
    }
}

