/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.transport;

import java.util.List;
import java.util.Map;
import org.eclipse.jetty.client.transport.internal.HttpConnectionOverHTTP;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.TypeUtil;

public class HttpClientConnectionFactory
implements ClientConnectionFactory {
    public static final ClientConnectionFactory.Info HTTP11 = new HTTP11();
    private boolean initializeConnections;

    public boolean isInitializeConnections() {
        return this.initializeConnections;
    }

    public void setInitializeConnections(boolean initialize) {
        this.initializeConnections = initialize;
    }

    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) {
        HttpConnectionOverHTTP connection = new HttpConnectionOverHTTP(endPoint, context);
        connection.setInitialize(this.isInitializeConnections());
        return this.customize((Connection)connection, context);
    }

    public static class HTTP11
    extends ClientConnectionFactory.Info {
        private final List<String> protocols;

        public HTTP11() {
            this(List.of("http/1.1"));
        }

        public HTTP11(List<String> protocols) {
            super((ClientConnectionFactory)new HttpClientConnectionFactory());
            this.protocols = protocols;
        }

        public List<String> getProtocols(boolean secure) {
            return this.protocols;
        }

        public String toString() {
            return String.format("%s@%x%s", TypeUtil.toShortName(((Object)((Object)this)).getClass()), ((Object)((Object)this)).hashCode(), this.protocols);
        }
    }
}

