/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.LinkedList;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class ProgressProtocolDecoder
extends BaseProtocolDecoder {
    private long lastIndex;
    private long newIndex;
    public static final int MSG_NULL = 0;
    public static final int MSG_IDENT = 1;
    public static final int MSG_IDENT_FULL = 2;
    public static final int MSG_POINT = 10;
    public static final int MSG_LOG_SYNC = 100;
    public static final int MSG_LOGMSG = 101;
    public static final int MSG_TEXT = 102;
    public static final int MSG_ALARM = 200;
    public static final int MSG_ALARM_RECIEVED = 201;

    public ProgressProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void requestArchive(Channel channel) {
        if (this.lastIndex == 0L) {
            this.lastIndex = this.newIndex;
        } else if (this.newIndex > this.lastIndex) {
            ByteBuf request = Unpooled.buffer((int)12);
            request.writeShortLE(100);
            request.writeShortLE(4);
            request.writeIntLE((int)this.lastIndex);
            request.writeIntLE(0);
            channel.writeAndFlush((Object)new NetworkMessage(request, channel.remoteAddress()));
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        int type = buf.readUnsignedShortLE();
        buf.readUnsignedShortLE();
        if (type == 1 || type == 2) {
            buf.readUnsignedIntLE();
            int length = buf.readUnsignedShortLE();
            buf.skipBytes(length);
            length = buf.readUnsignedShortLE();
            buf.skipBytes(length);
            length = buf.readUnsignedShortLE();
            String imei = buf.readSlice(length).toString(StandardCharsets.US_ASCII);
            this.getDeviceSession(channel, remoteAddress, imei);
        } else if (type == 10 || type == 200 || type == 101) {
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
            if (deviceSession == null) {
                return null;
            }
            LinkedList<Position> positions = new LinkedList<Position>();
            int recordCount = 1;
            if (type == 101) {
                recordCount = buf.readUnsignedShortLE();
            }
            for (int j = 0; j < recordCount; ++j) {
                Position position = new Position(this.getProtocolName());
                position.setDeviceId(deviceSession.getDeviceId());
                if (type == 101) {
                    position.set("archive", true);
                    int subtype = buf.readUnsignedShortLE();
                    if (subtype == 200) {
                        position.addAlarm("general");
                    }
                    if (buf.readUnsignedShortLE() > buf.readableBytes()) {
                        ++this.lastIndex;
                        break;
                    }
                    this.lastIndex = buf.readUnsignedIntLE();
                    position.set("index", this.lastIndex);
                } else {
                    this.newIndex = buf.readUnsignedIntLE();
                }
                position.setTime(new Date(buf.readUnsignedIntLE() * 1000L));
                position.setLatitude((double)buf.readIntLE() * 180.0 / 2.147483647E9);
                position.setLongitude((double)buf.readIntLE() * 180.0 / 2.147483647E9);
                position.setSpeed((double)buf.readUnsignedIntLE() * 0.01);
                position.setCourse((double)buf.readUnsignedShortLE() * 0.01);
                position.setAltitude((double)buf.readUnsignedShortLE() * 0.01);
                short satellites = buf.readUnsignedByte();
                position.setValid(satellites >= 3);
                position.set("sat", Integer.valueOf(satellites));
                position.set("rssi", buf.readUnsignedByte());
                position.set("odometer", buf.readUnsignedIntLE());
                long extraFlags = buf.readLongLE();
                if (BitUtil.check(extraFlags, 0)) {
                    int count = buf.readUnsignedShortLE();
                    for (int i = 1; i <= count; ++i) {
                        position.set("adc" + i, buf.readUnsignedShortLE());
                    }
                }
                if (BitUtil.check(extraFlags, 1)) {
                    int size = buf.readUnsignedShortLE();
                    position.set("can", buf.toString(buf.readerIndex(), size, StandardCharsets.US_ASCII));
                    buf.skipBytes(size);
                }
                if (BitUtil.check(extraFlags, 2)) {
                    position.set("passenger", ByteBufUtil.hexDump((ByteBuf)buf.readSlice(buf.readUnsignedShortLE())));
                }
                if (type == 200) {
                    position.addAlarm("general");
                    byte[] response = new byte[]{-55, 0, 0, 0, 0, 0, 0, 0};
                    channel.writeAndFlush((Object)new NetworkMessage(Unpooled.wrappedBuffer((byte[])response), remoteAddress));
                }
                buf.readUnsignedIntLE();
                positions.add(position);
            }
            this.requestArchive(channel);
            return positions;
        }
        return null;
    }
}

