/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.helper;

import io.netty.buffer.ByteBuf;

public final class BcdUtil {
    private BcdUtil() {
    }

    public static int readInteger(ByteBuf buf, int digits) {
        int result = 0;
        for (int i = 0; i < digits / 2; ++i) {
            short b = buf.readUnsignedByte();
            result *= 10;
            result += b >>> 4;
            result *= 10;
            result += b & 0xF;
        }
        if (digits % 2 != 0) {
            short b = buf.getUnsignedByte(buf.readerIndex());
            result *= 10;
            result += b >>> 4;
        }
        return result;
    }

    public static double readCoordinate(ByteBuf buf) {
        short b1 = buf.readUnsignedByte();
        short b2 = buf.readUnsignedByte();
        short b3 = buf.readUnsignedByte();
        short b4 = buf.readUnsignedByte();
        double value = (b2 & 0xF) * 10 + (b3 >> 4);
        value += (double)(((b3 & 0xF) * 10 + (b4 >> 4)) * 10 + (b4 & 0xF)) / 1000.0;
        value /= 60.0;
        value += (double)(((b1 >> 4 & 7) * 10 + (b1 & 0xF)) * 10 + (b2 >> 4));
        if ((b1 & 0x80) != 0) {
            value = -value;
        }
        return value;
    }
}

