/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.clients.consumer.internals.StreamsRebalanceData;
import org.apache.kafka.clients.consumer.internals.StreamsRebalanceListener;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public class StreamsRebalanceListenerInvoker {
    private final Logger log;
    private final StreamsRebalanceData streamsRebalanceData;
    private Optional<StreamsRebalanceListener> listener;

    StreamsRebalanceListenerInvoker(LogContext logContext, StreamsRebalanceData streamsRebalanceData) {
        this.log = logContext.logger(this.getClass());
        this.listener = Optional.empty();
        this.streamsRebalanceData = streamsRebalanceData;
    }

    public void setRebalanceListener(StreamsRebalanceListener streamsRebalanceListener) {
        Objects.requireNonNull(streamsRebalanceListener, "StreamsRebalanceListener cannot be null");
        this.listener = Optional.of(streamsRebalanceListener);
    }

    public Exception invokeAllTasksRevoked() {
        if (this.listener.isEmpty()) {
            return null;
        }
        return this.invokeTasksRevoked(this.streamsRebalanceData.reconciledAssignment().activeTasks());
    }

    public Exception invokeTasksAssigned(StreamsRebalanceData.Assignment assignment) {
        if (this.listener.isEmpty()) {
            return null;
        }
        this.log.info("Invoking tasks assigned callback for new assignment: {}", (Object)assignment);
        try {
            this.listener.get().onTasksAssigned(assignment);
        }
        catch (InterruptException | WakeupException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error("Streams rebalance listener failed on invocation of onTasksAssigned for tasks {}", (Object)assignment, (Object)e);
            return e;
        }
        return null;
    }

    public Exception invokeTasksRevoked(Set<StreamsRebalanceData.TaskId> tasks) {
        if (this.listener.isEmpty()) {
            return null;
        }
        this.log.info("Invoking task revoked callback for revoked active tasks {}", tasks);
        try {
            this.listener.get().onTasksRevoked(tasks);
        }
        catch (InterruptException | WakeupException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error("Streams rebalance listener failed on invocation of onTasksRevoked for tasks {}", tasks, (Object)e);
            return e;
        }
        return null;
    }

    public Exception invokeAllTasksLost() {
        if (this.listener.isEmpty()) {
            return null;
        }
        this.log.info("Invoking tasks lost callback for all tasks");
        try {
            this.listener.get().onAllTasksLost();
        }
        catch (InterruptException | WakeupException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error("Streams rebalance listener failed on invocation of onTasksLost.", (Throwable)e);
            return e;
        }
        return null;
    }
}

