/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.command;

import java.util.List;
import org.jxls.command.CellRefGenerator;
import org.jxls.common.CellRef;
import org.jxls.common.Context;
import org.jxls.transform.SafeSheetNameBuilder;

public class SheetNameGenerator
implements CellRefGenerator {
    private final List<String> sheetNames;
    private final CellRef startCellRef;

    public SheetNameGenerator(List<String> sheetNames, CellRef startCellRef) {
        this.sheetNames = sheetNames;
        this.startCellRef = startCellRef;
    }

    @Override
    public CellRef generateCellRef(int index, Context context) {
        String sheetName = index >= 0 && index < this.sheetNames.size() ? this.sheetNames.get(index) : null;
        Object builder = context.getVar("SafeSheetNameBuilder");
        if (builder instanceof SafeSheetNameBuilder) {
            sheetName = ((SafeSheetNameBuilder)builder).createSafeSheetName(sheetName, index);
        }
        if (sheetName == null) {
            return null;
        }
        return new CellRef(sheetName, this.startCellRef.getRow(), this.startCellRef.getCol());
    }
}

