/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal;

import java.util.BitSet;
import java.util.function.IntConsumer;

public class LexicalScope {
    protected static final int BITS_PER_LONG = 64;
    protected static final int BITS_PER_SYMBOL = 2;
    protected static final int SYMBOL_SHIFT = 1;
    protected static final long SYMBOL_MASK = 1L;
    protected int count;
    protected long symbols;
    protected BitSet moreSymbols;

    public LexicalScope() {
    }

    protected LexicalScope(LexicalScope other) {
        this.symbols = other.symbols;
        BitSet otherMoreSymbols = other.moreSymbols;
        this.moreSymbols = otherMoreSymbols != null ? (BitSet)otherMoreSymbols.clone() : null;
        this.count = other.count;
    }

    public boolean addConstant(int symbol) {
        int letb = symbol << 1;
        if (!this.isSet(letb)) {
            throw new IllegalStateException("const not declared as symbol " + symbol);
        }
        int bit = symbol << 1 | 1;
        return this.set(bit);
    }

    public boolean addSymbol(int symbol) {
        int bit = symbol << 1;
        if (this.set(bit)) {
            ++this.count;
            return true;
        }
        return false;
    }

    public final void clearSymbols(IntConsumer cleanSymbol) {
        if (cleanSymbol != null) {
            int s;
            int bit;
            for (long clean = this.symbols; clean != 0L; clean &= 1L << bit ^ 0xFFFFFFFFFFFFFFFFL) {
                bit = Long.numberOfTrailingZeros(clean);
                s = bit >> 1;
                cleanSymbol.accept(s);
            }
            int n = bit = this.moreSymbols != null ? this.moreSymbols.nextSetBit(0) : -1;
            while (bit >= 0) {
                s = bit + 64 >> 1;
                cleanSymbol.accept(s);
                bit = this.moreSymbols.nextSetBit(bit + 2);
            }
        }
        this.symbols = 0L;
        this.count = 0;
        if (this.moreSymbols != null) {
            this.moreSymbols.clear();
        }
    }

    public int getSymbolCount() {
        return this.count;
    }

    public boolean hasSymbol(int symbol) {
        int bit = symbol << 1;
        return this.isSet(bit);
    }

    public boolean isConstant(int symbol) {
        int bit = symbol << 1 | 1;
        return this.isSet(bit);
    }

    private boolean isSet(int bit) {
        if (bit < 64) {
            return (this.symbols & 1L << bit) != 0L;
        }
        return this.moreSymbols != null && this.moreSymbols.get(bit - 64);
    }

    private BitSet moreBits() {
        if (this.moreSymbols == null) {
            this.moreSymbols = new BitSet();
        }
        return this.moreSymbols;
    }

    private boolean set(int bit) {
        if (bit < 64) {
            if ((this.symbols & 1L << bit) != 0L) {
                return false;
            }
            this.symbols |= 1L << bit;
        } else {
            int bit64 = bit - 64;
            BitSet ms = this.moreBits();
            if (ms.get(bit64)) {
                return false;
            }
            ms.set(bit64, true);
        }
        return true;
    }
}

