/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) >> u64vec3(46ul, 50ul, 0ul)) => u64vec3(18947ul, 0ul, 94ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) >> u64vec3(52ul, 23ul, 5ul)) => u64vec3(296ul, 0ul, 2ul)
 * (u64vec3(167ul, 66ul, 187ul) >> u64vec3(46ul, 50ul, 0ul)) => u64vec3(0ul, 0ul, 187ul)
 * (u64vec3(167ul, 66ul, 187ul) >> u64vec3(52ul, 23ul, 5ul)) => u64vec3(0ul, 0ul, 5ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) >> u64vec3(46ul, 50ul, 0ul)), u64vec3(18947ul, 0ul, 94ul))) ? 1 : -1] array0;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) >> u64vec3(52ul, 23ul, 5ul)), u64vec3(296ul, 0ul, 2ul))) ? 1 : -1] array1;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) >> u64vec3(46ul, 50ul, 0ul)), u64vec3(0ul, 0ul, 187ul))) ? 1 : -1] array2;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) >> u64vec3(52ul, 23ul, 5ul)), u64vec3(0ul, 0ul, 5ul))) ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
