/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.download.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.karaf.features.internal.download.impl.AbstractDownloadTask;
import org.apache.karaf.features.internal.download.impl.AbstractRetryableDownloadTask;
import org.apache.karaf.features.internal.download.impl.DownloadManagerHelper;
import org.apache.karaf.util.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDownloadTask
extends AbstractRetryableDownloadTask {
    private static final String BLUEPRINT_PREFIX = "blueprint:";
    private static final String SPRING_PREFIX = "spring:";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDownloadTask.class);
    private File basePath;

    public SimpleDownloadTask(ScheduledExecutorService executorService, String url, File basePath) {
        super(executorService, url);
        this.basePath = basePath;
    }

    @Override
    protected File download(Exception previousExceptionNotUsed) throws Exception {
        LOG.trace("Downloading [" + this.url + "]");
        if (this.url.startsWith(BLUEPRINT_PREFIX) || this.url.startsWith(SPRING_PREFIX)) {
            return this.downloadBlueprintOrSpring();
        }
        try {
            this.basePath.mkdirs();
            if (!this.basePath.isDirectory()) {
                throw new IOException("Unable to create directory " + this.basePath.toString());
            }
            URL urlObj = new URL(this.url);
            File file = new File(this.basePath, this.getFileName(urlObj));
            if (file.exists()) {
                return file;
            }
            File dir = new File(System.getProperty("karaf.data"), "tmp");
            dir.mkdirs();
            if (!dir.isDirectory()) {
                throw new IOException("Unable to create directory " + dir.toString());
            }
            File tmpFile = Files.createTempFile(dir.toPath(), "download-", null, new FileAttribute[0]).toFile();
            urlObj = new URL(DownloadManagerHelper.stripStartLevel(urlObj.toString()));
            try (InputStream is = urlObj.openStream();
                 FileOutputStream os = new FileOutputStream(tmpFile);){
                StreamUtils.copy(is, os);
            }
            if (file.exists() && !file.delete()) {
                throw new IOException("Unable to delete file: " + file.toString());
            }
            if (!tmpFile.renameTo(file)) {
                throw new IOException("Unable to rename file " + tmpFile.toString() + " to " + file.toString());
            }
            return file;
        }
        catch (Exception ignore) {
            throw new IOException("Could not download [" + this.url + "]", ignore);
        }
    }

    private String getFileName(URL urlObj) {
        Object url = urlObj.getFile();
        url = DownloadManagerHelper.stripUrl((String)url);
        url = DownloadManagerHelper.removeInlinedMavenRepositoryUrl((String)url);
        int unixPos = ((String)url).lastIndexOf(47);
        int windowsPos = ((String)url).lastIndexOf(92);
        url = ((String)url).substring(Math.max(unixPos, windowsPos) + 1);
        url = Integer.toHexString(urlObj.toString().hashCode()) + "-" + (String)url;
        return url;
    }

    protected File downloadBlueprintOrSpring() throws Exception {
        File dir = new File(System.getProperty("karaf.data"), "tmp");
        dir.mkdirs();
        File tmpFile = Files.createTempFile(dir.toPath(), "download-", null, new FileAttribute[0]).toFile();
        try (InputStream is = new URL(this.url).openStream();
             FileOutputStream os = new FileOutputStream(tmpFile);){
            StreamUtils.copy(is, os);
        }
        return tmpFile;
    }

    @Override
    protected AbstractRetryableDownloadTask.Retry isRetryable(IOException e) {
        return super.isRetryable(e);
    }
}

