/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.items.events;

import java.time.ZonedDateTime;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.items.events.ItemEvent;
import org.openhab.core.types.State;

@NonNullByDefault
public class ItemStateChangedEvent
extends ItemEvent {
    public static final String TYPE = ItemStateChangedEvent.class.getSimpleName();
    protected final State itemState;
    protected final State oldItemState;
    protected final @Nullable ZonedDateTime lastStateUpdate;
    protected final @Nullable ZonedDateTime lastStateChange;

    protected ItemStateChangedEvent(String topic, String payload, String itemName, State newItemState, State oldItemState, @Nullable ZonedDateTime lastStateUpdate, @Nullable ZonedDateTime lastStateChange, @Nullable String source) {
        super(topic, payload, itemName, source);
        this.itemState = newItemState;
        this.oldItemState = oldItemState;
        this.lastStateUpdate = lastStateUpdate;
        this.lastStateChange = lastStateChange;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public State getItemState() {
        return this.itemState;
    }

    public State getOldItemState() {
        return this.oldItemState;
    }

    public @Nullable ZonedDateTime getLastStateUpdate() {
        return this.lastStateUpdate;
    }

    public @Nullable ZonedDateTime getLastStateChange() {
        return this.lastStateChange;
    }

    public String toString() {
        String result = String.format("Item '%s' changed from %s to %s", this.itemName, this.oldItemState, this.itemState);
        String source = this.getSource();
        if (source != null) {
            result = String.format("%s (source: %s)", result, source);
        }
        return result;
    }
}

