/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.comm;

import java.io.IOException;
import java.io.OutputStream;
import javax.comm.CommPort;
import org.eclipse.soda.dk.comm.NSParallelPort;
import org.eclipse.soda.dk.comm.NSSerialPort;

public class NSDeviceOutputStream
extends OutputStream {
    int fd = -1;
    private int pt;
    private int bufsize;
    private NSSerialPort sp = null;
    private NSParallelPort pp = null;
    private byte[] buffer = null;

    NSDeviceOutputStream(CommPort port, int portType) {
        if (portType == 2) {
            this.pt = 1;
            this.pp = (NSParallelPort)port;
            this.bufsize = this.pp.outsBufferSize;
        } else {
            this.pt = 2;
            this.sp = (NSSerialPort)port;
            this.bufsize = this.sp.outsBufferSize;
        }
        this.buffer = new byte[this.bufsize];
    }

    @Override
    public void flush() throws IOException {
        int obc = 0;
        if (this.pp != null) {
            obc = this.pp.outsBufferCount;
        } else if (this.sp != null) {
            obc = this.sp.outsBufferCount;
        }
        int rc = this.writeDeviceNC(this.buffer, 0, obc);
        if (rc != obc) {
            IOException e = new IOException();
            throw e;
        }
    }

    public int getPt() {
        return this.pt;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int rc;
        int toff = off;
        int tlen = len;
        boolean excflag = false;
        int obc = 0;
        int oldbufsize = this.bufsize;
        boolean notify = false;
        this.bufsize = 0;
        if (this.pp != null) {
            this.bufsize = this.pp.outsBufferSize;
            obc = this.pp.outsBufferCount;
        } else if (this.sp != null) {
            this.bufsize = this.sp.outsBufferSize;
            obc = this.sp.outsBufferCount;
        }
        if (this.bufsize != oldbufsize) {
            if (obc != 0) {
                rc = this.writeDeviceNC(this.buffer, 0, obc);
                if (this.pp != null) {
                    this.pp.outsBufferCount = 0;
                } else if (this.sp != null) {
                    this.sp.outsBufferCount = 0;
                }
                if (rc != obc) {
                    excflag = true;
                }
            }
            this.buffer = null;
            this.buffer = new byte[this.bufsize];
        }
        if (this.bufsize == 0) {
            if (this.pp != null) {
                this.pp.outsBufferCount = 0;
            } else if (this.sp != null) {
                this.sp.outsBufferCount = 0;
            }
            rc = this.writeDeviceNC(b, toff, tlen);
            if (rc != tlen) {
                excflag = true;
            }
        } else {
            while (tlen != 0) {
                int wc;
                if (this.pp != null) {
                    obc = this.pp.outsBufferCount;
                } else if (this.sp != null) {
                    obc = this.sp.outsBufferCount;
                }
                if (obc + tlen >= this.bufsize) {
                    wc = this.bufsize - obc;
                    System.arraycopy(b, toff, this.buffer, obc, wc);
                    rc = this.writeDeviceNC(this.buffer, 0, this.bufsize);
                    if (this.pp != null) {
                        this.pp.outsBufferCount = 0;
                    } else if (this.sp != null) {
                        this.sp.outsBufferCount = 0;
                    }
                    if (rc != this.bufsize) {
                        excflag = true;
                        break;
                    }
                } else {
                    wc = tlen;
                    System.arraycopy(b, toff, this.buffer, obc, wc);
                    if (this.pp != null) {
                        this.pp.outsBufferCount += wc;
                    } else if (this.sp != null) {
                        this.sp.outsBufferCount += wc;
                    }
                }
                toff += wc;
                tlen -= wc;
            }
        }
        if (excflag) {
            IOException e = new IOException();
            throw e;
        }
        if (this.pp != null) {
            obc = this.pp.outsBufferCount;
            notify = this.pp.notifyOnBufferFlag;
        } else if (this.sp != null) {
            obc = this.sp.outsBufferCount;
            notify = this.sp.notifyOnBufferFlag;
        }
        if (notify && obc == 0) {
            if (this.pp != null) {
                this.pp.reportParallelEvent(2, false, true);
            } else if (this.sp != null) {
                this.sp.reportSerialEvent(2, false, true);
            }
        }
    }

    @Override
    public void write(int i) throws IOException {
        byte[] b = new byte[]{(byte)(i & 0xFF)};
        this.write(b, 0, 1);
    }

    private native int writeDeviceNC(byte[] var1, int var2, int var3);
}

