/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util;

import java.io.IOException;
import java.io.Writer;

public class MemoryStringWriter
extends Writer {
    private int bufferIncrement;
    private int cursor;
    private char[] buffer;

    public MemoryStringWriter() {
        this(4096);
    }

    public MemoryStringWriter(int n) {
        this.bufferIncrement = n;
        this.buffer = new char[n];
    }

    @Override
    public synchronized void write(char[] cArray, int n, int n2) throws IOException {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (cArray == null) {
            throw new NullPointerException();
        }
        if (n2 + n > cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureSize(this.cursor + n2);
        System.arraycopy(cArray, n, this.buffer, this.cursor, n2);
        this.cursor += n2;
    }

    private void ensureSize(int n) {
        if (this.buffer.length >= n) {
            return;
        }
        int n2 = Math.max(n, this.buffer.length + this.bufferIncrement);
        char[] cArray = new char[n2];
        System.arraycopy(this.buffer, 0, cArray, 0, this.cursor);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    public String toString() {
        return new String(this.buffer, 0, this.cursor);
    }
}

