/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.deployment;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

public class CustomPathExtension {
    static final Set<DotName> APPLICATION_PATH = new TreeSet<DotName>(Arrays.asList(DotName.createSimple((String)"jakarta.ws.rs.ApplicationPath"), DotName.createSimple((String)"javax.ws.rs.ApplicationPath")));
    private final String rootPath;
    private final String appPath;

    public CustomPathExtension(String rootPath, String appPath) {
        this.rootPath = rootPath;
        this.appPath = appPath;
    }

    public String resolveContextRoot(Collection<ClassInfo> applications) {
        Optional<String> appPathAnnotationValue = applications.stream().flatMap(app -> APPLICATION_PATH.stream().map(arg_0 -> ((ClassInfo)app).declaredAnnotation(arg_0))).filter(Objects::nonNull).map(AnnotationInstance::value).map(AnnotationValue::asString).findFirst();
        String contextRoot = appPathAnnotationValue.map(path -> CustomPathExtension.buildContextRoot(this.rootPath)).orElseGet(() -> CustomPathExtension.buildContextRoot(this.rootPath, this.appPath));
        return "/".equals(contextRoot) ? null : contextRoot;
    }

    static String buildContextRoot(String ... segments) {
        String path = Stream.of(segments).filter(Objects::nonNull).map(CustomPathExtension::stripSlashes).filter(Predicate.not(String::isEmpty)).map("/"::concat).collect(Collectors.joining());
        return path.isEmpty() ? "/" : path;
    }

    static String stripSlashes(String segment) {
        if (segment.startsWith("/")) {
            segment = segment.substring(1);
        }
        if (segment.endsWith("/")) {
            segment = segment.substring(0, segment.length() - 1);
        }
        return segment;
    }
}

