/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph;

import java.util.BitSet;
import org.hibernate.metamodel.mapping.EntityVersionMapping;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.FetchableContainer;
import org.hibernate.sql.results.graph.internal.ImmutableFetchList;
import org.hibernate.type.descriptor.java.JavaType;

public abstract class AbstractFetchParent
implements FetchParent {
    private final NavigablePath navigablePath;
    private ImmutableFetchList fetches = ImmutableFetchList.EMPTY;
    private boolean hasJoinFetches;
    private boolean containsCollectionFetches;

    public AbstractFetchParent(NavigablePath navigablePath) {
        this.navigablePath = navigablePath;
    }

    public AbstractFetchParent(AbstractFetchParent original) {
        this.navigablePath = original.navigablePath;
        this.fetches = original.fetches;
        this.hasJoinFetches = original.hasJoinFetches;
        this.containsCollectionFetches = original.containsCollectionFetches;
    }

    public void afterInitialize(FetchParent fetchParent, DomainResultCreationState creationState) {
        assert (this.fetches == ImmutableFetchList.EMPTY);
        this.resetFetches(creationState.visitFetches(fetchParent));
    }

    protected void resetFetches(ImmutableFetchList newFetches) {
        this.fetches = newFetches;
        this.hasJoinFetches = newFetches.hasJoinFetches();
        this.containsCollectionFetches = newFetches.containsCollectionFetches();
    }

    public abstract FetchableContainer getFetchContainer();

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public JavaType<?> getResultJavaType() {
        return this.getFetchContainer().getJavaType();
    }

    @Override
    public FetchableContainer getReferencedMappingContainer() {
        return this.getFetchContainer();
    }

    @Override
    public ImmutableFetchList getFetches() {
        return this.fetches;
    }

    @Override
    public Fetch findFetch(Fetchable fetchable) {
        if (fetchable instanceof EntityVersionMapping) {
            EntityVersionMapping entityVersionMapping = (EntityVersionMapping)fetchable;
            return this.fetches.get(entityVersionMapping.getVersionAttribute());
        }
        return this.fetches.get(fetchable);
    }

    @Override
    public boolean hasJoinFetches() {
        return this.hasJoinFetches;
    }

    @Override
    public boolean containsCollectionFetches() {
        return this.containsCollectionFetches;
    }

    @Override
    public void collectValueIndexesToCache(BitSet valueIndexes) {
        FetchParent.super.collectValueIndexesToCache(valueIndexes);
    }
}

