/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.AttributeConverter;
import java.util.HashMap;
import org.hibernate.annotations.Parameter;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.resource.beans.internal.FallbackBeanInstanceProducer;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.type.BasicType;
import org.hibernate.type.CustomType;
import org.hibernate.type.descriptor.converter.internal.ConverterHelper;
import org.hibernate.type.descriptor.converter.spi.JpaAttributeConverter;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.internal.ConvertedBasicTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.usertype.UserType;

public class AnnotationHelper {
    public static HashMap<String, String> extractParameterMap(Parameter[] parameters) {
        HashMap<String, String> paramMap = CollectionHelper.mapOfSize(parameters.length);
        for (Parameter parameter : parameters) {
            paramMap.put(parameter.name(), parameter.value());
        }
        return paramMap;
    }

    public static JdbcMapping resolveUserType(Class<UserType<?>> userTypeClass, MetadataBuildingContext context) {
        BootstrapContext bootstrapContext = context.getBootstrapContext();
        UserType<?> userType = context.getBuildingOptions().isAllowExtensionsInCdi() ? bootstrapContext.getManagedBeanRegistry().getBean(userTypeClass).getBeanInstance() : FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(userTypeClass);
        return new CustomType(userType, bootstrapContext.getTypeConfiguration());
    }

    public static <X, Y> JdbcMapping resolveAttributeConverter(Class<? extends AttributeConverter<? extends X, ? extends Y>> type, MetadataBuildingContext context) {
        ManagedBean<AttributeConverter<X, Y>> bean;
        BootstrapContext bootstrapContext = context.getBootstrapContext();
        TypeConfiguration typeConfiguration = bootstrapContext.getTypeConfiguration();
        ManagedBean<AttributeConverter<X, Y>> castBean = bean = bootstrapContext.getManagedBeanRegistry().getBean(type);
        JavaTypeRegistry registry = typeConfiguration.getJavaTypeRegistry();
        JpaAttributeConverter valueConverter = ConverterHelper.createJpaAttributeConverter(castBean, registry);
        return new ConvertedBasicTypeImpl("converted::" + valueConverter.getConverterJavaType().getTypeName(), String.format("BasicType adapter for AttributeConverter<%s,%s>", valueConverter.getDomainJavaType().getTypeName(), valueConverter.getRelationalJavaType().getTypeName()), registry.resolveDescriptor(valueConverter.getRelationalJavaType().getJavaType()).getRecommendedJdbcType(typeConfiguration.getCurrentBaseSqlTypeIndicators()), valueConverter);
    }

    public static BasicType<Object> resolveBasicType(Class<?> type, final MetadataBuildingContext context) {
        final TypeConfiguration typeConfiguration = context.getBootstrapContext().getTypeConfiguration();
        JavaType jtd = typeConfiguration.getJavaTypeRegistry().findDescriptor(type);
        if (jtd != null) {
            JdbcType jdbcType = jtd.getRecommendedJdbcType(new JdbcTypeIndicators(){

                @Override
                public TypeConfiguration getTypeConfiguration() {
                    return typeConfiguration;
                }

                @Override
                public int getPreferredSqlTypeCodeForBoolean() {
                    return context.getPreferredSqlTypeCodeForBoolean();
                }

                @Override
                public int getPreferredSqlTypeCodeForDuration() {
                    return context.getPreferredSqlTypeCodeForDuration();
                }

                @Override
                public int getPreferredSqlTypeCodeForUuid() {
                    return context.getPreferredSqlTypeCodeForUuid();
                }

                @Override
                public int getPreferredSqlTypeCodeForInstant() {
                    return context.getPreferredSqlTypeCodeForInstant();
                }

                @Override
                public int getPreferredSqlTypeCodeForArray() {
                    return context.getPreferredSqlTypeCodeForArray();
                }

                @Override
                public Dialect getDialect() {
                    return context.getMetadataCollector().getDatabase().getDialect();
                }
            });
            return typeConfiguration.getBasicTypeRegistry().resolve(jtd, jdbcType);
        }
        return null;
    }

    public static JdbcMapping resolveJavaType(Class<JavaType<?>> type, MetadataBuildingContext context) {
        TypeConfiguration typeConfiguration = context.getBootstrapContext().getTypeConfiguration();
        JavaType<?> jtd = AnnotationHelper.getJavaType(type, context, typeConfiguration);
        JdbcType jdbcType = jtd.getRecommendedJdbcType(typeConfiguration.getCurrentBaseSqlTypeIndicators());
        return typeConfiguration.getBasicTypeRegistry().resolve(jtd, jdbcType);
    }

    private static JavaType<?> getJavaType(Class<JavaType<?>> javaTypeClass, MetadataBuildingContext context, TypeConfiguration typeConfiguration) {
        JavaType registeredJtd = typeConfiguration.getJavaTypeRegistry().findDescriptor(javaTypeClass);
        if (registeredJtd != null) {
            return registeredJtd;
        }
        if (!context.getBuildingOptions().isAllowExtensionsInCdi()) {
            return FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(javaTypeClass);
        }
        return context.getBootstrapContext().getManagedBeanRegistry().getBean(javaTypeClass).getBeanInstance();
    }
}

