/*
 * Decompiled with CFR 0.152.
 */
package jakarta.el;

import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.PropertyNotWritableException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MapELResolver
extends ELResolver {
    private static Class<?> theUnmodifiableMapClass = Collections.unmodifiableMap(new HashMap()).getClass();
    private boolean isReadOnly;

    public MapELResolver() {
        this.isReadOnly = false;
    }

    public MapELResolver(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base != null && base instanceof Map) {
            context.setPropertyResolved(true);
            Map map = (Map)base;
            if (this.isReadOnly || map.getClass() == theUnmodifiableMapClass) {
                return null;
            }
            return Object.class;
        }
        return null;
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base != null && base instanceof Map) {
            context.setPropertyResolved(base, property);
            Map map = (Map)base;
            return map.get(property);
        }
        return null;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object val) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base != null && base instanceof Map) {
            context.setPropertyResolved(base, property);
            Map map = (Map)base;
            if (this.isReadOnly || map.getClass() == theUnmodifiableMapClass) {
                throw new PropertyNotWritableException();
            }
            try {
                map.put(property, val);
            }
            catch (UnsupportedOperationException ex) {
                throw new PropertyNotWritableException();
            }
        }
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base != null && base instanceof Map) {
            context.setPropertyResolved(true);
            Map map = (Map)base;
            return this.isReadOnly || map.getClass() == theUnmodifiableMapClass;
        }
        return false;
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base != null && base instanceof Map) {
            return Object.class;
        }
        return null;
    }
}

