/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.internal.models.security;

import io.smallrye.openapi.model.BaseExtensibleModel;
import io.smallrye.openapi.model.DataType;
import io.smallrye.openapi.model.OpenApiVersion;
import io.smallrye.openapi.model.PropertyMetadata;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class OAuthFlow
extends BaseExtensibleModel<org.eclipse.microprofile.openapi.models.security.OAuthFlow>
implements org.eclipse.microprofile.openapi.models.security.OAuthFlow {
    public static final PropertyMetadata PROPERTIES = new Properties();

    public PropertyMetadata getPropertyMetadata() {
        return PROPERTIES;
    }

    public String getAuthorizationUrl() {
        return (String)this.getProperty("authorizationUrl", String.class);
    }

    public void setAuthorizationUrl(String newValue) {
        this.setProperty("authorizationUrl", newValue);
    }

    public String getTokenUrl() {
        return (String)this.getProperty("tokenUrl", String.class);
    }

    public void setTokenUrl(String newValue) {
        this.setProperty("tokenUrl", newValue);
    }

    public String getRefreshUrl() {
        return (String)this.getProperty("refreshUrl", String.class);
    }

    public void setRefreshUrl(String newValue) {
        this.setProperty("refreshUrl", newValue);
    }

    public Map<String, String> getScopes() {
        return this.getMapProperty("scopes");
    }

    public void setScopes(Map<String, String> newValue) {
        this.setMapProperty("scopes", newValue);
    }

    public OAuthFlow addScope(String newKey, String newValue) {
        Objects.requireNonNull(newKey, "Key must not be null");
        Objects.requireNonNull(newValue, "Value must not be null");
        this.putMapPropertyEntry("scopes", newKey, newValue);
        return this;
    }

    public void removeScope(String key) {
        this.removeMapPropertyEntry("scopes", key);
    }

    public static class Properties
    implements PropertyMetadata {
        private final Map<String, DataType> types = new HashMap<String, DataType>(4);
        private final Map<String, OpenApiVersion> minVersions = new HashMap<String, OpenApiVersion>(4);

        public Properties() {
            this.types.put("authorizationUrl", DataType.type(String.class));
            this.minVersions.put("authorizationUrl", OpenApiVersion.V3_0);
            this.types.put("tokenUrl", DataType.type(String.class));
            this.minVersions.put("tokenUrl", OpenApiVersion.V3_0);
            this.types.put("refreshUrl", DataType.type(String.class));
            this.minVersions.put("refreshUrl", OpenApiVersion.V3_0);
            this.types.put("scopes", DataType.mapOf((DataType)DataType.type(String.class)));
            this.minVersions.put("scopes", OpenApiVersion.V3_0);
        }

        public DataType getPropertyType(String name) {
            if (this.types.containsKey(name)) {
                return this.types.get(name);
            }
            return DataType.type(Object.class);
        }

        public OpenApiVersion getMinVersion(String name) {
            return this.minVersions.getOrDefault(name, OpenApiVersion.V3_0);
        }
    }
}

