/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.support;

import jakarta.persistence.EntityManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.hibernate.Session;
import org.keycloak.connections.jpa.support.EntityManagerProxy;
import org.keycloak.models.KeycloakSession;

public class EntityManagers {
    static final String ENTITY_MANAGER_PROXIES = "ENTITY_MANAGER_PROXIES";
    private static final ThreadLocal<Boolean> batchMode = new ThreadLocal();

    static void runInBatchMode(Runnable runnable) {
        boolean isBatched = EntityManagers.isBatchMode();
        batchMode.set(true);
        try {
            runnable.run();
        }
        finally {
            if (!isBatched) {
                batchMode.remove();
            }
        }
    }

    public static boolean isBatchMode() {
        return Boolean.TRUE.equals(batchMode.get());
    }

    static void forEachEntityManager(KeycloakSession session, Consumer<EntityManager> op) {
        try {
            EntityManagers.getEntityManagerProxies(session).map(EntityManagerProxy::getEntityManager).filter(EntityManager::isOpen).forEach(op);
        }
        catch (Exception e) {
            throw EntityManagerProxy.convert(e);
        }
    }

    static Stream<EntityManagerProxy> getEntityManagerProxies(KeycloakSession session) {
        return Optional.ofNullable((Set)session.getAttribute(ENTITY_MANAGER_PROXIES, Set.class)).map(Collection::stream).orElse(Stream.of(new EntityManagerProxy[0]));
    }

    public static void flush(KeycloakSession session, boolean clear) {
        EntityManagers.forEachEntityManager(session, em -> {
            em.flush();
            if (clear) {
                em.clear();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runInBatch(KeycloakSession session, Runnable runnable, boolean nestedEntityManagers) {
        HashMap previous = new HashMap();
        EntityManagers.flush(session, false);
        if (nestedEntityManagers) {
            EntityManagers.getEntityManagerProxies(session).forEach(p -> {
                if (!p.getEntityManager().isOpen()) {
                    return;
                }
                Session em = (Session)p.getEntityManager().unwrap(Session.class);
                Session derived = em.sessionWithOptions().connection().openSession();
                previous.put(p, em);
                p.setEntityManager((EntityManager)derived);
            });
        }
        try {
            EntityManagers.runInBatchMode(runnable);
            if (nestedEntityManagers) {
                EntityManagers.flush(session, true);
            }
        }
        finally {
            if (nestedEntityManagers) {
                EntityManagers.getEntityManagerProxies(session).forEach(p -> {
                    EntityManager current = p.getEntityManager();
                    EntityManager old = (EntityManager)previous.get(p);
                    if (old != null) {
                        if (current.isOpen()) {
                            current.close();
                        }
                        p.setEntityManager(old);
                    }
                });
            }
        }
    }
}

