/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.attribute;

import io.quarkus.vertx.http.runtime.attribute.ExchangeAttribute;
import io.quarkus.vertx.http.runtime.attribute.ExchangeAttributeBuilder;
import io.quarkus.vertx.http.runtime.attribute.ReadOnlyAttributeException;
import io.quarkus.vertx.http.runtime.filters.OriginalRequestContext;
import io.vertx.ext.web.RoutingContext;

public class RequestPathAttribute
implements ExchangeAttribute {
    public static final String REQUEST_PATH = "%{REQUEST_PATH}";
    public static final String REQUEST_PATH_SHORT = "%R";
    public static final String ORIGINAL_REQUEST_PATH = "%{<REQUEST_PATH}";
    public static final String ORIGINAL_REQUEST_PATH_SHORT = "%<R";
    public static final ExchangeAttribute INSTANCE = new RequestPathAttribute(false);
    public static final ExchangeAttribute INSTANCE_ORIGINAL_REQUEST = new RequestPathAttribute(true);
    private final boolean useOriginalRequest;

    private RequestPathAttribute(boolean useOriginalRequest) {
        this.useOriginalRequest = useOriginalRequest;
    }

    @Override
    public String readAttribute(RoutingContext exchange) {
        return this.useOriginalRequest ? OriginalRequestContext.getPath(exchange) : exchange.request().path();
    }

    @Override
    public void writeAttribute(RoutingContext exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException();
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Request Path";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(RequestPathAttribute.ORIGINAL_REQUEST_PATH) || token.equals(RequestPathAttribute.ORIGINAL_REQUEST_PATH_SHORT)) {
                return INSTANCE_ORIGINAL_REQUEST;
            }
            return token.equals(RequestPathAttribute.REQUEST_PATH) || token.equals(RequestPathAttribute.REQUEST_PATH_SHORT) ? INSTANCE : null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

