/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.bootstrap.runner.RunnerClassLoader;
import io.quarkus.runtime.ApplicationLifecycleManager;
import io.quarkus.runtime.Quarkus;
import io.quarkus.runtime.QuarkusApplication;
import io.quarkus.runtime.annotations.QuarkusMain;
import jakarta.enterprise.context.ApplicationScoped;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import org.jboss.logging.Logger;
import org.keycloak.common.Version;
import org.keycloak.infinispan.util.InfinispanUtils;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.cli.ExecutionExceptionHandler;
import org.keycloak.quarkus.runtime.cli.Picocli;
import org.keycloak.quarkus.runtime.cli.PropertyException;
import org.keycloak.quarkus.runtime.cli.command.AbstractNonServerCommand;
import org.keycloak.quarkus.runtime.cli.command.DryRunMixin;
import org.keycloak.quarkus.runtime.cli.command.Start;
import org.keycloak.quarkus.runtime.configuration.PersistedConfigSource;
import org.keycloak.quarkus.runtime.integration.jaxrs.QuarkusKeycloakApplication;

@QuarkusMain(name="keycloak")
@ApplicationScoped
public class KeycloakMain
implements QuarkusApplication {
    private static AbstractNonServerCommand COMMAND;

    public static void main(String[] args) {
        KeycloakMain.ensureForkJoinPoolThreadFactoryHasBeenSetToQuarkus();
        InfinispanUtils.ensureVirtualThreadsParallelism();
        System.setProperty("kc.version", Version.VERSION);
        Picocli picocli = !(Thread.currentThread().getContextClassLoader() instanceof RunnerClassLoader) ? new Picocli(){

            @Override
            public void exit(int exitCode) {
                Quarkus.asyncExit((int)exitCode);
            }
        } : new Picocli();
        KeycloakMain.main(args, picocli);
    }

    public static void main(String[] args, Picocli picocli) {
        List<String> cliArgs = null;
        try {
            cliArgs = Picocli.parseArgs(args);
        }
        catch (PropertyException e) {
            picocli.usageException(e.getMessage(), e.getCause());
            return;
        }
        if (DryRunMixin.isDryRunBuild() && (cliArgs.contains("--dry-run") || Boolean.valueOf(System.getenv().get("KC_DRY_RUN")).booleanValue())) {
            PersistedConfigSource.getInstance().useDryRunProperties();
        }
        if (cliArgs.isEmpty()) {
            cliArgs = new ArrayList<String>(cliArgs);
            cliArgs.add("-h");
        } else if (KeycloakMain.isFastStart(cliArgs)) {
            Start.fastStart(picocli, Boolean.valueOf(System.getenv().get("KC_DRY_RUN")));
            return;
        }
        picocli.parseAndRun(cliArgs);
    }

    private static void ensureForkJoinPoolThreadFactoryHasBeenSetToQuarkus() {
        String FORK_JOIN_POOL_COMMON_THREAD_FACTORY = "java.util.concurrent.ForkJoinPool.common.threadFactory";
        String sf = System.getProperty("java.util.concurrent.ForkJoinPool.common.threadFactory");
        if (!ForkJoinPool.commonPool().getFactory().getClass().getName().equals(sf)) {
            Logger.getLogger(KeycloakMain.class).errorf("The ForkJoinPool has been initialized with the wrong thread factory. The property '%s' should be set on the Java CLI to ensure Java's ForkJoinPool will always be initialized with '%s' even if there are Java agents which might initialize logging or other capabilities earlier than the main method.", (Object)"java.util.concurrent.ForkJoinPool.common.threadFactory", (Object)sf);
            throw new RuntimeException("The ForkJoinPool has been initialized with the wrong thread factory");
        }
    }

    private static boolean isFastStart(List<String> cliArgs) {
        return cliArgs.size() == 2 && cliArgs.get(0).equals("start") && cliArgs.stream().anyMatch("--optimized"::equals);
    }

    public static void start(Picocli picocli, AbstractNonServerCommand command, ExecutionExceptionHandler errorHandler) {
        COMMAND = command;
        try {
            Quarkus.run(KeycloakMain.class, (exitCode, cause) -> {
                if (cause != null) {
                    errorHandler.error(picocli.getErrWriter(), String.format("Failed to start server in (%s) mode", Environment.getKeycloakModeFromProfile(org.keycloak.common.util.Environment.getProfile())), cause.getCause());
                }
                picocli.exit((int)exitCode);
            }, (String[])new String[0]);
        }
        catch (Throwable cause2) {
            errorHandler.error(picocli.getErrWriter(), String.format("Unexpected error when starting the server in (%s) mode", Environment.getKeycloakModeFromProfile(org.keycloak.common.util.Environment.getProfile())), cause2.getCause());
        }
        picocli.exit(1);
    }

    public int run(String ... args) throws Exception {
        if (COMMAND != null) {
            QuarkusKeycloakApplication application = (QuarkusKeycloakApplication)((Object)Arc.container().instance(QuarkusKeycloakApplication.class, new Annotation[0]).get());
            COMMAND.onStart(application);
        }
        if (Environment.isTestLaunchMode() || Environment.isNonServerMode()) {
            Quarkus.asyncExit((int)ApplicationLifecycleManager.getExitCode());
        } else {
            Quarkus.waitForExit();
        }
        return ApplicationLifecycleManager.getExitCode();
    }

    static {
        InfinispanUtils.configureVirtualThreads();
    }
}

