/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.ivars;

import java.lang.invoke.VarHandle;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.runtime.ivars.VariableAccessor;
import org.jruby.util.ArraySupport;

public class AtomicVariableTable {
    public static void setVariableAtomic(RubyBasicObject self2, RubyClass realClass, boolean fullFence, int index2, Object value2) {
        Object[] currentTable;
        int currentStamp;
        while (((currentStamp = self2.varTableStamp) & 1) != 0 || ((currentTable = VariableAccessor.VAR_TABLE_HANDLE.getVolatile(self2)) == null || index2 >= currentTable.length ? !AtomicVariableTable.createTableAtomic(self2, currentStamp, realClass, currentTable, index2, value2) : !AtomicVariableTable.updateTableAtomic(self2, currentStamp, currentTable, index2, value2))) {
        }
    }

    private static boolean createTableAtomic(RubyBasicObject self2, int currentStamp, RubyClass realClass, Object[] currentTable, int index2, Object value2) {
        if (!VariableAccessor.STAMP_HANDLE.compareAndSet(self2, currentStamp++, currentStamp)) {
            return false;
        }
        Object[] newTable = new Object[realClass.getVariableTableSizeWithExtras()];
        if (currentTable != null) {
            ArraySupport.copy(currentTable, 0, newTable, 0, currentTable.length);
        } else if (self2 instanceof JavaProxy) {
            ((JavaProxy)self2).checkVariablesOnProxy();
        }
        newTable[index2] = value2;
        VariableAccessor.VAR_TABLE_HANDLE.setRelease(self2, newTable);
        self2.varTableStamp = currentStamp + 1;
        return true;
    }

    private static boolean updateTableAtomic(RubyBasicObject self2, int currentStamp, Object[] currentTable, int index2, Object value2) {
        currentTable[index2] = value2;
        VarHandle.fullFence();
        return self2.varTableStamp == currentStamp;
    }
}

