/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.declarativedsl.analysis;

import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.declarative.dsl.schema.DataType;
import org.gradle.declarative.dsl.schema.FunctionSemantics;
import org.gradle.internal.declarativedsl.analysis.AnalysisContext;
import org.gradle.internal.declarativedsl.analysis.AnalysisScope;
import org.gradle.internal.declarativedsl.analysis.AssignmentMethod;
import org.gradle.internal.declarativedsl.analysis.AssignmentRecord;
import org.gradle.internal.declarativedsl.analysis.DefaultAnalysisSchemaKt;
import org.gradle.internal.declarativedsl.analysis.ErrorCollector;
import org.gradle.internal.declarativedsl.analysis.ErrorReason;
import org.gradle.internal.declarativedsl.analysis.ExpectedTypeData;
import org.gradle.internal.declarativedsl.analysis.ExpressionResolver;
import org.gradle.internal.declarativedsl.analysis.FunctionCallResolver;
import org.gradle.internal.declarativedsl.analysis.NamedReferenceResolver;
import org.gradle.internal.declarativedsl.analysis.ObjectOrigin;
import org.gradle.internal.declarativedsl.analysis.PropertyReferenceResolution;
import org.gradle.internal.declarativedsl.analysis.ResolutionError;
import org.gradle.internal.declarativedsl.analysis.StatementResolver;
import org.gradle.internal.declarativedsl.analysis.TypedOrigin;
import org.gradle.internal.declarativedsl.analysis.UtilsKt;
import org.gradle.internal.declarativedsl.language.Assignment;
import org.gradle.internal.declarativedsl.language.AugmentingAssignment;
import org.gradle.internal.declarativedsl.language.DataStatement;
import org.gradle.internal.declarativedsl.language.Expr;
import org.gradle.internal.declarativedsl.language.FunctionCall;
import org.gradle.internal.declarativedsl.language.LocalValue;
import org.gradle.internal.declarativedsl.language.NamedReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002JB\u0010\u001e\u001a\u0004\u0018\u00010\f*\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00162\u001a\u0010$\u001a\u0016\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'\u0012\u0006\u0012\u0004\u0018\u00010\f0%H\u0002J\u0014\u0010(\u001a\u00020\u0014*\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/gradle/internal/declarativedsl/analysis/StatementResolverImpl;", "Lorg/gradle/internal/declarativedsl/analysis/StatementResolver;", "namedReferenceResolver", "Lorg/gradle/internal/declarativedsl/analysis/NamedReferenceResolver;", "functionCallResolver", "Lorg/gradle/internal/declarativedsl/analysis/FunctionCallResolver;", "expressionResolver", "Lorg/gradle/internal/declarativedsl/analysis/ExpressionResolver;", "errorCollector", "Lorg/gradle/internal/declarativedsl/analysis/ErrorCollector;", "(Lorg/gradle/internal/declarativedsl/analysis/NamedReferenceResolver;Lorg/gradle/internal/declarativedsl/analysis/FunctionCallResolver;Lorg/gradle/internal/declarativedsl/analysis/ExpressionResolver;Lorg/gradle/internal/declarativedsl/analysis/ErrorCollector;)V", "doResolveAssignment", "Lorg/gradle/internal/declarativedsl/analysis/AssignmentRecord;", "context", "Lorg/gradle/internal/declarativedsl/analysis/AnalysisContext;", "assignment", "Lorg/gradle/internal/declarativedsl/language/Assignment;", "doResolveAugmentingAssignment", "Lorg/gradle/internal/declarativedsl/language/AugmentingAssignment;", "doResolveExpressionStatement", "", "expr", "Lorg/gradle/internal/declarativedsl/language/Expr;", "doResolveLocalValue", "localValue", "Lorg/gradle/internal/declarativedsl/language/LocalValue;", "isDanglingPureCall", "", "obj", "Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin$FunctionOrigin;", "doAnalyzeAssignmentLikeStatement", "statement", "Lorg/gradle/internal/declarativedsl/language/DataStatement;", "lhs", "Lorg/gradle/internal/declarativedsl/language/NamedReference;", "rhs", "doRecordAssignment", "Lkotlin/Function2;", "Lorg/gradle/internal/declarativedsl/analysis/PropertyReferenceResolution;", "Lorg/gradle/internal/declarativedsl/analysis/TypedOrigin;", "doAnalyzeLocal", "declarative-dsl-core"})
public final class StatementResolverImpl
implements StatementResolver {
    @NotNull
    private final NamedReferenceResolver namedReferenceResolver;
    @NotNull
    private final FunctionCallResolver functionCallResolver;
    @NotNull
    private final ExpressionResolver expressionResolver;
    @NotNull
    private final ErrorCollector errorCollector;

    public StatementResolverImpl(@NotNull NamedReferenceResolver namedReferenceResolver, @NotNull FunctionCallResolver functionCallResolver, @NotNull ExpressionResolver expressionResolver, @NotNull ErrorCollector errorCollector) {
        Intrinsics.checkNotNullParameter((Object)namedReferenceResolver, (String)"namedReferenceResolver");
        Intrinsics.checkNotNullParameter((Object)functionCallResolver, (String)"functionCallResolver");
        Intrinsics.checkNotNullParameter((Object)expressionResolver, (String)"expressionResolver");
        Intrinsics.checkNotNullParameter((Object)errorCollector, (String)"errorCollector");
        this.namedReferenceResolver = namedReferenceResolver;
        this.functionCallResolver = functionCallResolver;
        this.expressionResolver = expressionResolver;
        this.errorCollector = errorCollector;
    }

    @Override
    @Nullable
    public AssignmentRecord doResolveAssignment(@NotNull AnalysisContext context, @NotNull Assignment assignment) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)assignment, (String)"assignment");
        return this.doAnalyzeAssignmentLikeStatement(context, assignment, assignment.getLhs(), assignment.getRhs(), (Function2<? super PropertyReferenceResolution, ? super TypedOrigin, AssignmentRecord>)((Function2)new Function2<PropertyReferenceResolution, TypedOrigin, AssignmentRecord>(context, assignment){
            final /* synthetic */ AnalysisContext $context;
            final /* synthetic */ Assignment $assignment;
            {
                this.$context = $context;
                this.$assignment = $assignment;
                super(2);
            }

            public final AssignmentRecord invoke(PropertyReferenceResolution lhsResolution, TypedOrigin rhsResolution) {
                Intrinsics.checkNotNullParameter((Object)lhsResolution, (String)"lhsResolution");
                Intrinsics.checkNotNullParameter((Object)rhsResolution, (String)"rhsResolution");
                return this.$context.recordAssignment(lhsResolution, rhsResolution, AssignmentMethod.Property.INSTANCE, this.$assignment);
            }
        }));
    }

    @Override
    @Nullable
    public AssignmentRecord doResolveAugmentingAssignment(@NotNull AnalysisContext context, @NotNull AugmentingAssignment assignment) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)assignment, (String)"assignment");
        return this.doAnalyzeAssignmentLikeStatement(context, assignment, assignment.getLhs(), assignment.getRhs(), (Function2<? super PropertyReferenceResolution, ? super TypedOrigin, AssignmentRecord>)((Function2)new Function2<PropertyReferenceResolution, TypedOrigin, AssignmentRecord>(assignment, this, context){
            final /* synthetic */ AugmentingAssignment $assignment;
            final /* synthetic */ StatementResolverImpl this$0;
            final /* synthetic */ AnalysisContext $context;
            {
                this.$assignment = $assignment;
                this.this$0 = $receiver;
                this.$context = $context;
                super(2);
            }

            public final AssignmentRecord invoke(PropertyReferenceResolution lhsResolution, TypedOrigin rhsResolution) {
                AssignmentRecord assignmentRecord;
                Intrinsics.checkNotNullParameter((Object)lhsResolution, (String)"lhsResolution");
                Intrinsics.checkNotNullParameter((Object)rhsResolution, (String)"rhsResolution");
                ObjectOrigin.PropertyReference augmentedProperty = new ObjectOrigin.PropertyReference(lhsResolution.getReceiverObject(), lhsResolution.getProperty(), this.$assignment.getLhs());
                TypedOrigin augmentationCallResult = StatementResolverImpl.access$getFunctionCallResolver$p(this.this$0).doResolveAugmentation(augmentedProperty, rhsResolution, this.$context, this.$assignment.getAugmentationKind(), this.$assignment);
                if (augmentationCallResult != null) {
                    ObjectOrigin.AugmentationOrigin augmentedOrigin = new ObjectOrigin.AugmentationOrigin(augmentedProperty, rhsResolution.getObjectOrigin(), this.$assignment.getAugmentationKind(), augmentationCallResult.getObjectOrigin(), this.$assignment);
                    assignmentRecord = this.$context.recordAugmentingAssignment(lhsResolution, augmentedOrigin, this.$assignment);
                } else {
                    DataType propertyType = this.$context.resolveRef(lhsResolution.getProperty().getValueType());
                    StatementResolverImpl.access$getErrorCollector$p(this.this$0).collect(new ResolutionError(this.$assignment, new ErrorReason.AugmentingAssignmentNotResolved(propertyType)));
                    assignmentRecord = null;
                }
                return assignmentRecord;
            }
        }));
    }

    @Override
    public void doResolveLocalValue(@NotNull AnalysisContext context, @NotNull LocalValue localValue2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)localValue2, (String)"localValue");
        this.doAnalyzeLocal(context, localValue2);
    }

    @Override
    public void doResolveExpressionStatement(@NotNull AnalysisContext context, @NotNull Expr expr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        TypedOrigin resolvedExpr = this.expressionResolver.doResolveExpression(context, expr, ExpectedTypeData.NoExpectedType.INSTANCE);
        if (expr instanceof FunctionCall) {
            ObjectOrigin objectOrigin;
            TypedOrigin typedOrigin = resolvedExpr;
            ObjectOrigin objectOrigin2 = objectOrigin = typedOrigin != null ? typedOrigin.getObjectOrigin() : null;
            if (objectOrigin instanceof ObjectOrigin.FunctionOrigin && this.isDanglingPureCall((ObjectOrigin.FunctionOrigin)objectOrigin)) {
                this.errorCollector.collect(new ResolutionError(expr, ErrorReason.DanglingPureExpression.INSTANCE));
            }
        } else {
            this.errorCollector.collect(new ResolutionError(expr, ErrorReason.DanglingPureExpression.INSTANCE));
        }
    }

    private final AssignmentRecord doAnalyzeAssignmentLikeStatement(AnalysisContext $this$doAnalyzeAssignmentLikeStatement, DataStatement statement, NamedReference lhs2, Expr rhs, Function2<? super PropertyReferenceResolution, ? super TypedOrigin, AssignmentRecord> doRecordAssignment) {
        AssignmentRecord assignmentRecord;
        PropertyReferenceResolution lhsResolution = this.namedReferenceResolver.doResolveNamedReferenceToAssignable($this$doAnalyzeAssignmentLikeStatement, lhs2);
        if (lhsResolution == null) {
            $this$doAnalyzeAssignmentLikeStatement.getErrorCollector().collect(new ResolutionError(lhs2, new ErrorReason.UnresolvedReference(lhs2)));
            $this$doAnalyzeAssignmentLikeStatement.getErrorCollector().collect(new ResolutionError(statement, ErrorReason.UnresolvedAssignmentLhs.INSTANCE));
            assignmentRecord = null;
        } else {
            TypedOrigin rhsResolution;
            boolean hasErrors = false;
            if (DefaultAnalysisSchemaKt.isReadOnly(lhsResolution.getProperty())) {
                $this$doAnalyzeAssignmentLikeStatement.getErrorCollector().collect(new ResolutionError(statement, new ErrorReason.ReadOnlyPropertyAssignment(lhsResolution.getProperty())));
                hasErrors = true;
            }
            if ((rhsResolution = this.expressionResolver.doResolveExpression($this$doAnalyzeAssignmentLikeStatement, rhs, new ExpectedTypeData.ExpectedByProperty(lhsResolution.getProperty().getValueType()))) == null) {
                $this$doAnalyzeAssignmentLikeStatement.getErrorCollector().collect(new ResolutionError(statement, ErrorReason.UnresolvedAssignmentRhs.INSTANCE));
                assignmentRecord = null;
            } else {
                Map typeSubstitution;
                Map map2;
                DataType rhsType = rhsResolution.getInferredType();
                DataType lhsExpectedType = $this$doAnalyzeAssignmentLikeStatement.resolveRef(lhsResolution.getProperty().getValueType());
                if (rhsType instanceof DataType.UnitType) {
                    $this$doAnalyzeAssignmentLikeStatement.getErrorCollector().collect(new ResolutionError(statement, ErrorReason.UnitAssignment.INSTANCE));
                    hasErrors = true;
                }
                if ((map2 = UtilsKt.computeGenericTypeSubstitution($this$doAnalyzeAssignmentLikeStatement, DefaultAnalysisSchemaKt.getRef(lhsExpectedType), DefaultAnalysisSchemaKt.getRef(rhsType))) == null) {
                    map2 = MapsKt.emptyMap();
                }
                if (!UtilsKt.checkIsAssignable($this$doAnalyzeAssignmentLikeStatement, rhsType, lhsExpectedType, typeSubstitution = map2)) {
                    $this$doAnalyzeAssignmentLikeStatement.getErrorCollector().collect(new ResolutionError(statement, new ErrorReason.AssignmentTypeMismatch(lhsExpectedType, rhsType)));
                    hasErrors = true;
                }
                assignmentRecord = !hasErrors ? (AssignmentRecord)doRecordAssignment.invoke((Object)lhsResolution, (Object)rhsResolution) : null;
            }
        }
        return assignmentRecord;
    }

    private final void doAnalyzeLocal(AnalysisContext $this$doAnalyzeLocal, LocalValue localValue2) {
        TypedOrigin rhs = this.expressionResolver.doResolveExpression($this$doAnalyzeLocal, localValue2.getRhs(), ExpectedTypeData.NoExpectedType.INSTANCE);
        if (rhs == null) {
            $this$doAnalyzeLocal.getErrorCollector().collect(new ResolutionError(localValue2, ErrorReason.UnresolvedAssignmentRhs.INSTANCE));
        } else {
            if (rhs.getInferredType() instanceof DataType.UnitType) {
                $this$doAnalyzeLocal.getErrorCollector().collect(new ResolutionError(localValue2, ErrorReason.UnitAssignment.INSTANCE));
            }
            ((AnalysisScope)CollectionsKt.last($this$doAnalyzeLocal.getCurrentScopes())).declareLocal(localValue2, rhs.getObjectOrigin(), $this$doAnalyzeLocal.getErrorCollector());
        }
    }

    private final boolean isDanglingPureCall(ObjectOrigin.FunctionOrigin obj) {
        return obj.getFunction().getSemantics() instanceof FunctionSemantics.Pure ? true : (obj instanceof ObjectOrigin.BuilderReturnedReceiver ? !StatementResolverImpl.isDanglingPureCall$isPotentiallyPersistentReceiver(((ObjectOrigin.BuilderReturnedReceiver)obj).getReceiver()) : false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isDanglingPureCall$isPotentiallyPersistentReceiver(ObjectOrigin objectOrigin) {
        ObjectOrigin objectOrigin2 = objectOrigin;
        if (objectOrigin2 instanceof ObjectOrigin.AccessAndConfigureReceiver) {
            return true;
        }
        if (objectOrigin2 instanceof ObjectOrigin.ImplicitThisReceiver) {
            return true;
        }
        if (objectOrigin2 instanceof ObjectOrigin.FromLocalValue) {
            return true;
        }
        if (!(objectOrigin2 instanceof ObjectOrigin.DelegatingObjectOrigin)) {
            if (objectOrigin2 instanceof ObjectOrigin.ConstantOrigin) {
                return false;
            }
            if (objectOrigin2 instanceof ObjectOrigin.EnumConstantOrigin) {
                return false;
            }
            if (objectOrigin2 instanceof ObjectOrigin.GroupedVarargValue) {
                return false;
            }
            if (objectOrigin2 instanceof ObjectOrigin.External) {
                return true;
            }
            if (objectOrigin2 instanceof ObjectOrigin.FunctionOrigin) {
                FunctionSemantics semantics = ((ObjectOrigin.FunctionOrigin)objectOrigin).getFunction().getSemantics();
                FunctionSemantics functionSemantics = semantics;
                if (functionSemantics instanceof FunctionSemantics.Builder) {
                    throw new IllegalStateException("should be impossible?".toString());
                }
                if (functionSemantics instanceof FunctionSemantics.AccessAndConfigure) {
                    return true;
                }
                if (functionSemantics instanceof FunctionSemantics.AddAndConfigure) {
                    return true;
                }
                if (!(functionSemantics instanceof FunctionSemantics.Pure)) throw new NoWhenBranchMatchedException();
                return false;
            }
            if (objectOrigin2 instanceof ObjectOrigin.NullObjectOrigin) {
                return false;
            }
            if (objectOrigin2 instanceof ObjectOrigin.PropertyReference) {
                return true;
            }
            if (objectOrigin2 instanceof ObjectOrigin.TopLevelReceiver) {
                return true;
            }
            if (objectOrigin2 instanceof ObjectOrigin.PropertyDefaultValue) {
                return true;
            }
            if (!(objectOrigin2 instanceof ObjectOrigin.CustomConfigureAccessor)) throw new NoWhenBranchMatchedException();
            return true;
        }
        boolean bl = StatementResolverImpl.isDanglingPureCall$isPotentiallyPersistentReceiver(((ObjectOrigin.DelegatingObjectOrigin)objectOrigin).getDelegate());
        return bl;
    }

    public static final /* synthetic */ FunctionCallResolver access$getFunctionCallResolver$p(StatementResolverImpl $this) {
        return $this.functionCallResolver;
    }

    public static final /* synthetic */ ErrorCollector access$getErrorCollector$p(StatementResolverImpl $this) {
        return $this.errorCollector;
    }
}

