/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.CompatStyleDeclaration;
import io.sf.carte.doc.style.css.om.DefaultStyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.om.ExtendedCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.WrappedCSSStyleDeclaration;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.w3c.dom.DOMException;

public abstract class BaseCSSDeclarationRule
extends BaseCSSRule
implements ExtendedCSSDeclarationRule {
    private static final long serialVersionUID = 2L;
    private BaseCSSStyleDeclaration declaration = null;
    private StyleDeclarationErrorHandler sdErrorHandler = null;

    protected BaseCSSDeclarationRule(AbstractCSSStyleSheet parentSheet, short type, int origin) {
        super(parentSheet, type, origin);
        this.declaration = this.createStyleDeclaration(parentSheet);
    }

    BaseCSSStyleDeclaration createStyleDeclaration(AbstractCSSStyleSheet parentSheet) {
        return (BaseCSSStyleDeclaration)parentSheet.createStyleDeclaration(this);
    }

    BaseCSSDeclarationRule() {
        super(null, (short)1, 0);
        this.declaration = new BaseCSSStyleDeclaration(this);
        this.sdErrorHandler = new DefaultStyleDeclarationErrorHandler();
    }

    @Override
    public AbstractCSSStyleDeclaration getStyle() {
        return this.declaration;
    }

    void clear() {
        this.declaration.clear();
        this.resetComments();
    }

    @Override
    public StyleDeclarationErrorHandler getStyleDeclarationErrorHandler() {
        if (this.sdErrorHandler == null) {
            this.sdErrorHandler = this.getParentStyleSheet().getStyleSheetFactory().createStyleDeclarationErrorHandler(this);
        }
        return this.sdErrorHandler;
    }

    @Override
    boolean hasErrorsOrWarnings() {
        return this.sdErrorHandler != null && (this.sdErrorHandler.hasErrors() || this.sdErrorHandler.hasWarnings());
    }

    public void setStyleDeclarationErrorHandler(StyleDeclarationErrorHandler handler) {
        this.sdErrorHandler = handler;
    }

    @Override
    public String getCssText() {
        StyleFormattingContext context = this.getStyleFormattingContext();
        context.setParentContext(this.getParentRule());
        BufferSimpleWriter sw = new BufferSimpleWriter(10 + this.getStyle().getLength() * 24);
        try {
            this.writeCssText((SimpleWriter)sw, context);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return sw.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        this.getStyle().writeCssText(wri, context);
    }

    @Override
    public String getMinifiedCssText() {
        return this.getStyle().getMinifiedCssText();
    }

    public int hashCode() {
        int prime = 31;
        int result = Short.hashCode(this.getType());
        result = 31 * result + (this.declaration == null ? 0 : this.declaration.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseCSSDeclarationRule other = (BaseCSSDeclarationRule)obj;
        if (this.declaration == null) {
            return other.declaration == null;
        }
        return this.declaration.equals(other.declaration);
    }

    @Override
    public BaseCSSDeclarationRule clone(AbstractCSSStyleSheet parentSheet) throws IllegalArgumentException {
        BaseCSSDeclarationRule rule;
        Constructor<?> ctor;
        Class[] parameterTypes = new Class[]{AbstractCSSStyleSheet.class, Integer.TYPE};
        try {
            ctor = this.getClass().getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        Object[] initargs = new Object[]{parentSheet, this.getOrigin()};
        try {
            rule = (BaseCSSDeclarationRule)ctor.newInstance(initargs);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        String oldHrefContext = this.getParentStyleSheet().getHref();
        rule.setWrappedStyle((BaseCSSStyleDeclaration)this.getStyle(), oldHrefContext);
        return rule;
    }

    void setWrappedStyle(BaseCSSStyleDeclaration style, String oldHrefContext) {
        this.declaration = !(style instanceof CompatStyleDeclaration) ? new StyleWrapper(style, oldHrefContext) : new CompatStyleWrapper((CompatStyleDeclaration)style, oldHrefContext);
    }

    private class StyleWrapper
    extends WrappedCSSStyleDeclaration {
        private static final long serialVersionUID = 1L;

        private StyleWrapper(BaseCSSStyleDeclaration copiedObject, String oldHrefContext) {
            super(copiedObject, oldHrefContext);
        }

        @Override
        public BaseCSSDeclarationRule getParentRule() {
            return BaseCSSDeclarationRule.this;
        }
    }

    private class CompatStyleWrapper
    extends CompatStyleDeclaration {
        private static final long serialVersionUID = 1L;
        private final String hrefcontext;
        private final String oldHrefContext;

        private CompatStyleWrapper(CompatStyleDeclaration copiedObject, String oldHrefContext) {
            super(copiedObject);
            this.hrefcontext = WrappedCSSStyleDeclaration.getHrefContext(this.getParentRule());
            this.oldHrefContext = oldHrefContext;
        }

        @Override
        protected StyleValue getCSSValue(String propertyName) {
            StyleValue value = super.getCSSValue(propertyName);
            if (value != null) {
                value = WrappedCSSStyleDeclaration.wrapCSSValue(value, this.oldHrefContext, this.hrefcontext);
            }
            return value;
        }

        @Override
        public BaseCSSDeclarationRule getParentRule() {
            return BaseCSSDeclarationRule.this;
        }
    }
}

