/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.plaf.TextUI;
import org.jdesktop.swingx.plaf.BuddyLayoutAndBorder;
import org.jdesktop.swingx.plaf.PromptTextFieldUI;

public class BuddyTextFieldUI
extends PromptTextFieldUI {
    protected BuddyLayoutAndBorder layoutAndBorder;
    private static final Insets MAC_MARGIN = new Insets(0, 2, 1, 2);

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.hasMacTextFieldBorder(c)) {
            Insets borderInsets = this.layoutAndBorder.getRealBorderInsets();
            borderInsets.left -= BuddyTextFieldUI.MAC_MARGIN.left;
            int height = c.getHeight() - borderInsets.bottom - borderInsets.top + BuddyTextFieldUI.MAC_MARGIN.bottom + BuddyTextFieldUI.MAC_MARGIN.top;
            int width = c.getWidth() - borderInsets.left - borderInsets.right + BuddyTextFieldUI.MAC_MARGIN.right;
            g.clipRect(borderInsets.left, borderInsets.top, width, height);
        }
        super.paint(g, c);
    }

    private boolean hasMacTextFieldBorder(JComponent c) {
        Border border = c.getBorder();
        if (border == this.layoutAndBorder) {
            border = this.layoutAndBorder.getBorderDelegate();
        }
        return border != null && border.getClass().getName().equals("apple.laf.CUIAquaTextFieldBorder");
    }

    public BuddyTextFieldUI(TextUI delegate) {
        super(delegate);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.layoutAndBorder = this.createBuddyLayoutAndBorder();
        this.layoutAndBorder.install((JTextField)c);
    }

    protected BuddyLayoutAndBorder createBuddyLayoutAndBorder() {
        return new BuddyLayoutAndBorder();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.layoutAndBorder.uninstall();
        super.uninstallUI(c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension d = new Dimension();
        Dimension cd = super.getPreferredSize(c);
        Dimension ld = c.getLayout().preferredLayoutSize(c);
        d.height = Math.max(cd.height, ld.height);
        d.width = Math.max(cd.width, ld.width);
        return d;
    }
}

