/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.repl;

import dotty.tools.dotc.config.Settings;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Denotations;
import dotty.tools.dotc.core.Flags$;
import dotty.tools.dotc.core.StdNames$;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.core.Symbols$;
import dotty.tools.dotc.core.Types;
import dotty.tools.dotc.reporting.Diagnostic;
import dotty.tools.dotc.util.StackTraceOps$;
import dotty.tools.io.AbstractFile;
import dotty.tools.repl.AbstractFileClassLoader;
import dotty.tools.repl.AbstractFileClassLoader$InterruptInstrumentation$;
import dotty.tools.repl.Rendering$;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import pprint.PPrinter;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right$;
import scala.util.control.NonFatal$;

public class Rendering {
    private final Option<ClassLoader> parentClassLoader;
    private AbstractFileClassLoader myClassLoader;

    public static String REPL_WRAPPER_NAME_PREFIX() {
        return Rendering$.MODULE$.REPL_WRAPPER_NAME_PREFIX();
    }

    public static Throwable rootCause(Throwable throwable) {
        return Rendering$.MODULE$.rootCause(throwable);
    }

    public static String showUser(Symbols.Symbol symbol, Contexts.Context context) {
        return Rendering$.MODULE$.showUser(symbol, context);
    }

    public static Option<ClassLoader> $lessinit$greater$default$1() {
        return Rendering$.MODULE$.$lessinit$greater$default$1();
    }

    public Rendering(Option<ClassLoader> parentClassLoader) {
        this.parentClassLoader = parentClassLoader;
    }

    public AbstractFileClassLoader myClassLoader() {
        return this.myClassLoader;
    }

    public void myClassLoader_$eq(AbstractFileClassLoader x$1) {
        this.myClassLoader = x$1;
    }

    private String pprintRender(Object value, int width, int height, int initialOffset, Contexts.Context x$5) {
        String string;
        try {
            AbstractFileClassLoader cl = this.classLoader(x$5);
            Class<?> pprintCls = Class.forName("pprint.PPrinter$BlackWhite$", false, (ClassLoader)((Object)cl));
            Class<?> fansiStrCls = Class.forName("fansi.Str", false, (ClassLoader)((Object)cl));
            Object BlackWhite = pprintCls.getField("MODULE$").get(null);
            Method BlackWhite_apply = pprintCls.getMethod("apply", Object.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
            Method FansiStr_plainText = fansiStrCls.getMethod("plainText", new Class[0]);
            Object fansiStr = BlackWhite_apply.invoke(BlackWhite, value, BoxesRunTime.boxToInteger((int)width), BoxesRunTime.boxToInteger((int)height), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)initialOffset), BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToBoolean((boolean)true));
            string = (String)FansiStr_plainText.invoke(fansiStr, new Object[0]);
        }
        catch (ClassNotFoundException ex) {
            string = Rendering.fallback$1(value, width, height, initialOffset);
        }
        catch (NoSuchMethodException ex) {
            string = Rendering.fallback$1(value, width, height, initialOffset);
        }
        return string;
    }

    public AbstractFileClassLoader classLoader(Contexts.Context x$1) {
        if (this.myClassLoader() != null) {
            AbstractFile abstractFile = this.myClassLoader().root();
            Object object = Settings.Setting$.MODULE$.value(x$1.settings().outputDir(), x$1);
            if (!(abstractFile != null ? !abstractFile.equals(object) : object != null)) {
                return this.myClassLoader();
            }
        }
        ClassLoader parent = (ClassLoader)Option$.MODULE$.apply((Object)this.myClassLoader()).orElse(this::$anonfun$1).getOrElse(() -> Rendering.$anonfun$2(x$1));
        this.myClassLoader_$eq(new AbstractFileClassLoader((AbstractFile)Settings.Setting$.MODULE$.value(x$1.settings().outputDir(), x$1), parent, AbstractFileClassLoader$InterruptInstrumentation$.MODULE$.fromString((String)Settings.Setting$.MODULE$.value(x$1.settings().XreplInterruptInstrumentation(), x$1))));
        return this.myClassLoader();
    }

    public String truncate(String str, int maxPrintCharacters, Contexts.Context ctx) {
        int ncp = str.codePointCount(0, str.length());
        if (ncp <= maxPrintCharacters) {
            return str;
        }
        return str.substring(0, str.offsetByCodePoints(0, maxPrintCharacters - 1));
    }

    public String replStringOf(Object value, int prefixLength, Contexts.Context x$3) {
        return this.pprintRender(value, 100, 50, prefixLength, x$3);
    }

    private Option<String> valueOf(Symbols.Symbol sym, int prefixLength, Contexts.Context x$3) {
        String objectName = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(Symbols$.MODULE$.toDenot(Symbols$.MODULE$.toDenot(sym, x$3).owner(), x$3).fullName(x$3).encode().toString()), "$");
        Class<?> resObj = Class.forName(objectName, true, (ClassLoader)((Object)this.classLoader(x$3)));
        Object object = Predef$.MODULE$.refArrayOps((Object[])resObj.getDeclaredMethods());
        Option symValue = ArrayOps$.MODULE$.find$extension(object, (Function1 & Serializable)method -> {
            String string = method.getName();
            String string2 = sym.name(x$3).encode().toString();
            return !(string != null ? !string.equals(string2) : string2 != null) && method.getParameterCount() == 0;
        }).flatMap((Function1 & Serializable)result -> this.rewrapValueClass(Symbols$.MODULE$.toDenot(sym, x$3).info(x$3).classSymbol(x$3), result.invoke(null, new Object[0]), x$3));
        return symValue.filter((Function1 & Serializable)_$1 -> {
            if (Symbols$.MODULE$.toDenot(sym, x$3).is(Flags$.MODULE$.Method(), x$3)) return true;
            Types.Type type = Symbols$.MODULE$.toDenot(sym, x$3).info(x$3);
            Types.TypeRef typeRef = Symbols$.MODULE$.defn(x$3).UnitType();
            if (type == null) {
                if (typeRef == null) return false;
                return true;
            } else if (type.equals(typeRef)) return false;
            return true;
        }).map((Function1 & Serializable)value -> this.stripReplPrefix(this.replStringOf(value, prefixLength, x$3)));
    }

    private String stripReplPrefix(String s) {
        if (s.startsWith("rs$line$")) {
            return StringOps$.MODULE$.dropWhile$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(s), "rs$line$".length())), (Function1 & Serializable)c -> Rendering.stripReplPrefix$$anonfun$1(BoxesRunTime.unboxToChar((Object)c)));
        }
        return s;
    }

    private Option<Object> rewrapValueClass(Symbols.Symbol sym, Object value, Contexts.Context x$3) {
        if (Symbols$.MODULE$.isDerivedValueClass(sym, x$3)) {
            Class<?> valueClass = Class.forName(Symbols$.MODULE$.toDenot(sym, x$3).binaryClassName(x$3), true, (ClassLoader)((Object)this.classLoader(x$3)));
            Object object = Predef$.MODULE$.refArrayOps((Object[])valueClass.getConstructors());
            return ArrayOps$.MODULE$.headOption$extension(object).map((Function1 & Serializable)_$2 -> _$2.newInstance(value));
        }
        return Some$.MODULE$.apply(value);
    }

    public Diagnostic renderTypeDef(Denotations.Denotation d, Contexts.Context x$2) {
        return this.infoDiagnostic(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString("// defined "), Rendering$.MODULE$.showUser(d.symbol(), x$2)), d, x$2);
    }

    public Diagnostic renderTypeAlias(Denotations.Denotation d, Contexts.Context x$2) {
        return this.infoDiagnostic(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString("// defined alias "), Rendering$.MODULE$.showUser(d.symbol(), x$2)), d, x$2);
    }

    public Diagnostic renderMethod(Denotations.Denotation d, Contexts.Context x$2) {
        return this.infoDiagnostic(Rendering$.MODULE$.showUser(d.symbol(), x$2), d, x$2);
    }

    public Either<ReflectiveOperationException, Option<Diagnostic>> renderVal(Denotations.Denotation d, Contexts.Context x$2) {
        Left left;
        String dcl = Rendering$.MODULE$.showUser(d.symbol(), x$2);
        try {
            Some some;
            Right$ right$ = package$.MODULE$.Right();
            if (Symbols$.MODULE$.toDenot(d.symbol(), x$2).is(Flags$.MODULE$.Lazy(), x$2)) {
                some = Some$.MODULE$.apply((Object)this.msg$2(d, x$2, dcl));
            } else {
                String prefix = dcl + " = ";
                int prefixLength = ((String)StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(prefix)).toSeq().lastOption().getOrElse(Rendering::$anonfun$5)).length();
                some = this.valueOf(d.symbol(), prefixLength, x$2).map((Function1 & Serializable)value -> this.msg$2(d, x$2, prefix + value));
            }
            left = right$.apply((Object)some);
        }
        catch (ReflectiveOperationException e) {
            left = package$.MODULE$.Left().apply((Object)e);
        }
        return left;
    }

    public Seq<Diagnostic> forceModule(Symbols.Symbol sym, Contexts.Context x$2) {
        Nil$ nil$;
        try {
            nil$ = this.load$1(sym, x$2);
        }
        catch (ExceptionInInitializerError e) {
            nil$ = (Seq)new .colon.colon((Object)this.renderError(e, (Denotations.Denotation)sym.denot(x$2), x$2), (List)Nil$.MODULE$);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                nil$ = (List)new .colon.colon((Object)this.renderError(e, (Denotations.Denotation)sym.denot(x$2), x$2), (List)Nil$.MODULE$);
            }
            throw throwable;
        }
        return nil$;
    }

    public Diagnostic renderError(Throwable thr, Denotations.Denotation d, Contexts.Context x$3) {
        Throwable cause = Rendering$.MODULE$.rootCause(thr);
        return this.infoDiagnostic(StackTraceOps$.MODULE$.formatStackTracePrefix(cause, (Function1 & Serializable)_$3 -> !Rendering.isWrapperInitialization$1(x$3, _$3)), d, x$3);
    }

    private Diagnostic infoDiagnostic(String msg, Denotations.Denotation d, Contexts.Context x$3) {
        return new Diagnostic.Info(() -> Rendering.infoDiagnostic$$anonfun$1(msg), d.symbol().sourcePos(x$3));
    }

    private static final String fallback$1(Object value$1, int width$1, int height$1, int initialOffset$1) {
        return PPrinter.BlackWhite$.MODULE$.apply(value$1, width$1, height$1, PPrinter.BlackWhite$.MODULE$.apply$default$4(), initialOffset$1, PPrinter.BlackWhite$.MODULE$.apply$default$6(), PPrinter.BlackWhite$.MODULE$.apply$default$7()).plainText();
    }

    private final Option $anonfun$1() {
        return this.parentClassLoader;
    }

    private static final ClassLoader $anonfun$2(Contexts.Context x$1$1) {
        Seq compilerClasspath = x$1$1.platform().classPath(x$1$1).asURLs();
        ClassLoader baseClassLoader = ClassLoader.getSystemClassLoader().getParent();
        return new URLClassLoader((URL[])compilerClasspath.toArray(ClassTag$.MODULE$.apply(URL.class)), baseClassLoader);
    }

    private static final /* synthetic */ boolean stripReplPrefix$$anonfun$1(char c) {
        return RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(c)) || c == '$';
    }

    private final Diagnostic msg$2(Denotations.Denotation d$1, Contexts.Context x$2$1, String s) {
        return this.infoDiagnostic(s, d$1, x$2$1);
    }

    private static final String $anonfun$5() {
        return "";
    }

    private final Nil$ load$1(Symbols.Symbol sym$4, Contexts.Context x$2$3) {
        String objectName = Symbols$.MODULE$.toDenot(sym$4, x$2$3).fullName(x$2$3).encode().toString();
        Class.forName(objectName, true, (ClassLoader)((Object)this.classLoader(x$2$3)));
        return package$.MODULE$.Nil();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isWrapperInitialization$1(Contexts.Context x$3$5, StackTraceElement ste) {
        if (!ste.getClassName().startsWith("rs$line$")) return false;
        String string = ste.getMethodName();
        String string2 = StdNames$.MODULE$.nme().STATIC_CONSTRUCTOR().show(x$3$5);
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = ste.getMethodName();
        String string4 = StdNames$.MODULE$.nme().CONSTRUCTOR().show(x$3$5);
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    private static final String infoDiagnostic$$anonfun$1(String msg$1) {
        return msg$1;
    }
}

