/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.service.progress;

import aQute.bnd.service.progress.ProgressPlugin;
import java.io.Flushable;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressToOutput
implements ProgressPlugin {
    static final Logger logger = LoggerFactory.getLogger(ProgressToOutput.class);
    final Object lock = new Object();
    final Appendable appendable;
    final String eol;

    public ProgressToOutput(Appendable appendable, String eol) {
        this.appendable = appendable;
        if (eol == null) {
            eol = "ansi".equalsIgnoreCase(System.getenv("TERM")) ? "\u001b[0K .\r" : "\n";
        }
        this.eol = eol;
    }

    private synchronized void log(String msg, boolean nl, Object ... args) {
        try {
            String out = String.format(msg + (nl ? "%n" : this.eol), args);
            if (out.length() > 100) {
                out = out.substring(0, 50) + ".." + out.substring(out.length() - 50);
            }
            this.appendable.append(out);
            if (this.appendable instanceof Flushable) {
                ((Flushable)((Object)this.appendable)).flush();
            }
        }
        catch (IOException e) {
            logger.error("sending output for progress ", (Throwable)e);
        }
    }

    @Override
    public ProgressPlugin.Task startTask(final String name, final int size) {
        return new ProgressPlugin.Task(){

            @Override
            public void worked(int units) {
                ProgressToOutput.this.log("work : %02d %s", false, new Object[]{(units * 100 + size / 2) / size, name});
            }

            @Override
            public void done(String message, Throwable e) {
                if (e != null) {
                    ProgressToOutput.this.log("error:    %s %s", true, new Object[]{name, e.getMessage()});
                } else {
                    ProgressToOutput.this.log("done :    %s", false, new Object[]{name});
                }
            }

            @Override
            public boolean isCanceled() {
                return false;
            }
        };
    }

    public void clear() {
        this.log("", false, new Object[0]);
    }
}

