/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.impl;

import java.net.DatagramPacket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import org.jupnp.model.UnsupportedDataException;
import org.jupnp.transport.Router;
import org.jupnp.transport.impl.MulticastReceiverConfigurationImpl;
import org.jupnp.transport.spi.DatagramProcessor;
import org.jupnp.transport.spi.InitializationException;
import org.jupnp.transport.spi.MulticastReceiver;
import org.jupnp.transport.spi.NetworkAddressFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MulticastReceiverImpl
implements MulticastReceiver<MulticastReceiverConfigurationImpl> {
    private final Logger logger = LoggerFactory.getLogger(MulticastReceiver.class);
    protected final MulticastReceiverConfigurationImpl configuration;
    protected Router router;
    protected NetworkAddressFactory networkAddressFactory;
    protected DatagramProcessor datagramProcessor;
    protected NetworkInterface multicastInterface;
    protected InetSocketAddress multicastAddress;
    protected MulticastSocket socket;

    public MulticastReceiverImpl(MulticastReceiverConfigurationImpl configuration) {
        this.configuration = configuration;
    }

    @Override
    public MulticastReceiverConfigurationImpl getConfiguration() {
        return this.configuration;
    }

    @Override
    public synchronized void init(NetworkInterface networkInterface, Router router, NetworkAddressFactory networkAddressFactory, DatagramProcessor datagramProcessor) throws InitializationException {
        this.router = router;
        this.networkAddressFactory = networkAddressFactory;
        this.datagramProcessor = datagramProcessor;
        this.multicastInterface = networkInterface;
        try {
            this.logger.debug("Creating wildcard socket (for receiving multicast datagrams) on port: {}", (Object)this.configuration.getPort());
            this.multicastAddress = new InetSocketAddress(this.configuration.getGroup(), this.configuration.getPort());
            this.socket = new MulticastSocket(this.configuration.getPort());
            this.socket.setReuseAddress(true);
            this.socket.setReceiveBufferSize(32768);
            this.logger.debug("Joining multicast group: {} on network interface: {}", (Object)this.multicastAddress, (Object)this.multicastInterface.getDisplayName());
            this.socket.joinGroup(this.multicastAddress, this.multicastInterface);
        }
        catch (Exception e) {
            throw new InitializationException("Could not initialize " + this.getClass().getSimpleName() + ": " + String.valueOf(e));
        }
    }

    @Override
    public synchronized void stop() {
        if (this.socket != null && !this.socket.isClosed()) {
            try {
                this.logger.debug("Leaving multicast group");
                this.socket.leaveGroup(this.multicastAddress, this.multicastInterface);
            }
            catch (Exception e) {
                this.logger.debug("Could not leave multicast group", (Throwable)e);
            }
            this.socket.close();
        }
    }

    @Override
    public void run() {
        this.logger.debug("Entering blocking receiving loop, listening for UDP datagrams on: {}", (Object)this.socket.getLocalAddress());
        while (true) {
            try {
                while (true) {
                    byte[] buf = new byte[this.getConfiguration().getMaxDatagramBytes()];
                    DatagramPacket datagram = new DatagramPacket(buf, buf.length);
                    this.socket.receive(datagram);
                    InetAddress receivedOnLocalAddress = this.networkAddressFactory.getLocalAddress(this.multicastInterface, this.multicastAddress.getAddress() instanceof Inet6Address, datagram.getAddress());
                    this.logger.debug("UDP datagram received from: {}:{} on local interface: {} and address: {}", new Object[]{datagram.getAddress().getHostAddress(), datagram.getPort(), this.multicastInterface.getDisplayName(), receivedOnLocalAddress.getHostAddress()});
                    this.router.received(this.datagramProcessor.read(receivedOnLocalAddress, datagram));
                }
            }
            catch (SocketException e) {
                this.logger.debug("Socket closed");
            }
            catch (UnsupportedDataException e) {
                this.logger.info("Could not read datagram: {}", (Object)e.getMessage());
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            break;
        }
        try {
            if (!this.socket.isClosed()) {
                this.logger.debug("Closing multicast socket");
                this.socket.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

