/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.core.internal.tag;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.stream.Stream;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.registry.Identifiable;
import org.openhab.core.common.registry.RegistryChangedRunnableListener;
import org.openhab.core.io.rest.JSONResponse;
import org.openhab.core.io.rest.LocaleService;
import org.openhab.core.io.rest.RESTConstants;
import org.openhab.core.io.rest.RESTResource;
import org.openhab.core.io.rest.Stream2JSONInputStream;
import org.openhab.core.io.rest.core.internal.tag.EnrichedSemanticTagDTO;
import org.openhab.core.semantics.ManagedSemanticTagProvider;
import org.openhab.core.semantics.SemanticTag;
import org.openhab.core.semantics.SemanticTagImpl;
import org.openhab.core.semantics.SemanticTagRegistry;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JSONRequired;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsApplicationSelect;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsName;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;

@Path(value="tags")
@Tag(name="tags")
@Component
@JaxrsResource
@JaxrsName(value="tags")
@JaxrsApplicationSelect(value="(osgi.jaxrs.name=openhab)")
@JSONRequired
@NonNullByDefault
public class TagResource
implements RESTResource {
    public static final String PATH_TAGS = "tags";
    private final LocaleService localeService;
    private final SemanticTagRegistry semanticTagRegistry;
    private final ManagedSemanticTagProvider managedSemanticTagProvider;
    private final RegistryChangedRunnableListener<SemanticTag> resetLastModifiedChangeListener = new RegistryChangedRunnableListener(() -> {
        Date date = this.lastModified = null;
    });
    private @Nullable Date lastModified = null;

    @Activate
    public TagResource(@Reference LocaleService localeService, @Reference SemanticTagRegistry semanticTagRegistry, @Reference ManagedSemanticTagProvider managedSemanticTagProvider) {
        this.localeService = localeService;
        this.semanticTagRegistry = semanticTagRegistry;
        this.managedSemanticTagProvider = managedSemanticTagProvider;
        this.semanticTagRegistry.addRegistryChangeListener(this.resetLastModifiedChangeListener);
    }

    @Deactivate
    void deactivate() {
        this.semanticTagRegistry.removeRegistryChangeListener(this.resetLastModifiedChangeListener);
    }

    @GET
    @RolesAllowed(value={"user", "administrator"})
    @Produces(value={"application/json"})
    @Operation(operationId="getSemanticTags", summary="Get all available semantic tags.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=EnrichedSemanticTagDTO.class)))})})
    public Response getTags(@Context Request request, @Context UriInfo uriInfo, @Context HttpHeaders httpHeaders, @HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language) {
        if (this.lastModified != null) {
            Response.ResponseBuilder responseBuilder = request.evaluatePreconditions(this.lastModified);
            if (responseBuilder != null) {
                return responseBuilder.build();
            }
        } else {
            this.lastModified = Date.from(Instant.now().truncatedTo(ChronoUnit.SECONDS));
        }
        Locale locale = this.localeService.getLocale(language);
        Stream<EnrichedSemanticTagDTO> tagsStream = this.semanticTagRegistry.getAll().stream().sorted(Comparator.comparing(Identifiable::getUID)).map(t -> new EnrichedSemanticTagDTO(t.localized(locale), this.semanticTagRegistry.isEditable(t)));
        return Response.ok((Object)new Stream2JSONInputStream(tagsStream)).lastModified(this.lastModified).cacheControl(RESTConstants.CACHE_CONTROL).build();
    }

    @GET
    @RolesAllowed(value={"user", "administrator"})
    @Path(value="/{tagId}")
    @Produces(value={"application/json"})
    @Operation(operationId="getSemanticTagAndSubTags", summary="Gets a semantic tag and its sub tags.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=EnrichedSemanticTagDTO.class)))}), @ApiResponse(responseCode="404", description="Semantic tag not found.")})
    public Response getTagAndSubTags(@Context Request request, @HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @PathParam(value="tagId") @Parameter(description="tag id") String tagId) {
        if (this.lastModified != null) {
            Response.ResponseBuilder responseBuilder = request.evaluatePreconditions(this.lastModified);
            if (responseBuilder != null) {
                return responseBuilder.build();
            }
        } else {
            this.lastModified = Date.from(Instant.now().truncatedTo(ChronoUnit.SECONDS));
        }
        Locale locale = this.localeService.getLocale(language);
        String uid = tagId.trim();
        SemanticTag tag = (SemanticTag)this.semanticTagRegistry.get((Object)uid);
        if (tag != null) {
            Stream<EnrichedSemanticTagDTO> tagsStream = this.semanticTagRegistry.getSubTree(tag).stream().sorted(Comparator.comparing(Identifiable::getUID)).map(t -> new EnrichedSemanticTagDTO(t.localized(locale), this.semanticTagRegistry.isEditable(t)));
            return Response.ok((Object)new Stream2JSONInputStream(tagsStream)).lastModified(this.lastModified).cacheControl(RESTConstants.CACHE_CONTROL).build();
        }
        return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.NOT_FOUND, (String)("Tag " + uid + " does not exist!"));
    }

    @POST
    @RolesAllowed(value={"administrator"})
    @Consumes(value={"application/json"})
    @Operation(operationId="createSemanticTag", summary="Creates a new semantic tag and adds it to the registry.", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="201", description="Created", content={@Content(schema=@Schema(implementation=EnrichedSemanticTagDTO.class))}), @ApiResponse(responseCode="400", description="The tag identifier is invalid or the tag label is missing."), @ApiResponse(responseCode="409", description="A tag with the same identifier already exists.")})
    public Response create(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @Parameter(description="tag data", required=true) EnrichedSemanticTagDTO data) {
        Locale locale = this.localeService.getLocale(language);
        if (data.uid == null || data.uid.isBlank()) {
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.BAD_REQUEST, (String)"Tag identifier is required!");
        }
        if (data.label == null || data.label.isBlank()) {
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.BAD_REQUEST, (String)"Tag label is required!");
        }
        String uid = data.uid.trim();
        SemanticTag tag = (SemanticTag)this.semanticTagRegistry.get((Object)uid);
        if (tag != null) {
            return JSONResponse.createResponse((Response.StatusType)Response.Status.CONFLICT, (Object)new EnrichedSemanticTagDTO(tag.localized(locale), this.semanticTagRegistry.isEditable(tag)), (String)("Tag " + uid + " already exists!"));
        }
        tag = new SemanticTagImpl(uid, data.label, data.description, data.synonyms);
        if (!this.semanticTagRegistry.canBeAdded(tag)) {
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.BAD_REQUEST, (String)("Invalid tag identifier " + uid));
        }
        this.managedSemanticTagProvider.add((Identifiable)tag);
        return JSONResponse.createResponse((Response.StatusType)Response.Status.CREATED, (Object)new EnrichedSemanticTagDTO(tag.localized(locale), this.semanticTagRegistry.isEditable(tag)), null);
    }

    @DELETE
    @RolesAllowed(value={"administrator"})
    @Path(value="/{tagId}")
    @Operation(operationId="removeSemanticTag", summary="Removes a semantic tag and its sub tags from the registry.", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="200", description="OK, was deleted."), @ApiResponse(responseCode="404", description="Semantic tag not found."), @ApiResponse(responseCode="405", description="Semantic tag not removable.")})
    public Response remove(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @PathParam(value="tagId") @Parameter(description="tag id") String tagId) {
        String uid = tagId.trim();
        SemanticTag tag = (SemanticTag)this.semanticTagRegistry.get((Object)uid);
        if (tag == null) {
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.NOT_FOUND, (String)("Tag " + uid + " does not exist!"));
        }
        if (!this.semanticTagRegistry.isEditable(tag)) {
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.METHOD_NOT_ALLOWED, (String)("Tag " + uid + " is not removable."));
        }
        this.semanticTagRegistry.removeSubTree(tag);
        return Response.ok(null, (String)"text/plain").build();
    }

    @PUT
    @RolesAllowed(value={"administrator"})
    @Path(value="/{tagId}")
    @Consumes(value={"application/json"})
    @Operation(operationId="updateSemanticTag", summary="Updates a semantic tag.", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=EnrichedSemanticTagDTO.class))}), @ApiResponse(responseCode="404", description="Semantic tag not found."), @ApiResponse(responseCode="405", description="Semantic tag not editable.")})
    public Response update(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @PathParam(value="tagId") @Parameter(description="tag id") String tagId, @Parameter(description="tag data", required=true) EnrichedSemanticTagDTO data) {
        Locale locale = this.localeService.getLocale(language);
        String uid = tagId.trim();
        SemanticTag tag = (SemanticTag)this.semanticTagRegistry.get((Object)uid);
        if (tag == null) {
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.NOT_FOUND, (String)("Tag " + uid + " does not exist!"));
        }
        if (!this.semanticTagRegistry.isEditable(tag)) {
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.METHOD_NOT_ALLOWED, (String)("Tag " + uid + " is not editable."));
        }
        tag = new SemanticTagImpl(uid, data.label != null ? data.label : tag.getLabel(), data.description != null ? data.description : tag.getDescription(), data.synonyms != null ? data.synonyms : tag.getSynonyms());
        this.managedSemanticTagProvider.update((Identifiable)tag);
        return JSONResponse.createResponse((Response.StatusType)Response.Status.OK, (Object)new EnrichedSemanticTagDTO(tag.localized(locale), this.semanticTagRegistry.isEditable(tag)), null);
    }
}

