/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.factories.report.flow;

import java.util.ArrayList;
import org.jfree.layouting.input.style.CSSStyleRule;
import org.jfree.report.modules.factories.report.base.NodeReadHandler;
import org.jfree.report.modules.factories.report.flow.AbstractExpressionReadHandler;
import org.jfree.report.modules.factories.report.flow.AttributeExpressionReadHandler;
import org.jfree.report.modules.factories.report.flow.AttributeReadHandler;
import org.jfree.report.modules.factories.report.flow.DisplayConditionReadHandler;
import org.jfree.report.modules.factories.report.flow.ExpressionReadHandler;
import org.jfree.report.modules.factories.report.flow.StyleExpressionReadHandler;
import org.jfree.report.structure.Element;
import org.jfree.report.structure.Node;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.PropertyReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.RootXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class AbstractElementReadHandler
extends AbstractXmlReadHandler
implements NodeReadHandler {
    private boolean virtual;
    private boolean enabled;
    private String style;
    private ArrayList expressionHandlers = new ArrayList();
    private ArrayList styleExpressionHandlers = new ArrayList();
    private ArrayList attributeExpressionHandlers = new ArrayList();
    private ArrayList attributeHandlers;
    private ArrayList stylePropertyHandlers = new ArrayList();
    private DisplayConditionReadHandler displayConditionReadHandler;

    protected AbstractElementReadHandler() {
        this.attributeHandlers = new ArrayList();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getStyle() {
        return this.style;
    }

    public void init(RootXmlReadHandler rootXmlReadHandler, String string, String string2) {
        super.init(rootXmlReadHandler, string, string2);
        Element element = this.getElement();
        element.setNamespace(string);
        element.setType(string2);
    }

    protected void startParsing(Attributes attributes) throws SAXException {
        super.startParsing(attributes);
        this.style = attributes.getValue("http://jfreereport.sourceforge.net/namespaces/reports/flow", "style");
        String string = attributes.getValue("http://jfreereport.sourceforge.net/namespaces/reports/flow", "enabled");
        this.enabled = string != null ? "true".equals(string) : true;
        String string2 = attributes.getValue("http://jfreereport.sourceforge.net/namespaces/reports/flow", "virtual");
        this.virtual = string2 != null ? "true".equals(string2) : false;
    }

    protected XmlReadHandler getHandlerForChild(String string, String string2, Attributes attributes) throws SAXException {
        if ("http://jfreereport.sourceforge.net/namespaces/reports/flow".equals(string)) {
            if ("expression".equals(string2)) {
                ExpressionReadHandler expressionReadHandler = new ExpressionReadHandler();
                this.expressionHandlers.add(expressionReadHandler);
                return expressionReadHandler;
            }
            if ("style-expression".equals(string2)) {
                StyleExpressionReadHandler styleExpressionReadHandler = new StyleExpressionReadHandler();
                this.styleExpressionHandlers.add(styleExpressionReadHandler);
                return styleExpressionReadHandler;
            }
            if ("style-property".equals(string2)) {
                PropertyReadHandler propertyReadHandler = new PropertyReadHandler();
                this.stylePropertyHandlers.add(propertyReadHandler);
                return propertyReadHandler;
            }
            if ("attribute-expression".equals(string2)) {
                AttributeExpressionReadHandler attributeExpressionReadHandler = new AttributeExpressionReadHandler();
                this.attributeExpressionHandlers.add(attributeExpressionReadHandler);
                return attributeExpressionReadHandler;
            }
            if ("attribute".equals(string2)) {
                AttributeReadHandler attributeReadHandler = new AttributeReadHandler();
                this.attributeHandlers.add(attributeReadHandler);
                return attributeReadHandler;
            }
            if ("display-condition".equals(string2)) {
                this.displayConditionReadHandler = new DisplayConditionReadHandler();
                return this.displayConditionReadHandler;
            }
        }
        return null;
    }

    protected void configureElement(Element element) {
        Object object;
        int n;
        if (this.displayConditionReadHandler != null) {
            element.setDisplayCondition(this.displayConditionReadHandler.getExpression());
        }
        for (n = 0; n < this.expressionHandlers.size(); ++n) {
            object = (ExpressionReadHandler)((Object)this.expressionHandlers.get(n));
            element.addExpression(((AbstractExpressionReadHandler)((Object)object)).getExpression());
        }
        for (n = 0; n < this.styleExpressionHandlers.size(); ++n) {
            object = (StyleExpressionReadHandler)((Object)this.styleExpressionHandlers.get(n));
            element.setStyleExpression(((StyleExpressionReadHandler)((Object)object)).getStyleKey(), ((AbstractExpressionReadHandler)((Object)object)).getExpression());
        }
        for (n = 0; n < this.stylePropertyHandlers.size(); ++n) {
            object = (PropertyReadHandler)this.stylePropertyHandlers.get(n);
            CSSStyleRule cSSStyleRule = element.getStyle();
            cSSStyleRule.setPropertyValueAsString(object.getName(), object.getResult());
        }
        for (n = 0; n < this.attributeExpressionHandlers.size(); ++n) {
            object = (AttributeExpressionReadHandler)((Object)this.attributeExpressionHandlers.get(n));
            element.setAttributeExpression(((AttributeExpressionReadHandler)((Object)object)).getAttributeName(), ((AbstractExpressionReadHandler)((Object)object)).getExpression());
        }
        for (n = 0; n < this.attributeHandlers.size(); ++n) {
            object = (AttributeReadHandler)((Object)this.attributeHandlers.get(n));
            element.setAttribute(((AttributeReadHandler)((Object)object)).getNamespace(), object.getName(), ((AttributeReadHandler)((Object)object)).getObject());
        }
        element.setEnabled(this.enabled);
        element.setVirtual(this.virtual);
        if (this.style != null) {
            element.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/flow", "style", this.style);
        }
    }

    protected abstract Element getElement();

    @Override
    public final Node getNode() {
        return this.getElement();
    }

    public Object getObject() throws SAXException {
        return this.getElement();
    }
}

