/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.serializer;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.serializer.ClassComparator;
import org.pentaho.reporting.libraries.serializer.LibSerializerBoot;
import org.pentaho.reporting.libraries.serializer.SerializeMethod;

public class SerializerHelper {
    private static final Logger logger = Logger.getLogger(SerializerHelper.class.getName());
    private static SerializerHelper singleton;
    private final HashMap methods;
    private final ClassComparator comparator = new ClassComparator();

    public static synchronized SerializerHelper getInstance() {
        if (singleton == null) {
            singleton = new SerializerHelper();
            singleton.registerMethods();
        }
        return singleton;
    }

    protected static void setInstance(SerializerHelper helper) {
        singleton = helper;
    }

    protected SerializerHelper() {
        this.methods = new HashMap();
    }

    public synchronized void registerMethod(SerializeMethod method) {
        this.methods.put(method.getObjectClass(), method);
    }

    protected void registerMethods() {
        Configuration config = LibSerializerBoot.getInstance().getGlobalConfig();
        Iterator sit = config.findPropertyKeys("org.pentaho.reporting.libraries.serializer.handler.");
        while (sit.hasNext()) {
            String configkey = (String)sit.next();
            String c = config.getConfigProperty(configkey);
            Object maybeModule = ObjectUtilities.loadAndInstantiate((String)c, SerializerHelper.class, SerializeMethod.class);
            if (maybeModule != null) {
                SerializeMethod module = (SerializeMethod)maybeModule;
                this.registerMethod(module);
                continue;
            }
            logger.warning("Invalid SerializeMethod implementation: " + c);
        }
    }

    public synchronized void unregisterMethod(SerializeMethod method) {
        this.methods.remove(method.getObjectClass());
    }

    protected HashMap getMethods() {
        return this.methods;
    }

    protected ClassComparator getComparator() {
        return this.comparator;
    }

    protected SerializeMethod getSerializer(Class c) {
        SerializeMethod sm = (SerializeMethod)this.methods.get(c);
        if (sm != null) {
            return sm;
        }
        return this.getSuperClassObjectDescription(c);
    }

    protected SerializeMethod getSuperClassObjectDescription(Class d) {
        SerializeMethod knownSuperClass = null;
        for (Class keyClass : this.methods.keySet()) {
            if (!keyClass.isAssignableFrom(d)) continue;
            SerializeMethod od = (SerializeMethod)this.methods.get(keyClass);
            if (knownSuperClass == null) {
                knownSuperClass = od;
                continue;
            }
            if (!this.comparator.isComparable(knownSuperClass.getObjectClass(), od.getObjectClass()) || this.comparator.compare(knownSuperClass.getObjectClass(), od.getObjectClass()) >= 0) continue;
            knownSuperClass = od;
        }
        return knownSuperClass;
    }

    public synchronized void writeObject(Object o, ObjectOutputStream out) throws IOException {
        try {
            if (o == null) {
                out.writeByte(0);
                return;
            }
            if (o instanceof Serializable) {
                out.writeByte(1);
                out.writeObject(o);
                return;
            }
            SerializeMethod m = this.getSerializer(o.getClass());
            if (m == null) {
                throw new NotSerializableException(o.getClass().getName());
            }
            out.writeByte(2);
            out.writeObject(m.getObjectClass());
            m.writeObject(o, out);
        }
        catch (NotSerializableException nse) {
            DebugLog.log((Object)("Unable to serialize object: " + o));
            throw nse;
        }
    }

    public synchronized boolean isSerializable(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof Serializable) {
            return true;
        }
        SerializeMethod m = this.getSerializer(o.getClass());
        return m != null;
    }

    public synchronized Object readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte type = in.readByte();
        if (type == 0) {
            return null;
        }
        if (type == 1) {
            return in.readObject();
        }
        Class c = (Class)in.readObject();
        SerializeMethod m = this.getSerializer(c);
        if (m == null) {
            throw new NotSerializableException(c.getName());
        }
        return m.readObject(in);
    }
}

