/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.context;

import org.jfree.layouting.input.style.keys.font.FontSmooth;
import org.jfree.layouting.input.style.keys.font.FontStyle;
import org.jfree.layouting.input.style.keys.font.FontStyleKeys;
import org.jfree.layouting.input.style.keys.font.FontVariant;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutStyle;

public class FontSpecification {
    private LayoutStyle style;
    private double fontSize;
    private String fontFamily;
    private boolean antiAliasing;

    public FontSpecification(LayoutStyle layoutStyle) {
        if (layoutStyle == null) {
            throw new NullPointerException("Style must not be null.");
        }
        this.style = layoutStyle;
    }

    public double getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(double d) {
        this.fontSize = d;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setFontFamily(String string) {
        this.fontFamily = string;
    }

    public int getFontWeight() {
        CSSValue cSSValue = this.style.getValue(FontStyleKeys.FONT_WEIGHT);
        if (!(cSSValue instanceof CSSNumericValue)) {
            return 0;
        }
        CSSNumericValue cSSNumericValue = (CSSNumericValue)cSSValue;
        return (int)cSSNumericValue.getValue();
    }

    public boolean isItalic() {
        CSSValue cSSValue = this.style.getValue(FontStyleKeys.FONT_STYLE);
        return FontStyle.ITALIC.equals(cSSValue) || FontStyle.OBLIQUE.equals(cSSValue);
    }

    public boolean isOblique() {
        CSSValue cSSValue = this.style.getValue(FontStyleKeys.FONT_STYLE);
        return FontStyle.OBLIQUE.equals(cSSValue);
    }

    public boolean isSmallCaps() {
        return FontVariant.SMALL_CAPS.equals(this.style.getValue(FontStyleKeys.FONT_VARIANT));
    }

    public boolean isAntiAliasing() {
        CSSValue cSSValue = this.style.getValue(FontStyleKeys.X_FONT_SMOOTH_FLAG);
        return FontSmooth.ALWAYS.equals(cSSValue);
    }
}

