/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.output.spreadsheet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.report.DataFlags;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.flow.ReportJob;
import org.jfree.report.flow.ReportStructureRoot;
import org.jfree.report.flow.ReportTargetUtil;
import org.jfree.report.structure.Element;
import org.jfree.report.structure.Section;
import org.jfree.report.util.IntegerCache;
import org.libreoffice.report.DataSourceFactory;
import org.libreoffice.report.ImageService;
import org.libreoffice.report.InputRepository;
import org.libreoffice.report.OutputRepository;
import org.libreoffice.report.pentaho.model.OfficeMasterPage;
import org.libreoffice.report.pentaho.model.OfficeMasterStyles;
import org.libreoffice.report.pentaho.model.OfficeStyle;
import org.libreoffice.report.pentaho.model.OfficeStyles;
import org.libreoffice.report.pentaho.model.OfficeStylesCollection;
import org.libreoffice.report.pentaho.model.PageSection;
import org.libreoffice.report.pentaho.output.OfficeDocumentReportTarget;
import org.libreoffice.report.pentaho.output.StyleUtilities;
import org.libreoffice.report.pentaho.output.text.MasterPageFactory;
import org.libreoffice.report.pentaho.styles.LengthCalculator;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class SpreadsheetRawReportTarget
extends OfficeDocumentReportTarget {
    private static final String[] FOPROPS = new String[]{"letter-spacing", "font-variant", "text-transform"};
    private static final String NUMBERCOLUMNSSPANNED = "number-columns-spanned";
    private static final String[] STYLEPROPS = new String[]{"text-combine", "font-pitch-complex", "text-rotation-angle", "font-name", "text-blinking", "letter-kerning", "text-combine-start-char", "text-combine-end-char", "text-position", "text-scale"};
    private static final int CELL_WIDTH_FACTOR = 10000;
    private static final String TRANSPARENT = "transparent";
    private boolean paragraphFound = false;
    private boolean paragraphHandled = false;
    private String tableBackgroundColor;
    private boolean elementBoundaryCollectionPass = true;
    private boolean oleHandled = false;
    private final List<ColumnBoundary> columnBoundaryList = new ArrayList<ColumnBoundary>();
    private long currentRowBoundaryMarker;
    private ColumnBoundary[] sortedBoundaryArray;
    private ColumnBoundary[] boundariesForTableArray;
    private int tableCounter;
    private int columnCounter;
    private int columnSpanCounter;
    private int currentSpan = 0;
    private String unitsOfMeasure;
    private final List<AttributeMap> shapes;
    private final List<AttributeMap> ole;
    private final List<CSSNumericValue> rowHeights = new ArrayList<CSSNumericValue>();

    public SpreadsheetRawReportTarget(ReportJob reportJob, ResourceManager resourceManager, ResourceKey resourceKey, InputRepository inputRepository, OutputRepository outputRepository, String string, ImageService imageService, DataSourceFactory dataSourceFactory) throws ReportProcessingException {
        super(reportJob, resourceManager, resourceKey, inputRepository, outputRepository, string, imageService, dataSourceFactory);
        this.shapes = new ArrayList<AttributeMap>();
        this.ole = new ArrayList<AttributeMap>();
    }

    @Override
    public void startOther(AttributeMap attributeMap) throws DataSourceException, ReportProcessingException {
        if (ReportTargetUtil.isElementOfType("http://jfreereport.sourceforge.net/namespaces/engine", "object-ole", attributeMap)) {
            if (this.isElementBoundaryCollectionPass() && this.getCurrentRole() != 11) {
                this.ole.add(attributeMap);
            }
            this.oleHandled = true;
            return;
        }
        String string = ReportTargetUtil.getNamespaceFromAttribute(attributeMap);
        if (this.isRepeatingSection() || this.isFilteredNamespace(string)) {
            return;
        }
        String string2 = ReportTargetUtil.getElemenTypeFromAttribute(attributeMap);
        if ("urn:oasis:names:tc:opendocument:xmlns:text:1.0".equals(string) && "p".equals(string2) && !this.paragraphHandled) {
            this.paragraphFound = true;
            return;
        }
        if ("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0".equals(string) && "frame".equals(string2)) {
            if (this.isElementBoundaryCollectionPass() && this.getCurrentRole() != 11) {
                LengthCalculator lengthCalculator = new LengthCalculator();
                for (int i = 0; i < this.rowHeights.size(); ++i) {
                    lengthCalculator.add(this.rowHeights.get(i));
                }
                this.rowHeights.clear();
                CSSNumericValue cSSNumericValue = lengthCalculator.getResult();
                this.rowHeights.add(cSSNumericValue);
                attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "z-index", (Object)String.valueOf(this.shapes.size()));
                String string3 = (String)attributeMap.getAttribute("urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", "y");
                if (string3 != null) {
                    lengthCalculator.add(this.parseLength(string3));
                    CSSNumericValue cSSNumericValue2 = lengthCalculator.getResult();
                    attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", "y", (Object)(cSSNumericValue2.getValue() + cSSNumericValue2.getType().getType()));
                }
                this.shapes.add(attributeMap);
            }
            return;
        }
        if (this.oleHandled) {
            if (this.isElementBoundaryCollectionPass() && this.getCurrentRole() != 11) {
                this.ole.add(attributeMap);
            }
            return;
        }
        if ("urn:oasis:names:tc:opendocument:xmlns:table:1.0".equals(string) && "table".equals(string2)) {
            ++this.tableCounter;
        }
        if (this.isElementBoundaryCollectionPass()) {
            this.collectBoundaryForElement(attributeMap);
        } else {
            try {
                this.processElement(attributeMap, string, string2);
            }
            catch (IOException iOException) {
                throw new ReportProcessingException("Failed", iOException);
            }
        }
    }

    @Override
    protected void startReportSection(AttributeMap attributeMap, int n) throws ReportProcessingException {
        if (!(n != 12 && n != 13 || PageSection.isPrintWithReportHeader(attributeMap) && PageSection.isPrintWithReportFooter(attributeMap))) {
            this.startBuffering(new OfficeStylesCollection(), true);
        } else {
            super.startReportSection(attributeMap, n);
        }
    }

    @Override
    protected void endReportSection(AttributeMap attributeMap, int n) throws IOException, ReportProcessingException {
        if (!(n != 12 && n != 13 || PageSection.isPrintWithReportHeader(attributeMap) && PageSection.isPrintWithReportFooter(attributeMap))) {
            this.finishBuffering();
        } else {
            super.endReportSection(attributeMap, n);
        }
    }

    private void handleParagraph() {
        if (this.paragraphFound) {
            try {
                XmlWriter xmlWriter = this.getXmlWriter();
                xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "p", null, false);
                this.paragraphHandled = true;
                this.paragraphFound = false;
            }
            catch (IOException iOException) {
                LOGGER.severe("ReportProcessing failed: " + iOException);
            }
        }
    }

    private void processElement(AttributeMap attributeMap, String string, String string2) throws IOException, ReportProcessingException {
        String string3;
        XmlWriter xmlWriter = this.getXmlWriter();
        if (ReportTargetUtil.isElementOfType("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "table", attributeMap)) {
            String string4;
            this.boundariesForTableArray = null;
            String string5 = (String)attributeMap.getAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name");
            this.tableBackgroundColor = string5 == null ? null : ((string4 = StyleUtilities.queryStyle(this.getPredefinedStylesCollection(), "table", string5, "table-properties", "urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "background-color")) == null || TRANSPARENT.equals(string4) ? null : String.valueOf(string4));
            return;
        }
        if (ReportTargetUtil.isElementOfType("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "table-column", attributeMap) || ReportTargetUtil.isElementOfType("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "table-columns", attributeMap)) {
            return;
        }
        if (ReportTargetUtil.isElementOfType("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "covered-table-cell", attributeMap)) {
            if (this.columnSpanCounter > 0) {
                --this.columnSpanCounter;
            }
            if (this.columnSpanCounter == 0) {
                ++this.columnCounter;
                int n = this.getColumnSpanForCell(this.tableCounter, this.columnCounter, 1);
                for (int i = 0; i < n; ++i) {
                    xmlWriter.writeTag(string, "covered-table-cell", null, true);
                }
            }
            return;
        }
        if (ReportTargetUtil.isElementOfType("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "table-row", attributeMap)) {
            this.columnCounter = 0;
            if (this.tableBackgroundColor != null) {
                string3 = (String)attributeMap.getAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name");
                OfficeStyle officeStyle = this.deriveStyle("table-row", string3);
                Element element = officeStyle.getTableRowProperties();
                if (element == null) {
                    element = new Section();
                    element.setNamespace("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
                    element.setType("table-row-properties");
                    element.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "background-color", this.tableBackgroundColor);
                    officeStyle.addNode(element);
                } else {
                    Object object = element.getAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "background-color");
                    if (object == null || TRANSPARENT.equals(object)) {
                        element.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "background-color", this.tableBackgroundColor);
                    }
                }
                attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name", (Object)officeStyle.getStyleName());
            }
        } else if (ReportTargetUtil.isElementOfType("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "table-cell", attributeMap)) {
            Object object;
            ++this.columnCounter;
            string3 = (String)attributeMap.getAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name");
            if (string3 != null) {
                object = this.getPredefinedStylesCollection().getStyle("table-cell", string3);
                if (object != null) {
                    Object object2;
                    Object object3;
                    Section section = (Section)((OfficeStyle)object).getTextProperties();
                    if (section != null) {
                        for (String object4 : FOPROPS) {
                            section.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", object4, null);
                        }
                        section.setAttribute("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "display", null);
                        object3 = STYLEPROPS;
                        int n = ((Object)object3).length;
                        for (int i = 0; i < n; ++i) {
                            Object object4 = object3[i];
                            section.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", (String)object4, null);
                        }
                    }
                    if ((object3 = (Section)((OfficeStyle)object).getTableCellProperties()) != null && TRANSPARENT.equals(object2 = ((Element)object3).getAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "background-color"))) {
                        ((Element)object3).setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "background-color", null);
                    }
                }
                attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name", (Object)string3);
            }
            object = (String)attributeMap.getAttribute(string, NUMBERCOLUMNSSPANNED);
            this.columnSpanCounter = 1;
            int n = 1;
            if (object != null) {
                this.columnSpanCounter = n = Integer.parseInt((String)object);
            }
            int n2 = this.getColumnSpanForCell(this.tableCounter, this.columnCounter, n);
            if (n > 1) {
                this.columnCounter += n - 1;
            }
            if (n2 > 1) {
                attributeMap.setAttribute(string, NUMBERCOLUMNSSPANNED, (Object)("" + n2));
                this.currentSpan = n2;
            }
        }
        this.performStyleProcessing(attributeMap);
        string3 = this.buildAttributeList(attributeMap);
        xmlWriter.writeTag(string, string2, (AttributeList)string3, false);
    }

    private void collectBoundaryForElement(AttributeMap attributeMap) {
        if (ReportTargetUtil.isElementOfType("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "table-columns", attributeMap)) {
            this.resetCurrentRowBoundaryMarker();
        } else if (ReportTargetUtil.isElementOfType("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "table-column", attributeMap)) {
            String string = (String)attributeMap.getAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name");
            if (string == null) {
                return;
            }
            OfficeStyle officeStyle = this.getPredefinedStylesCollection().getStyle("table-column", string);
            if (officeStyle == null) {
                return;
            }
            Element element = officeStyle.getTableColumnProperties();
            String string2 = (String)element.getAttribute("column-width");
            string2 = string2.substring(0, string2.indexOf(this.getUnitsOfMeasure(string2)));
            float f = Float.parseFloat(string2) * 10000.0f;
            this.addColumnWidthToRowBoundaryMarker((long)f);
            ColumnBoundary columnBoundary = new ColumnBoundary(this.getCurrentRowBoundaryMarker());
            List<ColumnBoundary> list = this.getColumnBoundaryList();
            int n = list.indexOf(columnBoundary);
            if (n == -1) {
                list.add(columnBoundary);
            } else {
                columnBoundary = list.get(n);
            }
            columnBoundary.addTableIndex(this.tableCounter);
        }
    }

    private String getUnitsOfMeasure(String string) {
        if (this.unitsOfMeasure == null || "".equals(this.unitsOfMeasure)) {
            char c;
            int n;
            if (string == null || "".equals(string)) {
                this.unitsOfMeasure = "cm";
                return this.unitsOfMeasure;
            }
            for (n = string.length() - 1; n >= 0 && !Character.isDigit(c = string.charAt(n)) && c != '.' && c != ','; --n) {
            }
            this.unitsOfMeasure = string.substring(n + 1);
        }
        return this.unitsOfMeasure;
    }

    private void createTableShapes() throws ReportProcessingException {
        if (!this.shapes.isEmpty()) {
            try {
                XmlWriter xmlWriter = this.getXmlWriter();
                xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "shapes", null, false);
                for (int i = 0; i < this.shapes.size(); ++i) {
                    AttributeMap attributeMap = this.shapes.get(i);
                    AttributeList attributeList = this.buildAttributeList(attributeMap);
                    attributeList.removeAttribute("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "style-name");
                    xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "frame", attributeList, false);
                    this.startChartProcessing(this.ole.get(i));
                    xmlWriter.writeCloseTag();
                }
                xmlWriter.writeCloseTag();
            }
            catch (IOException iOException) {
                throw new ReportProcessingException("Failed", iOException);
            }
        }
    }

    private void createTableColumns() throws ReportProcessingException {
        try {
            XmlWriter xmlWriter = this.getXmlWriter();
            xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "table-columns", null, false);
            ColumnBoundary[] columnBoundaryArray = this.getSortedColumnBoundaryArray();
            for (int i = 1; i < columnBoundaryArray.length; ++i) {
                ColumnBoundary columnBoundary = columnBoundaryArray[i];
                float f = columnBoundary.getBoundary();
                if (i > 1) {
                    f -= columnBoundaryArray[i - 1].getBoundary();
                }
                OfficeStyle officeStyle = this.deriveStyle("table-column", "co" + i + "_");
                Section section = new Section();
                section.setType("table-column-properties");
                section.setNamespace(officeStyle.getNamespace());
                String string = String.format("%f", Float.valueOf(f /= 10000.0f));
                section.setAttribute(officeStyle.getNamespace(), "column-width", string + this.getUnitsOfMeasure(null));
                officeStyle.addNode(section);
                AttributeList attributeList = new AttributeList();
                attributeList.setAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name", officeStyle.getStyleName());
                xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "table-column", attributeList, true);
            }
            xmlWriter.writeCloseTag();
        }
        catch (IOException iOException) {
            throw new ReportProcessingException("Failed", iOException);
        }
    }

    @Override
    protected void endOther(AttributeMap attributeMap) throws DataSourceException, ReportProcessingException {
        String string;
        if (ReportTargetUtil.isElementOfType("http://jfreereport.sourceforge.net/namespaces/engine", "object-ole", attributeMap) || this.oleHandled) {
            this.oleHandled = false;
            return;
        }
        if (ReportTargetUtil.isElementOfType("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "table-row", attributeMap) && this.isElementBoundaryCollectionPass() && this.getCurrentRole() != 11) {
            string = (String)attributeMap.getAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name");
            this.rowHeights.add(this.computeRowHeight(string));
        }
        if (this.isRepeatingSection() || this.isElementBoundaryCollectionPass()) {
            return;
        }
        string = ReportTargetUtil.getNamespaceFromAttribute(attributeMap);
        if (this.isFilteredNamespace(string)) {
            return;
        }
        String string2 = ReportTargetUtil.getElemenTypeFromAttribute(attributeMap);
        if ("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0".equals(string) && "frame".equals(string2)) {
            return;
        }
        if ("urn:oasis:names:tc:opendocument:xmlns:table:1.0".equals(string) && ("table".equals(string2) || "covered-table-cell".equals(string2) || "table-column".equals(string2) || "table-columns".equals(string2))) {
            return;
        }
        if (!this.paragraphHandled && "urn:oasis:names:tc:opendocument:xmlns:text:1.0".equals(string) && "p".equals(string2)) {
            if (!this.paragraphHandled) {
                return;
            }
            this.paragraphHandled = false;
        }
        try {
            XmlWriter xmlWriter = this.getXmlWriter();
            xmlWriter.writeCloseTag();
            this.generateCoveredTableCells(attributeMap);
        }
        catch (IOException iOException) {
            throw new ReportProcessingException("Failed", iOException);
        }
    }

    private void generateCoveredTableCells(AttributeMap attributeMap) throws IOException {
        if (!ReportTargetUtil.isElementOfType("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "table-cell", attributeMap)) {
            return;
        }
        XmlWriter xmlWriter = this.getXmlWriter();
        int n = this.currentSpan;
        this.currentSpan = 0;
        for (int i = 1; i < n; ++i) {
            xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "covered-table-cell", null, true);
        }
    }

    @Override
    public String getExportDescriptor() {
        return "raw/application/vnd.oasis.opendocument.spreadsheet";
    }

    @Override
    public void processText(String string) throws DataSourceException, ReportProcessingException {
        if (!this.isRepeatingSection() && !this.isElementBoundaryCollectionPass()) {
            this.handleParagraph();
            super.processText(string);
        }
    }

    @Override
    public void processContent(DataFlags dataFlags) throws DataSourceException, ReportProcessingException {
        if (!this.isRepeatingSection() && !this.isElementBoundaryCollectionPass()) {
            this.handleParagraph();
            super.processContent(dataFlags);
        }
    }

    private String getStartContent() {
        return "spreadsheet";
    }

    @Override
    protected void startContent(AttributeMap attributeMap) throws IOException, DataSourceException, ReportProcessingException {
        if (!this.isElementBoundaryCollectionPass()) {
            XmlWriter xmlWriter = this.getXmlWriter();
            xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:office:1.0", this.getStartContent(), null, false);
            this.writeNullDate();
            AttributeMap attributeMap2 = new AttributeMap();
            attributeMap2.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "namespace", (Object)"urn:oasis:names:tc:opendocument:xmlns:table:1.0");
            attributeMap2.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "type", (Object)"table");
            attributeMap2.setAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name", (Object)this.generateInitialTableStyle());
            attributeMap2.setAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "name", (Object)"Report");
            this.performStyleProcessing(attributeMap2);
            xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "table", this.buildAttributeList(attributeMap2), false);
            this.createTableShapes();
            this.createTableColumns();
        }
    }

    private String generateInitialTableStyle() throws ReportProcessingException {
        OfficeStylesCollection officeStylesCollection = this.getPredefinedStylesCollection();
        OfficeStyles officeStyles = officeStylesCollection.getAutomaticStyles();
        if (!officeStyles.containsStyle("table", "Initial_Table")) {
            String string = this.createMasterPage();
            OfficeStyle officeStyle = new OfficeStyle();
            officeStyle.setStyleFamily("table");
            officeStyle.setStyleName("Initial_Table");
            officeStyle.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "master-page-name", string);
            Element element = this.produceFirstChild(officeStyle, "urn:oasis:names:tc:opendocument:xmlns:style:1.0", "table-properties");
            element.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "background-color", TRANSPARENT);
            officeStyles.addStyle(officeStyle);
        }
        return "Initial_Table";
    }

    private String createMasterPage() throws ReportProcessingException {
        OfficeMasterPage officeMasterPage;
        OfficeStylesCollection officeStylesCollection = this.getPredefinedStylesCollection();
        MasterPageFactory masterPageFactory = new MasterPageFactory(officeStylesCollection.getMasterStyles());
        if (!masterPageFactory.containsMasterPage("Standard", null, null)) {
            Object object;
            officeMasterPage = masterPageFactory.createMasterPage("Standard", null, null);
            CSSNumericValue cSSNumericValue = CSSNumericValue.createValue((CSSNumericType)CSSNumericType.CM, (double)0.0);
            String string = officeMasterPage.getPageLayout();
            if (string == null) {
                object = masterPageFactory.createPageStyle(this.getGlobalStylesCollection().getAutomaticStyles(), cSSNumericValue, cSSNumericValue);
                officeMasterPage.setPageLayout((String)object);
            } else {
                object = masterPageFactory.derivePageStyle(string, this.getPredefinedStylesCollection().getAutomaticStyles(), this.getGlobalStylesCollection().getAutomaticStyles(), cSSNumericValue, cSSNumericValue);
                officeMasterPage.setPageLayout((String)object);
            }
            object = this.getGlobalStylesCollection();
            OfficeMasterStyles officeMasterStyles = ((OfficeStylesCollection)object).getMasterStyles();
            officeMasterStyles.addMasterPage(officeMasterPage);
        } else {
            officeMasterPage = masterPageFactory.getMasterPage("Standard", null, null);
        }
        return officeMasterPage.getStyleName();
    }

    @Override
    protected void endContent(AttributeMap attributeMap) throws IOException, DataSourceException, ReportProcessingException {
        if (!this.isElementBoundaryCollectionPass()) {
            XmlWriter xmlWriter = this.getXmlWriter();
            xmlWriter.writeCloseTag();
            xmlWriter.writeCloseTag();
        }
    }

    @Override
    public void endReport(ReportStructureRoot reportStructureRoot) throws DataSourceException, ReportProcessingException {
        super.endReport(reportStructureRoot);
        this.setElementBoundaryCollectionPass(false);
        this.resetTableCounter();
        this.columnCounter = 0;
        this.copyMeta();
    }

    private boolean isElementBoundaryCollectionPass() {
        return this.elementBoundaryCollectionPass;
    }

    private void setElementBoundaryCollectionPass(boolean bl) {
        this.elementBoundaryCollectionPass = bl;
    }

    private ColumnBoundary[] getSortedColumnBoundaryArray() {
        if (this.sortedBoundaryArray == null) {
            this.getColumnBoundaryList().add(new ColumnBoundary(0L));
            this.sortedBoundaryArray = this.getColumnBoundaryList().toArray(new ColumnBoundary[this.getColumnBoundaryList().size()]);
            Arrays.sort(this.sortedBoundaryArray);
        }
        return this.sortedBoundaryArray;
    }

    private List<ColumnBoundary> getColumnBoundaryList() {
        return this.columnBoundaryList;
    }

    private void addColumnWidthToRowBoundaryMarker(long l) {
        this.currentRowBoundaryMarker += l;
    }

    private long getCurrentRowBoundaryMarker() {
        return this.currentRowBoundaryMarker;
    }

    private void resetTableCounter() {
        this.tableCounter = 0;
    }

    private void resetCurrentRowBoundaryMarker() {
        this.currentRowBoundaryMarker = 0L;
    }

    private ColumnBoundary[] getBoundariesForTable(int n) {
        if (this.boundariesForTableArray == null) {
            ArrayList<ColumnBoundary> arrayList = new ArrayList<ColumnBoundary>();
            List<ColumnBoundary> list = this.getColumnBoundaryList();
            for (int i = 0; i < list.size(); ++i) {
                ColumnBoundary columnBoundary = list.get(i);
                if (!columnBoundary.isContainedByTable(n)) continue;
                arrayList.add(columnBoundary);
            }
            this.boundariesForTableArray = arrayList.toArray(new ColumnBoundary[arrayList.size()]);
            Arrays.sort(this.boundariesForTableArray);
        }
        return this.boundariesForTableArray;
    }

    private int getColumnSpanForCell(int n, int n2, int n3) {
        int n4;
        int n5;
        ColumnBoundary[] columnBoundaryArray = this.getSortedColumnBoundaryArray();
        ColumnBoundary[] columnBoundaryArray2 = this.getBoundariesForTable(n);
        float f = columnBoundaryArray2[n2 - 1].getBoundary();
        float f2 = columnBoundaryArray2[n2 - 1].getBoundary();
        if (n2 > 1) {
            f2 -= columnBoundaryArray2[n2 - 2].getBoundary();
        }
        if (n3 > 1) {
            n5 = n2 - 1 + (n3 - 1);
            f2 += columnBoundaryArray2[n5].getBoundary() - columnBoundaryArray2[n2 - 1].getBoundary();
            f = columnBoundaryArray2[n5].getBoundary();
        }
        n5 = 0;
        int n6 = columnBoundaryArray.length - 1;
        for (n4 = 0; n4 < columnBoundaryArray.length; ++n4) {
            if (columnBoundaryArray[n4].getBoundary() <= f - f2) {
                n5 = n4;
            }
            if (!(columnBoundaryArray[n4].getBoundary() <= f)) continue;
            n6 = n4;
        }
        n4 = n6 - n5;
        if (n4 == 0) {
            return 1;
        }
        return n4;
    }

    @Override
    protected String getTargetMimeType() {
        return "application/vnd.oasis.opendocument.spreadsheet";
    }

    private static class ColumnBoundary
    implements Comparable<ColumnBoundary> {
        private final Set<Integer> tableIndices = new HashSet<Integer>();
        private final long boundary;

        private ColumnBoundary(long l) {
            this.boundary = l;
        }

        public void addTableIndex(int n) {
            this.tableIndices.add(IntegerCache.getInteger(n));
        }

        public float getBoundary() {
            return this.boundary;
        }

        public boolean isContainedByTable(int n) {
            Integer n2 = IntegerCache.getInteger(n);
            return this.tableIndices.contains(n2);
        }

        @Override
        public int compareTo(ColumnBoundary columnBoundary) {
            if (columnBoundary.equals(this)) {
                return 0;
            }
            if (this.boundary > columnBoundary.boundary) {
                return 1;
            }
            return -1;
        }

        public boolean equals(Object object) {
            return object instanceof ColumnBoundary && ((ColumnBoundary)object).boundary == this.boundary;
        }

        public int hashCode() {
            assert (false) : "hashCode not designed";
            return 42;
        }
    }
}

