/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import jakarta.persistence.GenerationType;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Timeout;
import java.lang.reflect.Type;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.JDBCException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.QueryTimeoutException;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DmlTargetColumnQualifierSupport;
import org.hibernate.dialect.FunctionalDependencyAnalysisSupport;
import org.hibernate.dialect.FunctionalDependencyAnalysisSupportImpl;
import org.hibernate.dialect.NationalizationSupport;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.PostgreSQLDriverKind;
import org.hibernate.dialect.Replacer;
import org.hibernate.dialect.SelectItemReferenceStrategy;
import org.hibernate.dialect.TimeZoneSupport;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.dialect.aggregate.PostgreSQLAggregateSupport;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.PostgreSQLMinMaxFunction;
import org.hibernate.dialect.function.PostgreSQLTruncFunction;
import org.hibernate.dialect.function.PostgreSQLTruncRoundFunction;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.identity.PostgreSQLIdentityColumnSupport;
import org.hibernate.dialect.lock.internal.PostgreSQLLockingSupport;
import org.hibernate.dialect.lock.spi.LockingSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.OffsetFetchLimitHandler;
import org.hibernate.dialect.sequence.PostgreSQLSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.sql.ast.PostgreSQLSqlAstTranslator;
import org.hibernate.dialect.temptable.StandardLocalTemporaryTableStrategy;
import org.hibernate.dialect.temptable.TemporaryTableStrategy;
import org.hibernate.dialect.type.PgJdbcHelper;
import org.hibernate.dialect.type.PostgreSQLArrayJdbcTypeConstructor;
import org.hibernate.dialect.type.PostgreSQLCastingInetJdbcType;
import org.hibernate.dialect.type.PostgreSQLCastingIntervalSecondJdbcType;
import org.hibernate.dialect.type.PostgreSQLCastingJsonArrayJdbcTypeConstructor;
import org.hibernate.dialect.type.PostgreSQLCastingJsonJdbcType;
import org.hibernate.dialect.type.PostgreSQLEnumJdbcType;
import org.hibernate.dialect.type.PostgreSQLOrdinalEnumJdbcType;
import org.hibernate.dialect.type.PostgreSQLStructCastingJdbcType;
import org.hibernate.dialect.type.PostgreSQLUUIDJdbcType;
import org.hibernate.dialect.unique.CreateTableUniqueDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierCaseStrategy;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.mapping.AggregateColumn;
import org.hibernate.mapping.Table;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.SqlExpressible;
import org.hibernate.metamodel.mapping.SqlTypedMapping;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.mutation.EntityMutationTarget;
import org.hibernate.procedure.internal.PostgreSQLCallableStatementSupport;
import org.hibernate.procedure.spi.CallableStatementSupport;
import org.hibernate.query.SemanticException;
import org.hibernate.query.common.FetchClauseType;
import org.hibernate.query.common.TemporalUnit;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.sqm.CastType;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.mutation.internal.cte.CteInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.cte.CteMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.ParameterMarkerStrategy;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.internal.OptionalTableUpdate;
import org.hibernate.sql.model.jdbc.OptionalTableUpdateWithUpsertOperation;
import org.hibernate.tool.schema.extract.spi.ColumnTypeInformation;
import org.hibernate.tool.schema.internal.StandardTableExporter;
import org.hibernate.tool.schema.spi.Exporter;
import org.hibernate.type.JavaObjectType;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayJavaType;
import org.hibernate.type.descriptor.jdbc.BlobJdbcType;
import org.hibernate.type.descriptor.jdbc.ClobJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.ObjectNullAsBinaryTypeJdbcType;
import org.hibernate.type.descriptor.jdbc.SqlTypedJdbcType;
import org.hibernate.type.descriptor.jdbc.XmlJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.internal.ArrayDdlTypeImpl;
import org.hibernate.type.descriptor.sql.internal.CapacityDependentDdlType;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.internal.NamedNativeEnumDdlTypeImpl;
import org.hibernate.type.descriptor.sql.internal.NamedNativeOrdinalEnumDdlTypeImpl;
import org.hibernate.type.descriptor.sql.internal.Scale6IntervalSecondDdlType;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class PostgreSQLDialect
extends Dialect {
    protected static final DatabaseVersion MINIMUM_VERSION = DatabaseVersion.make(13);
    private final UniqueDelegate uniqueDelegate = new CreateTableUniqueDelegate(this);
    private final StandardTableExporter postgresqlTableExporter = new StandardTableExporter(this){

        @Override
        protected void applyAggregateColumnCheck(StringBuilder buf, AggregateColumn aggregateColumn) {
            JdbcType jdbcType = aggregateColumn.getType().getJdbcType();
            if (jdbcType.isXml()) {
                return;
            }
            super.applyAggregateColumnCheck(buf, aggregateColumn);
        }
    };
    protected final PostgreSQLDriverKind driverKind;
    private final ParameterMarkerStrategy parameterRenderer;
    private final boolean supportsMerge;
    private static final ViolatedConstraintNameExtractor EXTRACTOR = new TemplatedViolatedConstraintNameExtractor(sqle -> {
        String string;
        String sqlState = JdbcExceptionHelper.extractSqlState(sqle);
        if (sqlState == null) {
            string = null;
        } else {
            switch (Integer.parseInt(sqlState)) {
                case 23503: 
                case 23505: 
                case 23514: {
                    string = TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("constraint \"", "\"", sqle.getMessage());
                    break;
                }
                case 23502: {
                    string = TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("column \"", "\"", sqle.getMessage());
                    break;
                }
                default: {
                    string = null;
                }
            }
        }
        return string;
    });

    public PostgreSQLDialect() {
        this(MINIMUM_VERSION);
    }

    public PostgreSQLDialect(DialectResolutionInfo info) {
        this(info.makeCopyOrDefault(MINIMUM_VERSION), PostgreSQLDriverKind.determineKind(info));
        this.registerKeywords(info);
    }

    public PostgreSQLDialect(DatabaseVersion version) {
        this(version, PostgreSQLDriverKind.PG_JDBC);
    }

    public PostgreSQLDialect(DatabaseVersion version, PostgreSQLDriverKind driverKind) {
        super(version);
        this.driverKind = driverKind;
        this.parameterRenderer = driverKind == PostgreSQLDriverKind.VERT_X ? NativeParameterMarkers.INSTANCE : super.getNativeParameterMarkerStrategy();
        this.supportsMerge = version.isSameOrAfter(DatabaseVersion.make(15, 0));
    }

    public PostgreSQLDriverKind getDriverKind() {
        return this.driverKind;
    }

    @Override
    protected DatabaseVersion getMinimumSupportedVersion() {
        return MINIMUM_VERSION;
    }

    @Override
    public boolean getDefaultNonContextualLobCreation() {
        return true;
    }

    @Override
    protected String columnType(int sqlTypeCode) {
        return switch (sqlTypeCode) {
            case -6 -> "smallint";
            case -15 -> this.columnType(1);
            case -9 -> this.columnType(12);
            case 4001, 4002 -> "text";
            case 2004, 2005, 2011 -> "oid";
            case -3, -2, 4003 -> "bytea";
            case 3003 -> this.columnType(2014);
            default -> super.columnType(sqlTypeCode);
        };
    }

    @Override
    protected String castType(int sqlTypeCode) {
        return switch (sqlTypeCode) {
            case -15, -9, 1, 12 -> "varchar";
            case 4001, 4002 -> "text";
            case -3, -2, 4003 -> "bytea";
            default -> super.castType(sqlTypeCode);
        };
    }

    @Override
    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.registerColumnTypes(typeContributions, serviceRegistry);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        ddlTypeRegistry.addDescriptor(new ArrayDdlTypeImpl(this, true));
        ddlTypeRegistry.addDescriptor(CapacityDependentDdlType.builder(6, this.columnType(6), this.castType(6), (Dialect)this).withTypeCapacity(24L, "float4").build());
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(2009, "xml", this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3000, "uuid", this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3002, "inet", this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3200, "geometry", this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3250, "geography", this));
        ddlTypeRegistry.addDescriptor(new Scale6IntervalSecondDdlType(this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3001, "jsonb", this));
        ddlTypeRegistry.addDescriptor(new NamedNativeEnumDdlTypeImpl(this));
        ddlTypeRegistry.addDescriptor(new NamedNativeOrdinalEnumDdlTypeImpl(this));
    }

    @Override
    public int getMaxVarcharLength() {
        return 0xA00000;
    }

    @Override
    public int getMaxVarcharCapacity() {
        return 0x40000000;
    }

    @Override
    public int getMaxVarbinaryLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getDefaultStatementBatchSize() {
        return 15;
    }

    @Override
    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        switch (jdbcTypeCode) {
            case 1111: {
                switch (columnTypeName) {
                    case "uuid": {
                        jdbcTypeCode = 3000;
                        break;
                    }
                    case "json": 
                    case "jsonb": {
                        jdbcTypeCode = 3001;
                        break;
                    }
                    case "xml": {
                        jdbcTypeCode = 2009;
                        break;
                    }
                    case "inet": {
                        jdbcTypeCode = 3002;
                        break;
                    }
                    case "geometry": {
                        jdbcTypeCode = 3200;
                        break;
                    }
                    case "geography": {
                        jdbcTypeCode = 3250;
                    }
                }
                break;
            }
            case 92: {
                if (!"timetz".equals(columnTypeName)) break;
                jdbcTypeCode = 3007;
                break;
            }
            case 93: {
                if (!"timestamptz".equals(columnTypeName)) break;
                jdbcTypeCode = 3003;
                break;
            }
            case 2003: {
                if (columnTypeName.charAt(0) != '_') break;
                String componentTypeName = columnTypeName.substring(1);
                Integer sqlTypeCode = this.resolveSqlTypeCode(componentTypeName, jdbcTypeRegistry.getTypeConfiguration());
                if (sqlTypeCode != null) {
                    return jdbcTypeRegistry.resolveTypeConstructorDescriptor(jdbcTypeCode, jdbcTypeRegistry.getDescriptor(sqlTypeCode), ColumnTypeInformation.EMPTY);
                }
                SqlTypedJdbcType elementDescriptor = jdbcTypeRegistry.findSqlTypedDescriptor(componentTypeName);
                if (elementDescriptor == null) break;
                return jdbcTypeRegistry.resolveTypeConstructorDescriptor(jdbcTypeCode, elementDescriptor, ColumnTypeInformation.EMPTY);
            }
            case 2002: {
                SqlTypedJdbcType descriptor = jdbcTypeRegistry.findSqlTypedDescriptor(columnTypeName.substring(columnTypeName.indexOf(46) + 1));
                if (descriptor == null) break;
                return descriptor;
            }
        }
        return jdbcTypeRegistry.getDescriptor(jdbcTypeCode);
    }

    @Override
    protected Integer resolveSqlTypeCode(String columnTypeName, TypeConfiguration typeConfiguration) {
        return switch (columnTypeName) {
            case "bool" -> 16;
            case "float4" -> 7;
            case "float8" -> 8;
            case "int2" -> 5;
            case "int4" -> 4;
            case "int8" -> -5;
            default -> super.resolveSqlTypeCode(columnTypeName, typeConfiguration);
        };
    }

    @Override
    public String getEnumTypeDeclaration(String name, String[] values) {
        return name;
    }

    @Override
    public String[] getCreateEnumTypeCommand(String name, String[] values) {
        StringBuilder type = new StringBuilder();
        type.append("create type ").append(name).append(" as enum (");
        String separator = "";
        for (String value : values) {
            type.append(separator).append('\'').append(value).append('\'');
            separator = ",";
        }
        type.append(')');
        String cast1 = "create cast (varchar as " + name + ") with inout as implicit";
        String cast2 = "create cast (" + name + " as varchar) with inout as implicit";
        return new String[]{type.toString(), cast1, cast2};
    }

    @Override
    public String[] getDropEnumTypeCommand(String name) {
        return new String[]{"drop type if exists " + name + " cascade"};
    }

    @Override
    public String currentTime() {
        return "localtime";
    }

    @Override
    public String currentTimestamp() {
        return "localtimestamp";
    }

    @Override
    public String currentTimestampWithTimeZone() {
        return "current_timestamp";
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        return switch (unit) {
            case TemporalUnit.DAY_OF_WEEK -> "(" + super.extractPattern(unit) + "+1)";
            default -> super.extractPattern(unit);
        };
    }

    @Override
    public String castPattern(CastType from, CastType to) {
        if (from == CastType.STRING && to == CastType.BOOLEAN) {
            return "cast(?1 as ?2)";
        }
        return super.castPattern(from, to);
    }

    @Override
    public long getFractionalSecondPrecisionInNanos() {
        return 1000000000L;
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        return intervalType != null ? "(?2+?3)" : "cast(?3+" + PostgreSQLDialect.intervalPattern(unit) + " as " + temporalType.name().toLowerCase() + ")";
    }

    private static String intervalPattern(TemporalUnit unit) {
        return switch (unit) {
            case TemporalUnit.NANOSECOND -> "(?2)/1e3*interval '1 microsecond'";
            case TemporalUnit.NATIVE -> "(?2)*interval '1 second'";
            case TemporalUnit.QUARTER -> "(?2)*interval '3 month'";
            case TemporalUnit.WEEK -> "(?2)*interval '7 day'";
            default -> "(?2)*interval '1 " + String.valueOf((Object)unit) + "'";
        };
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        if (unit == null) {
            return "(?3-?2)";
        }
        if (toTemporalType == TemporalType.DATE && fromTemporalType == TemporalType.DATE) {
            return switch (unit) {
                case TemporalUnit.QUARTER, TemporalUnit.YEAR, TemporalUnit.MONTH -> "extract(" + this.translateDurationField(unit) + " from age(?3,?2))";
                default -> "(?3-?2)" + TemporalUnit.DAY.conversionFactor(unit, this);
            };
        }
        return switch (unit) {
            case TemporalUnit.YEAR -> "extract(year from ?3-?2)";
            case TemporalUnit.QUARTER -> "(extract(year from ?3-?2)*4+extract(month from ?3-?2)/3)";
            case TemporalUnit.MONTH -> "(extract(year from ?3-?2)*12+extract(month from ?3-?2))";
            case TemporalUnit.WEEK -> "(extract(day from ?3-?2)/7)";
            case TemporalUnit.DAY -> "extract(day from ?3-?2)";
            case TemporalUnit.NANOSECOND, TemporalUnit.NATIVE, TemporalUnit.HOUR, TemporalUnit.MINUTE, TemporalUnit.SECOND -> "extract(epoch from ?3-?2)" + TemporalUnit.EPOCH.conversionFactor(unit, this);
            default -> throw new SemanticException("Unrecognized field: " + String.valueOf((Object)unit));
        };
    }

    @Override
    public TimeZoneSupport getTimeZoneSupport() {
        return TimeZoneSupport.NORMALIZE;
    }

    @Override
    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.cot();
        functionFactory.radians();
        functionFactory.degrees();
        functionFactory.log();
        functionFactory.mod_operator();
        functionFactory.log10();
        functionFactory.tanh();
        functionFactory.sinh();
        functionFactory.cosh();
        functionFactory.moreHyperbolic();
        functionFactory.cbrt();
        functionFactory.pi();
        functionFactory.trim2();
        functionFactory.repeat();
        functionFactory.initcap();
        functionFactory.substr();
        functionFactory.substring_substr();
        functionFactory.translate();
        functionFactory.toCharNumberDateTimestamp();
        functionFactory.concat_pipeOperator("convert_from(lo_get(?1),pg_client_encoding())");
        functionFactory.localtimeLocaltimestamp();
        functionFactory.length_characterLength_pattern("length(lo_get(?1),pg_client_encoding())");
        functionFactory.bitLength_pattern("bit_length(?1)", "length(lo_get(?1))*8");
        functionFactory.octetLength_pattern("octet_length(?1)", "length(lo_get(?1))");
        functionFactory.ascii();
        functionFactory.char_chr();
        functionFactory.position();
        functionFactory.bitandorxornot_operator();
        functionFactory.bitAndOr();
        functionFactory.everyAny_boolAndOr();
        functionFactory.median_percentileCont(false);
        functionFactory.stddev();
        functionFactory.stddevPopSamp();
        functionFactory.variance();
        functionFactory.varPopSamp();
        functionFactory.covarPopSamp();
        functionFactory.corr();
        functionFactory.regrLinearRegressionAggregates();
        functionFactory.insert_overlay();
        functionFactory.overlay();
        functionFactory.soundex();
        functionFactory.locate_positionSubstring();
        functionFactory.windowFunctions();
        functionFactory.listagg_stringAgg("varchar");
        functionFactory.array_postgresql();
        functionFactory.arrayAggregate();
        functionFactory.arrayPosition_postgresql();
        functionFactory.arrayPositions_postgresql();
        functionFactory.arrayLength_cardinality();
        functionFactory.arrayConcat_postgresql();
        functionFactory.arrayPrepend_postgresql();
        functionFactory.arrayAppend_postgresql();
        functionFactory.arrayContains_postgresql();
        functionFactory.arrayIntersects_postgresql();
        functionFactory.arrayGet_bracket();
        functionFactory.arraySet_unnest();
        functionFactory.arrayRemove();
        functionFactory.arrayRemoveIndex_unnest(true);
        functionFactory.arraySlice_operator();
        functionFactory.arrayReplace();
        if (this.getVersion().isSameOrAfter(14)) {
            functionFactory.arrayTrim_trim_array();
        } else {
            functionFactory.arrayTrim_unnest();
        }
        functionFactory.arrayFill_postgresql();
        functionFactory.arrayToString_postgresql();
        if (this.getVersion().isSameOrAfter(17)) {
            functionFactory.jsonValue_postgresql(true);
            functionFactory.jsonQuery();
            functionFactory.jsonExists();
            functionFactory.jsonObject();
            functionFactory.jsonArray();
            functionFactory.jsonArrayAgg_postgresql(true);
            functionFactory.jsonObjectAgg_postgresql(true);
            functionFactory.jsonTable();
        } else {
            functionFactory.jsonValue_postgresql(false);
            functionFactory.jsonQuery_postgresql();
            functionFactory.jsonExists_postgresql();
            if (this.getVersion().isSameOrAfter(16)) {
                functionFactory.jsonObject();
                functionFactory.jsonArray();
                functionFactory.jsonArrayAgg_postgresql(true);
                functionFactory.jsonObjectAgg_postgresql(true);
            } else {
                functionFactory.jsonObject_postgresql();
                functionFactory.jsonArray_postgresql();
                functionFactory.jsonArrayAgg_postgresql(false);
                functionFactory.jsonObjectAgg_postgresql(false);
            }
            functionFactory.jsonTable_postgresql();
        }
        functionFactory.jsonSet_postgresql();
        functionFactory.jsonRemove_postgresql();
        functionFactory.jsonReplace_postgresql();
        functionFactory.jsonInsert_postgresql();
        functionFactory.jsonMergepatch_postgresql();
        functionFactory.jsonArrayAppend_postgresql(true);
        functionFactory.jsonArrayInsert_postgresql();
        functionFactory.xmlelement();
        functionFactory.xmlcomment();
        functionFactory.xmlforest();
        functionFactory.xmlconcat();
        functionFactory.xmlpi();
        functionFactory.xmlquery_postgresql();
        functionFactory.xmlexists();
        functionFactory.xmlagg();
        functionFactory.xmltable(true);
        functionFactory.makeDateTimeTimestamp();
        functionFactory.inverseDistributionOrderedSetAggregates();
        functionFactory.hypotheticalOrderedSetAggregates();
        if (!this.supportsMinMaxOnUuid()) {
            functionContributions.getFunctionRegistry().register("min", new PostgreSQLMinMaxFunction("min"));
            functionContributions.getFunctionRegistry().register("max", new PostgreSQLMinMaxFunction("max"));
        }
        functionContributions.getFunctionRegistry().patternDescriptorBuilder("bitxor", "(?1#?2)").setExactArgumentCount(2).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
        functionContributions.getFunctionRegistry().register("round", new PostgreSQLTruncRoundFunction("round", true));
        functionContributions.getFunctionRegistry().register("trunc", new PostgreSQLTruncFunction(true, functionContributions.getTypeConfiguration()));
        functionContributions.getFunctionRegistry().registerAlternateKey("truncate", "trunc");
        functionFactory.dateTrunc();
        functionFactory.unnest_postgresql(this.getVersion().isSameOrAfter(17));
        functionFactory.generateSeries(null, "ordinality", false);
        functionFactory.hex("encode(?1, 'hex')");
        functionFactory.sha("sha256(?1)");
        functionFactory.md5("decode(md5(?1), 'hex')");
    }

    @Override
    public @Nullable String getDefaultOrdinalityColumnName() {
        return "ordinality";
    }

    protected boolean supportsMinMaxOnUuid() {
        return false;
    }

    @Override
    public NameQualifierSupport getNameQualifierSupport() {
        return NameQualifierSupport.SCHEMA;
    }

    @Override
    public String getCurrentSchemaCommand() {
        return "select current_schema()";
    }

    @Override
    public boolean supportsDistinctFromPredicate() {
        return true;
    }

    @Override
    public boolean supportsIfExistsBeforeTableName() {
        return true;
    }

    @Override
    public boolean supportsIfExistsBeforeTypeName() {
        return true;
    }

    @Override
    public boolean supportsIfExistsBeforeConstraintName() {
        return true;
    }

    @Override
    public boolean supportsIfExistsAfterAlterTable() {
        return true;
    }

    @Override
    public String getBeforeDropStatement() {
        return "set client_min_messages = WARNING";
    }

    @Override
    public String getAlterColumnTypeString(String columnName, String columnType, String columnDefinition) {
        return "alter column " + columnName + " set data type " + columnType;
    }

    @Override
    public boolean supportsAlterColumnType() {
        return true;
    }

    @Override
    public boolean supportsValuesList() {
        return true;
    }

    @Override
    public boolean supportsPartitionBy() {
        return true;
    }

    @Override
    public boolean addPartitionKeyToPrimaryKey() {
        return true;
    }

    @Override
    public boolean supportsNonQueryWithCTE() {
        return true;
    }

    @Override
    public boolean supportsConflictClauseForInsertCTE() {
        return true;
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return PostgreSQLSequenceSupport.INSTANCE;
    }

    @Override
    public String getCascadeConstraintsString() {
        return " cascade";
    }

    @Override
    public String getQuerySequencesString() {
        return "select * from information_schema.sequences";
    }

    @Override
    public LimitHandler getLimitHandler() {
        return OffsetFetchLimitHandler.INSTANCE;
    }

    @Override
    public String getForUpdateString(String aliases) {
        return this.getForUpdateString() + " of " + aliases;
    }

    @Override
    public String getForUpdateString(String aliases, LockOptions lockOptions) {
        LockMode lockMode = lockOptions.getLockMode();
        return switch (lockMode) {
            case LockMode.PESSIMISTIC_READ -> this.getReadLockString(aliases, lockOptions.getTimeout());
            case LockMode.PESSIMISTIC_WRITE -> this.getWriteLockString(aliases, lockOptions.getTimeout());
            case LockMode.UPGRADE_NOWAIT, LockMode.PESSIMISTIC_FORCE_INCREMENT -> this.getForUpdateNowaitString(aliases);
            case LockMode.UPGRADE_SKIPLOCKED -> this.getForUpdateSkipLockedString(aliases);
            default -> "";
        };
    }

    @Override
    public String getNoColumnsInsertString() {
        return "default values";
    }

    @Override
    public String getCaseInsensitiveLike() {
        return "ilike";
    }

    @Override
    public boolean supportsCaseInsensitiveLike() {
        return true;
    }

    @Override
    public GenerationType getNativeValueGenerationStrategy() {
        return GenerationType.SEQUENCE;
    }

    @Override
    public boolean useInputStreamToInsertBlob() {
        return false;
    }

    @Override
    public boolean useConnectionToCreateLob() {
        return false;
    }

    @Override
    public String getSelectClauseNullString(int sqlType, TypeConfiguration typeConfiguration) {
        return "cast(null as " + typeConfiguration.getDdlTypeRegistry().getDescriptor(sqlType).getRawTypeName() + ")";
    }

    @Override
    public String getSelectClauseNullString(SqlTypedMapping sqlType, TypeConfiguration typeConfiguration) {
        DdlTypeRegistry ddlTypeRegistry = typeConfiguration.getDdlTypeRegistry();
        String castTypeName = ddlTypeRegistry.getDescriptor(sqlType.getJdbcMapping().getJdbcType().getDdlTypeCode()).getCastTypeName(sqlType.toSize(), (SqlExpressible)((Object)sqlType.getJdbcMapping()), ddlTypeRegistry);
        return "cast(null as " + castTypeName + ")";
    }

    @Override
    public String quoteCollation(String collation) {
        return "\"" + collation + "\"";
    }

    @Override
    public boolean supportsCommentOn() {
        return true;
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "select now()";
    }

    @Override
    public boolean supportsTupleCounts() {
        return true;
    }

    @Override
    public boolean supportsIsTrue() {
        return true;
    }

    @Override
    public boolean requiresParensForTupleDistinctCounts() {
        return true;
    }

    @Override
    public void appendBooleanValueString(SqlAppender appender, boolean bool) {
        appender.appendSql(bool);
    }

    @Override
    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData metadata) throws SQLException {
        if (metadata == null) {
            builder.setUnquotedCaseStrategy(IdentifierCaseStrategy.LOWER);
            builder.setQuotedCaseStrategy(IdentifierCaseStrategy.MIXED);
        }
        return super.buildIdentifierHelper(builder, metadata);
    }

    @Override
    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new CteMutationStrategy(rootEntityDescriptor, runtimeModelCreationContext);
    }

    @Override
    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new CteInsertStrategy(rootEntityDescriptor, runtimeModelCreationContext);
    }

    @Override
    public TemporaryTableStrategy getLocalTemporaryTableStrategy() {
        return StandardLocalTemporaryTableStrategy.INSTANCE;
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new PostgreSQLSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return EXTRACTOR;
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            JDBCException jDBCException;
            String sqlState = JdbcExceptionHelper.extractSqlState(sqlException);
            if (sqlState == null) {
                jDBCException = null;
            } else {
                switch (sqlState) {
                    case "40P01": {
                        jDBCException = new LockAcquisitionException(message, sqlException, sql);
                        break;
                    }
                    case "55P03": {
                        jDBCException = new LockTimeoutException(message, sqlException, sql);
                        break;
                    }
                    case "57014": {
                        jDBCException = new QueryTimeoutException(message, sqlException, sql);
                        break;
                    }
                    default: {
                        jDBCException = null;
                    }
                }
            }
            return jDBCException;
        };
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        statement.registerOutParameter(col++, 1111);
        return col;
    }

    @Override
    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        ps.execute();
        return (ResultSet)ps.getObject(1);
    }

    @Override
    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    @Override
    public boolean supportsUnboundedLobLocatorMaterialization() {
        return false;
    }

    @Override
    public SelectItemReferenceStrategy getGroupBySelectItemReferenceStrategy() {
        return SelectItemReferenceStrategy.POSITION;
    }

    @Override
    public CallableStatementSupport getCallableStatementSupport() {
        return PostgreSQLCallableStatementSupport.INSTANCE;
    }

    @Override
    public ResultSet getResultSet(CallableStatement statement, int position) throws SQLException {
        if (position != 1) {
            throw new UnsupportedOperationException("PostgreSQL only supports REF_CURSOR parameters as the first parameter");
        }
        return (ResultSet)statement.getObject(1);
    }

    @Override
    public ResultSet getResultSet(CallableStatement statement, String name) throws SQLException {
        throw new UnsupportedOperationException("PostgreSQL only supports accessing REF_CURSOR parameters by position");
    }

    @Override
    public boolean qualifyIndexName() {
        return false;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return PostgreSQLIdentityColumnSupport.INSTANCE;
    }

    @Override
    public NationalizationSupport getNationalizationSupport() {
        return NationalizationSupport.IMPLICIT;
    }

    @Override
    public int getMaxIdentifierLength() {
        return 63;
    }

    @Override
    public boolean supportsUserDefinedTypes() {
        return true;
    }

    @Override
    public boolean supportsStandardArrays() {
        return true;
    }

    @Override
    public boolean supportsJdbcConnectionLobCreation(DatabaseMetaData databaseMetaData) {
        return false;
    }

    @Override
    public boolean supportsMaterializedLobAccess() {
        return false;
    }

    @Override
    public boolean supportsTemporalLiteralOffset() {
        return true;
    }

    @Override
    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(this.datetimeFormat(format).result());
    }

    public Replacer datetimeFormat(String format) {
        return OracleDialect.datetimeFormat(format, true, false).replace("SSSSSS", "US").replace("SSSSS", "US").replace("SSSS", "US").replace("SSS", "MS").replace("SS", "MS").replace("S", "MS").replace("ee", "ID").replace("e", "fmID").replace("zzz", "TZ").replace("zz", "TZ").replace("z", "TZ").replace("xxx", "OF").replace("xx", "OF").replace("x", "OF");
    }

    @Override
    public String translateExtractField(TemporalUnit unit) {
        return switch (unit) {
            case TemporalUnit.DAY_OF_MONTH -> "day";
            case TemporalUnit.DAY_OF_YEAR -> "doy";
            case TemporalUnit.DAY_OF_WEEK -> "dow";
            default -> super.translateExtractField(unit);
        };
    }

    @Override
    public AggregateSupport getAggregateSupport() {
        return PostgreSQLAggregateSupport.valueOf(this);
    }

    @Override
    public void appendBinaryLiteral(SqlAppender appender, byte[] bytes) {
        appender.appendSql("bytea '\\x");
        PrimitiveByteArrayJavaType.INSTANCE.appendString(appender, bytes);
        appender.appendSql('\'');
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, TemporalAccessor temporalAccessor, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate(appender, temporalAccessor);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                if (this.supportsTemporalLiteralOffset() && temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
                    appender.appendSql("time with time zone '");
                    DateTimeUtils.appendAsTime(appender, temporalAccessor, true, jdbcTimeZone);
                } else {
                    appender.appendSql("time '");
                    DateTimeUtils.appendAsLocalTime(appender, temporalAccessor);
                }
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                if (this.supportsTemporalLiteralOffset() && temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
                    appender.appendSql("timestamp with time zone '");
                    DateTimeUtils.appendAsTimestampWithMicros(appender, temporalAccessor, true, jdbcTimeZone);
                    appender.appendSql('\'');
                    break;
                }
                appender.appendSql("timestamp '");
                DateTimeUtils.appendAsTimestampWithMicros(appender, temporalAccessor, false, jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, Date date, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate(appender, date);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time with time zone '");
                DateTimeUtils.appendAsTime(appender, date, jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp with time zone '");
                DateTimeUtils.appendAsTimestampWithMicros(appender, date, jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, Calendar calendar, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate(appender, calendar);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time with time zone '");
                DateTimeUtils.appendAsTime(appender, calendar, jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp with time zone '");
                DateTimeUtils.appendAsTimestampWithMillis(appender, calendar, jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public LockingSupport getLockingSupport() {
        return PostgreSQLLockingSupport.LOCKING_SUPPORT;
    }

    private String withTimeout(String lockString, Timeout timeout) {
        return switch (timeout.milliseconds()) {
            case 0 -> {
                if (this.supportsNoWait()) {
                    yield lockString + " nowait";
                }
                yield lockString;
            }
            case -2 -> {
                if (this.supportsSkipLocked()) {
                    yield lockString + " skip locked";
                }
                yield lockString;
            }
            default -> lockString;
        };
    }

    @Override
    public String getWriteLockString(Timeout timeout) {
        return this.withTimeout(this.getForUpdateString(), timeout);
    }

    @Override
    public String getWriteLockString(String aliases, Timeout timeout) {
        return this.withTimeout(this.getForUpdateString(aliases), timeout);
    }

    @Override
    public String getReadLockString(Timeout timeout) {
        return this.withTimeout(" for share", timeout);
    }

    @Override
    public String getReadLockString(String aliases, Timeout timeout) {
        return this.withTimeout(" for share of " + aliases, timeout);
    }

    private String withTimeout(String lockString, int timeout) {
        return switch (timeout) {
            case 0 -> {
                if (this.supportsNoWait()) {
                    yield lockString + " nowait";
                }
                yield lockString;
            }
            case -2 -> {
                if (this.supportsSkipLocked()) {
                    yield lockString + " skip locked";
                }
                yield lockString;
            }
            default -> lockString;
        };
    }

    @Override
    public String getWriteLockString(int timeout) {
        return this.withTimeout(this.getForUpdateString(), timeout);
    }

    @Override
    public String getWriteLockString(String aliases, int timeout) {
        return this.withTimeout(this.getForUpdateString(aliases), timeout);
    }

    @Override
    public String getReadLockString(int timeout) {
        return this.withTimeout(" for share", timeout);
    }

    @Override
    public String getReadLockString(String aliases, int timeout) {
        return this.withTimeout(" for share of " + aliases, timeout);
    }

    @Override
    public String getForUpdateString() {
        return " for no key update";
    }

    @Override
    public String getForUpdateNowaitString() {
        return this.supportsNoWait() ? " for update nowait" : this.getForUpdateString();
    }

    @Override
    public String getForUpdateNowaitString(String aliases) {
        return this.supportsNoWait() ? " for update of " + aliases + " nowait" : this.getForUpdateString(aliases);
    }

    @Override
    public String getForUpdateSkipLockedString() {
        return this.supportsSkipLocked() ? " for update skip locked" : this.getForUpdateString();
    }

    @Override
    public String getForUpdateSkipLockedString(String aliases) {
        return this.supportsSkipLocked() ? " for update of " + aliases + " skip locked" : this.getForUpdateString(aliases);
    }

    @Override
    public boolean supportsInsertReturning() {
        return true;
    }

    @Override
    public boolean supportsOffsetInSubquery() {
        return true;
    }

    @Override
    public boolean supportsWindowFunctions() {
        return true;
    }

    @Override
    public boolean supportsLateral() {
        return true;
    }

    @Override
    public boolean supportsRecursiveCTE() {
        return true;
    }

    @Override
    public boolean supportsFetchClause(FetchClauseType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case FetchClauseType.ROWS_ONLY -> true;
            case FetchClauseType.PERCENT_ONLY, FetchClauseType.PERCENT_WITH_TIES -> false;
            case FetchClauseType.ROWS_WITH_TIES -> true;
        };
    }

    @Override
    public FunctionalDependencyAnalysisSupport getFunctionalDependencyAnalysisSupport() {
        return FunctionalDependencyAnalysisSupportImpl.TABLE_REFERENCE;
    }

    @Override
    public void augmentRecognizedTableTypes(List<String> tableTypesList) {
        super.augmentRecognizedTableTypes(tableTypesList);
        tableTypesList.add("MATERIALIZED VIEW");
        tableTypesList.add("PARTITIONED TABLE");
    }

    @Override
    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        this.contributePostgreSQLTypes(typeContributions, serviceRegistry);
    }

    protected void contributePostgreSQLTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        JdbcTypeRegistry jdbcTypeRegistry = typeContributions.getTypeConfiguration().getJdbcTypeRegistry();
        jdbcTypeRegistry.addDescriptor(2004, BlobJdbcType.BLOB_BINDING);
        jdbcTypeRegistry.addDescriptor(2005, ClobJdbcType.CLOB_BINDING);
        jdbcTypeRegistry.addDescriptor(XmlJdbcType.INSTANCE);
        if (this.driverKind == PostgreSQLDriverKind.PG_JDBC) {
            if (PgJdbcHelper.isUsable(serviceRegistry)) {
                jdbcTypeRegistry.addDescriptorIfAbsent(PgJdbcHelper.getInetJdbcType(serviceRegistry));
                jdbcTypeRegistry.addDescriptorIfAbsent(PgJdbcHelper.getIntervalJdbcType(serviceRegistry));
                jdbcTypeRegistry.addDescriptorIfAbsent(PgJdbcHelper.getStructJdbcType(serviceRegistry));
                jdbcTypeRegistry.addDescriptorIfAbsent(PgJdbcHelper.getJsonbJdbcType(serviceRegistry));
                jdbcTypeRegistry.addTypeConstructorIfAbsent(PgJdbcHelper.getJsonbArrayJdbcType(serviceRegistry));
            } else {
                jdbcTypeRegistry.addDescriptorIfAbsent(PostgreSQLCastingInetJdbcType.INSTANCE);
                jdbcTypeRegistry.addDescriptorIfAbsent(PostgreSQLCastingIntervalSecondJdbcType.INSTANCE);
                jdbcTypeRegistry.addDescriptorIfAbsent(PostgreSQLStructCastingJdbcType.INSTANCE);
                jdbcTypeRegistry.addDescriptorIfAbsent(PostgreSQLCastingJsonJdbcType.JSONB_INSTANCE);
                jdbcTypeRegistry.addTypeConstructorIfAbsent(PostgreSQLCastingJsonArrayJdbcTypeConstructor.JSONB_INSTANCE);
            }
        } else {
            jdbcTypeRegistry.addDescriptorIfAbsent(PostgreSQLCastingInetJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptorIfAbsent(PostgreSQLCastingIntervalSecondJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptorIfAbsent(PostgreSQLStructCastingJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptorIfAbsent(PostgreSQLCastingJsonJdbcType.JSONB_INSTANCE);
            jdbcTypeRegistry.addTypeConstructorIfAbsent(PostgreSQLCastingJsonArrayJdbcTypeConstructor.JSONB_INSTANCE);
        }
        typeContributions.contributeJdbcType(ObjectNullAsBinaryTypeJdbcType.INSTANCE);
        typeContributions.contributeType(new JavaObjectType((JdbcType)ObjectNullAsBinaryTypeJdbcType.INSTANCE, typeContributions.getTypeConfiguration().getJavaTypeRegistry().getDescriptor((Type)((Object)Object.class))));
        jdbcTypeRegistry.addDescriptor(PostgreSQLEnumJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptor(PostgreSQLOrdinalEnumJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptor(PostgreSQLUUIDJdbcType.INSTANCE);
        jdbcTypeRegistry.addTypeConstructor(PostgreSQLArrayJdbcTypeConstructor.INSTANCE);
    }

    @Override
    public UniqueDelegate getUniqueDelegate() {
        return this.uniqueDelegate;
    }

    @Override
    public Exporter<Table> getTableExporter() {
        return this.postgresqlTableExporter;
    }

    @Override
    public boolean canBatchTruncate() {
        return true;
    }

    @Override
    public String rowId(String rowId) {
        return "ctid";
    }

    @Override
    public int rowIdSqlType() {
        return 1111;
    }

    @Override
    public String getQueryHintString(String sql, String hints) {
        return "/*+ " + hints + " */ " + sql;
    }

    @Override
    public String addSqlHintOrComment(String sql, QueryOptions queryOptions, boolean commentsEnabled) {
        if (commentsEnabled && queryOptions.getComment() != null) {
            sql = this.prependComment(sql, queryOptions.getComment());
        }
        if (queryOptions.getDatabaseHints() != null && !queryOptions.getDatabaseHints().isEmpty()) {
            sql = this.getQueryHintString(sql, queryOptions.getDatabaseHints());
        }
        return sql;
    }

    @Override
    public MutationOperation createOptionalTableUpdateOperation(EntityMutationTarget mutationTarget, OptionalTableUpdate optionalTableUpdate, SessionFactoryImplementor factory) {
        if (this.supportsMerge) {
            return new PostgreSQLSqlAstTranslator(factory, optionalTableUpdate).createMergeOperation(optionalTableUpdate);
        }
        return new OptionalTableUpdateWithUpsertOperation(mutationTarget, optionalTableUpdate, factory);
    }

    @Override
    public ParameterMarkerStrategy getNativeParameterMarkerStrategy() {
        return this.parameterRenderer;
    }

    @Override
    public int getDefaultIntervalSecondScale() {
        return 6;
    }

    @Override
    public DmlTargetColumnQualifierSupport getDmlTargetColumnQualifierSupport() {
        return DmlTargetColumnQualifierSupport.TABLE_ALIAS;
    }

    @Override
    public boolean supportsFromClauseInUpdate() {
        return true;
    }

    @Override
    public boolean supportsBindingNullSqlTypeForSetNull() {
        return true;
    }

    @Override
    public boolean supportsFilterClause() {
        return true;
    }

    @Override
    public boolean supportsRowConstructor() {
        return true;
    }

    @Override
    public boolean supportsArrayConstructor() {
        return true;
    }

    @Override
    public boolean supportsRecursiveCycleClause() {
        return this.getVersion().isSameOrAfter(14);
    }

    @Override
    public boolean supportsRecursiveCycleUsingClause() {
        return this.getVersion().isSameOrAfter(14);
    }

    @Override
    public boolean supportsRecursiveSearchClause() {
        return this.getVersion().isSameOrAfter(14);
    }

    private static class NativeParameterMarkers
    implements ParameterMarkerStrategy {
        public static final NativeParameterMarkers INSTANCE = new NativeParameterMarkers();

        private NativeParameterMarkers() {
        }

        @Override
        public String createMarker(int position, JdbcType jdbcType) {
            return "$" + position;
        }
    }
}

