/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.namednumber.NamedNumber;

public final class IpV6RoutingType
extends NamedNumber<Byte, IpV6RoutingType> {
    private static final long serialVersionUID = 3229438606992762639L;
    public static final IpV6RoutingType SOURCE_ROUTE = new IpV6RoutingType((byte)0, "Source Route");
    public static final IpV6RoutingType NIMROD = new IpV6RoutingType((byte)1, "Nimrod");
    public static final IpV6RoutingType TYPE2_ROUTING_HEADER = new IpV6RoutingType((byte)2, "Type 2 Routing Header");
    public static final IpV6RoutingType RPL_SOURCE_ROUTE_HEADER = new IpV6RoutingType((byte)3, "RPL Source Route Header");
    private static final Map<Byte, IpV6RoutingType> registry = new HashMap<Byte, IpV6RoutingType>();

    public IpV6RoutingType(Byte value2, String name) {
        super(value2, name);
    }

    public static IpV6RoutingType getInstance(Byte value2) {
        if (registry.containsKey(value2)) {
            return registry.get(value2);
        }
        return new IpV6RoutingType(value2, "unknown");
    }

    public static IpV6RoutingType register(IpV6RoutingType number) {
        return registry.put((Byte)number.value(), number);
    }

    @Override
    public String valueAsString() {
        return String.valueOf((Byte)this.value() & 0xFF);
    }

    @Override
    public int compareTo(IpV6RoutingType o) {
        return ((Byte)this.value()).compareTo((Byte)o.value());
    }

    static {
        registry.put((Byte)SOURCE_ROUTE.value(), SOURCE_ROUTE);
        registry.put((Byte)NIMROD.value(), NIMROD);
        registry.put((Byte)TYPE2_ROUTING_HEADER.value(), TYPE2_ROUTING_HEADER);
        registry.put((Byte)RPL_SOURCE_ROUTE_HEADER.value(), RPL_SOURCE_ROUTE_HEADER);
    }
}

