/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.util.Map;
import java.util.Properties;
import net.i2p.sam.SAMv3Handler;

class SessionRecord {
    private final String m_dest;
    private final Properties m_props;
    private ThreadGroup m_threadgroup;
    private final SAMv3Handler m_handler;

    public SessionRecord(String dest, Properties props, SAMv3Handler handler) {
        this.m_dest = dest;
        this.m_props = new Properties();
        this.m_props.putAll((Map<?, ?>)props);
        this.m_handler = handler;
    }

    public SessionRecord(SessionRecord in) {
        this.m_dest = in.getDest();
        this.m_props = in.getProps();
        this.m_threadgroup = in.getThreadGroup();
        this.m_handler = in.getHandler();
    }

    public String getDest() {
        return this.m_dest;
    }

    public synchronized Properties getProps() {
        Properties p = new Properties();
        p.putAll((Map<?, ?>)this.m_props);
        return this.m_props;
    }

    public SAMv3Handler getHandler() {
        return this.m_handler;
    }

    public synchronized ThreadGroup getThreadGroup() {
        return this.m_threadgroup;
    }

    public synchronized void createThreadGroup(String name) {
        if (this.m_threadgroup == null) {
            this.m_threadgroup = new ThreadGroup(name);
        }
    }
}

