/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.util.Objects;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.type.TypeHierarchy;

class ConstructedItemType
extends ItemType {
    private final Configuration config;

    protected ConstructedItemType(net.sf.saxon.type.ItemType underlyingType, Configuration config) {
        super(underlyingType);
        Objects.requireNonNull(config);
        Objects.requireNonNull(underlyingType);
        this.config = config;
    }

    @Override
    public ConversionRules getConversionRules() {
        return this.config.getConversionRules();
    }

    @Override
    public boolean matches(XdmItem item) {
        TypeHierarchy th = this.config.getTypeHierarchy();
        return this.underlyingType.matches(item.getUnderlyingValue(), th);
    }

    @Override
    public boolean subsumes(ItemType other) {
        TypeHierarchy th = this.config.getTypeHierarchy();
        return th.isSubType(other.getUnderlyingItemType(), this.underlyingType);
    }

    @Override
    public net.sf.saxon.type.ItemType getUnderlyingItemType() {
        return this.underlyingType;
    }

    protected Configuration getConfiguration() {
        return this.config;
    }
}

