untrusted comment: signature from openbsd 6.2 base secret key
RWRVWzAMgtyg7n1TV+GdjqX6KJGYXyKwMscorv7kp+AQkbCgSs/+ZIP6A1QHtMlI2E9uFWvzEeL4MeYsbRviLXvQ6T2ELgUV9gU=

OpenBSD 6.2 errata 004, Jan 15, 2018:

An incorrect TLS extensions block is generated when no extensions are present,
which can result in handshake failures.

Apply by doing:
    signify -Vep /etc/signify/openbsd-62-base.pub -x 004_libssl.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install libssl:
	cd /usr/src/lib/libssl
	make obj
	make depend
	make
	make install

Index: lib/libssl/bs_cbb.c
===================================================================
RCS file: /cvs/src/lib/libssl/bs_cbb.c,v
retrieving revision 1.17
retrieving revision 1.17.4.1
diff -u -p -r1.17 -r1.17.4.1
--- lib/libssl/bs_cbb.c	12 Aug 2017 02:50:05 -0000	1.17
+++ lib/libssl/bs_cbb.c	9 Dec 2017 13:43:25 -0000	1.17.4.1
@@ -271,6 +271,20 @@ CBB_flush(CBB *cbb)
 	return 1;
 }
 
+void
+CBB_discard_child(CBB *cbb)
+{
+	if (cbb->child == NULL)
+		return;
+
+	cbb->base->len = cbb->offset;
+	
+	cbb->child->base = NULL;
+	cbb->child = NULL;
+	cbb->pending_len_len = 0;
+	cbb->pending_is_asn1 = 0;
+	cbb->offset = 0;
+}
 
 static int
 cbb_add_length_prefixed(CBB *cbb, CBB *out_contents, size_t len_len)
Index: lib/libssl/bytestring.h
===================================================================
RCS file: /cvs/src/lib/libssl/bytestring.h,v
retrieving revision 1.15
retrieving revision 1.15.6.1
diff -u -p -r1.15 -r1.15.6.1
--- lib/libssl/bytestring.h	4 Nov 2016 18:28:58 -0000	1.15
+++ lib/libssl/bytestring.h	9 Dec 2017 13:43:25 -0000	1.15.6.1
@@ -392,6 +392,12 @@ int CBB_finish(CBB *cbb, uint8_t **out_d
  * on error.
  */
 int CBB_flush(CBB *cbb);
+
+/*
+ * CBB_discard_child discards the current unflushed child of |cbb|. Neither the
+ * child's contents nor the length prefix will be included in the output.
+ */
+void CBB_discard_child(CBB *cbb);
 
 /*
  * CBB_add_u8_length_prefixed sets |*out_contents| to a new child of |cbb|. The
Index: lib/libssl/ssl_tlsext.c
===================================================================
RCS file: /cvs/src/lib/libssl/ssl_tlsext.c,v
retrieving revision 1.17
retrieving revision 1.17.4.1
diff -u -p -r1.17 -r1.17.4.1
--- lib/libssl/ssl_tlsext.c	25 Sep 2017 18:02:27 -0000	1.17
+++ lib/libssl/ssl_tlsext.c	9 Dec 2017 13:43:25 -0000	1.17.4.1
@@ -1296,6 +1296,7 @@ tlsext_clienthello_build(SSL *s, CBB *cb
 {
 	CBB extensions, extension_data;
 	struct tls_extension *tlsext;
+	int extensions_present = 0;
 	size_t i;
 
 	if (!CBB_add_u16_length_prefixed(cbb, &extensions))
@@ -1313,8 +1314,13 @@ tlsext_clienthello_build(SSL *s, CBB *cb
 			return 0;
 		if (!tls_extensions[i].clienthello_build(s, &extension_data))
 			return 0;
+
+		extensions_present = 1;
 	}
 
+	if (!extensions_present)
+		CBB_discard_child(cbb);
+
 	if (!CBB_flush(cbb))
 		return 0;
 
@@ -1351,6 +1357,7 @@ tlsext_serverhello_build(SSL *s, CBB *cb
 {
 	CBB extensions, extension_data;
 	struct tls_extension *tlsext;
+	int extensions_present = 0;
 	size_t i;
 
 	if (!CBB_add_u16_length_prefixed(cbb, &extensions))
@@ -1368,7 +1375,12 @@ tlsext_serverhello_build(SSL *s, CBB *cb
 			return 0;
 		if (!tlsext->serverhello_build(s, &extension_data))
 			return 0;
+
+		extensions_present = 1;
 	}
+
+	if (!extensions_present)
+		CBB_discard_child(cbb);
 
 	if (!CBB_flush(cbb))
 		return 0;
