untrusted comment: signature from openbsd 6.2 base secret key
RWRVWzAMgtyg7lMsPPbcYl2vMYNdpJMTmFEMCMuox1ur8Arc3LSJFV29d0b1qTg4xz4uFbs8UuvbQ8OeDhyNjeRvFdL/xX48JgA=

OpenBSD 6.2 errata 002, December 1st, 2017:

The fktrace(2) system call had insufficient security checks.
This patch disables fktrace(2).

Apply by doing:
    signify -Vep /etc/signify/openbsd-62-base.pub -x 002_fktrace.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/kern/kern_ktrace.c
===================================================================
RCS file: /cvs/src/sys/kern/kern_ktrace.c,v
retrieving revision 1.92
diff -u -p -r1.92 kern_ktrace.c
--- sys/kern/kern_ktrace.c	12 Aug 2017 00:03:10 -0000	1.92
+++ sys/kern/kern_ktrace.c	29 Nov 2017 22:32:01 -0000
@@ -525,31 +525,7 @@ sys_ktrace(struct proc *p, void *v, regi
 int
 sys_fktrace(struct proc *p, void *v, register_t *retval)
 {
-	struct sys_fktrace_args /* {
-		syscallarg(int) fd;
-		syscallarg(int) ops;
-		syscallarg(int) facs;
-		syscallarg(pid_t) pid;
-	} */ *uap = v;
-	struct vnode *vp = NULL;
-	int fd = SCARG(uap, fd);
-	struct file *fp;
-	int error;
-
-	if (fd != -1) {
-		if ((error = getvnode(p, fd, &fp)) != 0)
-			return error;
-		vp = fp->f_data;
-		vref(vp);
-		FRELE(fp, p);
-	}
-
-	error = doktrace(vp, SCARG(uap, ops), SCARG(uap, facs),
-	    SCARG(uap, pid), p);
-	if (vp != NULL)
-		vrele(vp);
-	
-	return error;
+	return ENOSYS;
 }
 
 int
