/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SrtpExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SrtpExtensionParser
extends ExtensionParser<SrtpExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SrtpExtensionParser(int startposition, byte[] array) {
        super(startposition, array);
    }

    @Override
    public void parseExtensionMessageContent(SrtpExtensionMessage msg) {
        msg.setSrtpProtectionProfilesLength(this.parseIntField(2));
        LOGGER.debug("Parsed the srtp protection profiles length of " + msg.getSrtpProtectionProfilesLength().getValue());
        msg.setSrtpProtectionProfiles(this.parseByteArrayField((Integer)msg.getSrtpProtectionProfilesLength().getValue()));
        LOGGER.debug("Parsed the srtp protection profiles " + ArrayConverter.bytesToHexString((ModifiableByteArray)msg.getSrtpProtectionProfiles()));
        msg.setSrtpMkiLength(this.parseIntField(1));
        LOGGER.debug("Parsed the srtp mki length of " + msg.getSrtpMkiLength().getValue());
        if ((Integer)msg.getSrtpMkiLength().getValue() != 0) {
            msg.setSrtpMki(this.parseByteArrayField((Integer)msg.getSrtpMkiLength().getValue()));
            LOGGER.debug("Parsed the srtp mki " + ArrayConverter.bytesToHexString((ModifiableByteArray)msg.getSrtpMki()));
        } else {
            LOGGER.debug("Parsed no srtp mki");
            msg.setSrtpMki(new byte[0]);
        }
    }

    @Override
    protected SrtpExtensionMessage createExtensionMessage() {
        return new SrtpExtensionMessage();
    }
}

