<?php

/**
 * ⚠️ Editing not allowed except for 'en' language.
 *
 * @see https://github.com/monicahq/monica/blob/main/docs/contribute/translate.md for translations.
 */

return [

    //index
    'people_not_found' => 'Contact non trouvé',
    'people_list_number_kids' => ':count enfant|:count enfants',
    'people_list_last_updated' => 'Dernière consultation :',
    'people_list_number_reminders' => ':count rappel|:count rappels',
    'people_list_blank_title' => 'Vous n’avez encore ajouté aucun contact',
    'people_list_blank_cta' => 'Ajouter quelqu’un',
    'people_list_sort' => 'Tri',
    'people_list_stats' => ':count contact|:count contacts',
    'people_list_firstnameAZ' => 'Tri par prénom A → Z',
    'people_list_firstnameZA' => 'Tri par prénom Z → A',
    'people_list_lastnameAZ' => 'Tri par nom de famille A → Z',
    'people_list_lastnameZA' => 'Tri par nom de famille Z → A',
    'people_list_lastactivitydateNewtoOld' => 'Trier par date de dernière activité, du plus récent au plus ancien',
    'people_list_lastactivitydateOldtoNew' => 'Trier par date de dernière activité, du plus ancien au plus récent',
    'people_list_filter_tag' => 'Affichage des contacts avec l’étiquette',
    'people_list_clear_filter' => 'Enlever le filtre',
    'people_list_contacts_per_tags' => ':count contact|:count contacts',
    'people_list_show_dead' => 'Afficher les contacts décédés (:count)',
    'people_list_hide_dead' => 'Masquer les contacts décédés (:count)',
    'people_search' => 'Recherchez dans vos contacts…',
    'people_search_no_results' => 'Aucun résultat',
    'people_search_next' => 'Suivant',
    'people_search_prev' => 'Précédent',
    'people_search_rows_per_page' => 'Résultats par page',
    'people_search_of' => 'sur',
    'people_search_page' => 'Page',
    'people_search_all' => 'Tous',
    'people_add_new' => 'Ajouter une nouvelle personne',
    'people_list_account_usage' => 'Votre utilisation de compte : :current/:limit contacts',
    'people_list_account_upgrade_title' => 'Passez au plan supérieur pour débloquer votre compte et l’amener à son plein potentiel.',
    'people_list_account_upgrade_cta' => 'Passez au plan supérieur',
    'people_list_untagged' => 'Afficher les contacts sans étiquette',
    'people_list_filter_untag' => 'Afficher les contacts sans aucune étiquette',
    'archived_contact_readonly' => 'Un contact archivé ne peut pas être modifié, veuillez d’abord le désarchiver.',

    // people add
    'people_add_title' => 'Ajouter une nouvelle personne',
    'people_add_missing' => 'Aucune personne trouvée – ajouter une nouvelle personne maintenant',
    'people_add_firstname' => 'Prénom',
    'people_add_middlename' => 'Deuxième prénom (optionnel)',
    'people_add_lastname' => 'Nom de famille (optionnel)',
    'people_add_email' => 'Courriel (optionnel)',
    'people_add_nickname' => 'Surnom (optionnel)',
    'people_add_cta' => 'Ajouter',
    'people_save_and_add_another_cta' => 'Sauver et ajouter un autre contact',
    'people_add_success' => ':name a été crée avec succès',
    'people_add_gender' => 'Genre',
    'people_delete_success' => 'Le contact a été supprimé',
    'people_delete_message' => 'Supprimer le contact',
    'people_delete_confirmation' => 'Êtes-vous sûr⋅e de vouloir supprimer le contact de :name ? La suppression est immédiate et permanente.',
    'people_add_birthday_reminder' => 'Souhaiter un bon anniversaire à :name',
    'people_add_birthday_reminder_deceased' => 'À cette date, :name aurait célébré son anniversaire',
    'people_add_import' => 'Souhaitez-vous <a href=":url">importer vos contacts</a> ?',
    'people_edit_email_error' => 'Il y a déjà quelqu’un dans votre compte avec cette adresse courriel. Merci d’en choisir une autre.',
    'people_export' => 'Exporter en tant que vCard',
    'people_add_reminder_for_birthday' => 'Créer un rappel annuel d’anniversaire',

    // show
    'section_contact_information' => 'Coordonnées',
    'section_personal_activities' => 'Activités',
    'section_personal_reminders' => 'Rappels',
    'section_personal_tasks' => 'Tâches',
    'section_personal_gifts' => 'Cadeaux',
    'section_personal_notes' => 'Notes',

    // archived contacts
    'list_link_to_active_contacts' => 'Vous visualisez les contacts archivés. Afficher la <a href=":url">liste des contacts actifs</a> à la place.',
    'list_link_to_archived_contacts' => 'Liste de contacts archivés',

    // Header
    'me' => 'C’est vous',
    'edit_contact_information' => 'Mettre à jour les coordonnées',
    'contact_archive' => 'Archiver le contact',
    'contact_unarchive' => 'Désarchiver le contact',
    'contact_archive_help' => 'Les contacts archivés n’apparaîtront pas sur la liste de contacts, mais apparaîtront toujours dans les résultats de recherches.',
    'call_button' => 'Enregistrer un appel téléphonique',
    'set_favorite' => 'Les contacts favoris sont placés en haut de la liste des contacts',

    // Stay in touch
    'stay_in_touch' => 'Restez en contact',
    'stay_in_touch_frequency' => 'Rester en contact chaque jour|Rester en contact chaque jour|Rester en contact tous les {count} jours',
    'stay_in_touch_next_date' => 'Prochaine échéance : {date}',
    'stay_in_touch_invalid' => 'La fréquence doit être un nombre supérieur à 0.',
    'stay_in_touch_premium' => 'Vous devez mettre à jour votre compte pour pouvoir profiter de cette fonctionnalité',
    'stay_in_touch_modal_title' => 'Restez en contact',
    'stay_in_touch_modal_desc' => 'Nous pouvons vous rappeler par courriel pour rester en contact avec {firstname} à intervalle régulier.',
    'stay_in_touch_modal_label' => 'Envoyez-moi un courriel tous les… {count} jour|Envoyez-moi un courriel tous les… {count} jours',

    // Calls
    'modal_call_title' => 'Enregistrer un appel téléphonique',
    'modal_call_comment' => 'De quoi avez-vous parlé ? (optionnel)',
    'modal_call_exact_date' => 'L’appel s’est passé le',
    'modal_call_who_called' => 'Qui a appelé ?',
    'modal_call_emotion' => 'Voulez vous enregistrer ce que vous avez ressenti au cours de cet appel ? (optionnel)',
    'calls_add_success' => 'L’appel téléphonique a été enregistré.',
    'call_delete_confirmation' => 'Êtes-vous sûr de vouloir supprimer cet appel ?',
    'call_delete_success' => 'L’appel a été supprimé avec succès',
    'call_title' => 'Appels téléphoniques',
    'call_empty_comment' => 'Aucun details',
    'call_blank_title' => 'Gardez la trace des appels téléphoniques que vous avez fait avec {name}',
    'call_blank_desc' => 'Vous avez appelé {name}',
    'call_you_called' => 'Vous avez appelé',
    'call_he_called' => '{name} a appelé',
    'call_emotions' => 'Émotions :',

    // Conversation
    'conversation_blank' => 'Enregistrer les discussions que vous avez avec :name sur les réseaux sociaux, par SMS, etc.',
    'conversation_delete_link' => 'Supprimer la discussion',
    'conversation_edit_title' => 'Éditer la discussion',
    'conversation_edit_delete' => 'Êtes-vous sûr de vouloir supprimer la discussion ? La suppression est permanente.',
    'conversation_add_success' => 'La discussion a été ajoutée avec succès.',
    'conversation_edit_success' => 'La discussion a été mise à jour avec succès.',
    'conversation_delete_success' => 'La discussion a été supprimée avec succès.',
    'conversation_add_title' => 'Enregistrer une discussion',
    'conversation_add_when' => 'Quand avez-vous eu cette discussion ?',
    'conversation_add_who_wrote' => 'Qui a écrit ce message ?',
    'conversation_add_how' => 'Comment avez-vous communiqué ?',
    'conversation_add_you' => 'Vous',
    'conversation_add_content' => 'Écrivez ce que vous avez dit',
    'conversation_add_what_was_said' => 'Qu’avez-vous dit ?',
    'conversation_add_another' => 'Ajoutez un nouveau message',
    'conversation_add_error' => 'Vous devez ajouter au moins un message.',
    'conversation_list_table_messages' => 'Messages',
    'conversation_list_table_content' => 'Contenu partiel (dernier message)',
    'conversation_list_title' => 'Discussions',
    'conversation_list_cta' => 'Journal de conversation',

    // age - birthday
    'birthdate_not_set' => 'La date de naissance n’est pas définie',
    'age_approximate_in_years' => 'env. :age ans',
    'age_exact_in_years' => ':age ans',
    'age_exact_birthdate' => 'né le :date',

    // Last called
    'last_called' => 'Dernier appel : :date',
    'last_talked_to' => 'Dernier appel : {date}',
    'last_called_empty' => 'Dernier appel : inconnu',
    'last_activity_date' => 'Dernière activité ensemble : :date',
    'last_activity_date_empty' => 'Dernière activité ensemble : inconnu',

    // additional information
    'information_edit_success' => 'Le profil a été mis à jour avec succès',
    'information_edit_title' => 'Mettre à jour les informations personnelles de :name',
    'information_edit_max_size' => 'Maximum :size Ko.',
    'information_edit_max_size2' => 'Maximum {size} Ko.',
    'information_edit_firstname' => 'Prénom',
    'information_edit_lastname' => 'Nom de famille (optionnel)',
    'information_edit_description' => 'Description (optionnel)',
    'information_edit_description_help' => 'Utilisé sur la liste de contacts pour ajouter un contexte, si nécessaire.',
    'information_edit_unknown' => 'Je ne connais pas son âge',
    'information_edit_probably' => 'Cette personne a probablement…',
    'information_edit_not_year' => 'Je connais le jour et le mois de l’anniversaire de cette personne, mais pas l\'année…',
    'information_edit_exact' => 'Je connais la date d’anniversaire exacte de cette personne…',
    'information_edit_birthdate_label' => 'Date d’anniversaire',
    'information_no_work_defined' => 'Aucune information professionnelle définie',
    'information_work_at' => 'chez :company',
    'work_add_cta' => 'Mettre à jour les informations professionnelles',
    'work_edit_success' => 'Informations professionnelles mises à jour',
    'work_edit_title' => 'Mettre à jour les informations professionnelles de :name',
    'work_edit_job' => 'Poste (optionnel)',
    'work_edit_company' => 'Entreprise (optionnel)',
    'work_information' => 'Information sur le travail',

    // food preferences
    'food_preferences_add_success' => 'Les préférences alimentaires ont été mises à jour.',
    'food_preferences_edit_description' => 'Peut-être que :firstname ou quelqu’un dans la famille :family a une allergie. Ou peut-être qu’il n’aime pas un vin spécifique. Indiquez ici ses préférences alimentaires afin que vous vous en rappeliez la prochaine fois que vous l’inviterez à dîner',
    'food_preferences_edit_description_no_last_name' => 'Peut-être que :firstname a une allergie. Ou peut-être qu’il n’aime pas un vin spécifique. Indiquez ici ses préférences alimentaires afin que vous vous en rappeliez la prochaine fois que vous l’inviterez à dîner',
    'food_preferences_edit_title' => 'Modification des préférences alimentaires',
    'food_preferences_edit_cta' => 'Enregistrer les préférences alimentaires',
    'food_preferences_title' => 'Préférences alimentaires',
    'food_preferences_cta' => 'Ajouter des préférences alimentaires',

    // reminders
    'reminders_blank_title' => 'De quoi souhaitez-vous être rappelé à propos de :name ?',
    'reminders_blank_add_activity' => 'Ajouter un rappel',
    'reminders_add_title' => 'De quoi souhaitez-vous être rappelé à propos de :name ?',
    'reminders_add_description' => 'Merci de me tenir informé de…',
    'reminders_add_next_time' => 'Quand voulez-vous être rappelé à propos de ceci ?',
    'reminders_add_once' => 'Rappelez-moi juste une fois',
    'reminders_add_recurrent' => 'Rappelez-moi tous les',
    'reminders_add_starting_from' => 'à compter de la date définie ci-après',
    'reminders_add_cta' => 'Ajouter le rappel',
    'reminders_edit_update_cta' => 'Mettre à jour le rappel',
    'reminders_add_error_custom_text' => 'Vous devez indiquer un texte pour ce rappel.',
    'reminders_create_success' => 'Le rappel a été ajouté avec succès.',
    'reminders_delete_success' => 'Le rappel a été supprimé avec succès.',
    'reminders_update_success' => 'Le rappel a été mis à jour avec succès',
    'reminders_add_optional_comment' => 'Commentaire (optionnel)',

    'reminder_frequency_day' => 'chaque jour|chaque :number jours',
    'reminder_frequency_week' => 'chaque semaine|chaque :number semaines',
    'reminder_frequency_month' => 'chaque mois|chaque :number mois',
    'reminder_frequency_year' => 'chaque année|chaque :number années',
    'reminder_frequency_one_time' => 'le :date',
    'reminders_delete_confirmation' => 'Êtes-vous sûr de vouloir supprimer ce rappel ?',
    'reminders_delete_cta' => 'Supprimer',
    'reminders_next_expected_date' => 'le',
    'reminders_cta' => 'Ajouter un rappel',
    'reminders_description' => 'Nous vous enverrons un courriel pour chacun des rappels ci-dessous. Les rappels sont envoyés le matin du jour où l’événement se passe. Les rappels ajoutés automatiquement pour les anniversaires ne peuvent pas être effacés. Si vous désirez changer ces derniers, modifiez la date d’anniversaire de ces contacts.',
    'reminders_one_time' => 'Unique',
    'reminders_type_week' => 'semaine',
    'reminders_type_month' => 'mois',
    'reminders_type_year' => 'année',
    'reminders_birthday' => 'Anniversaire de :name',
    'reminders_free_plan_warning' => 'Vous êtes sur le plan gratuit. Aucun courriel ne sera envoyé avec ce plan. Pour recevoir vos rappels par courriel, passez au plan supérieur.',

    // relationships
    'relationship_form_add' => 'Ajouter une relation',
    'relationship_form_edit' => 'Modifier une relation existante',
    'relationship_form_is_with' => 'Cette personne est…',
    'relationship_form_is_with_name' => ':name est…',
    'relationship_form_add_choice' => 'Quelle est cette relation ?',
    'relationship_form_create_contact' => 'Ajouter une nouvelle personne',
    'relationship_form_associate_contact' => 'Un contact existant',
    'relationship_form_associate_dropdown' => 'Recherchez et sélectionnez un contact existant dans la liste déroulante ci-dessous',
    'relationship_form_associate_dropdown_placeholder' => 'Recherchez et sélectionnez un contact existant',
    'relationship_form_also_create_contact' => 'Créer un contact pour cette personne.',
    'relationship_form_add_description' => 'Ceci vous permettra de traiter cette personne comme tous les autres contacts de votre compte.',
    'relationship_form_add_no_existing_contact' => 'Vous n’avez aucun contact qui puisse être associé à :name pour le moment.',
    'relationship_delete_confirmation' => 'Êtes-vous sûr de vouloir supprimer cette relation ? La suppression est permanente.',
    'relationship_unlink_confirmation' => 'Êtes-vous sûr de vouloir supprimer cette relation ? La personne ne sera pas supprimée – seulement la relation entre les deux.',
    'relationship_form_add_success' => 'La relation a été créée avec succès.',
    'relationship_form_deletion_success' => 'La relation a été supprimée.',

    // tasks
    'tasks_title' => 'Tâches',
    'tasks_blank_title' => 'Vous n’avez aucune tâche pour le moment.',
    'tasks_form_title' => 'Titre',
    'tasks_form_description' => 'Description (optionnel)',
    'tasks_add_task' => 'Ajouter une tâche',
    'tasks_delete_success' => 'La tâche a été supprimée avec succès.',
    'tasks_complete_success' => 'La tâche a été mise à jour avec succès',

    // activities
    'activity_title' => 'Activités',
    'activity_type_category_simple_activities' => 'Activités simples',
    'activity_type_category_sport' => 'Sport',
    'activity_type_category_food' => 'Gastronomie',
    'activity_type_category_cultural_activities' => 'Activités culturelles',
    'activity_type_just_hung_out' => 'traîner ensemble',
    'activity_type_watched_movie_at_home' => 'regarder un film à la maison ensemble',
    'activity_type_talked_at_home' => 'parler ensemble à la maison',
    'activity_type_did_sport_activities_together' => 'fait du sport ensemble',
    'activity_type_ate_at_his_place' => 'mangé chez lui·elle',
    'activity_type_went_bar' => 'aller dans un bar',
    'activity_type_ate_at_home' => 'manger à la maison',
    'activity_type_picnicked' => 'pique-niqué',
    'activity_type_ate_restaurant' => 'aller au restaurant',
    'activity_type_went_theater' => 'aller au cinéma',
    'activity_type_went_concert' => 'aller à un concert',
    'activity_type_went_play' => 'aller au théâtre',
    'activity_type_went_museum' => 'aller au musée',
    'activities_add_activity' => 'Ajouter une activité',
    'activities_add_more_details' => 'Ajouter plus de détails',
    'activities_add_emotions' => 'Ajouter une émotion',
    'activities_add_category' => 'Indiquer une catégorie',
    'activities_add_participants_cta' => 'Ajouter des participants',
    'activities_item_information' => ':Activity. S’est passée le :date',
    'activities_add_title' => 'Qu’avez-vous fait avec {name} ?',
    'activities_summary' => 'Décrivez ce que vous avez fait',
    'activities_add_pick_activity' => 'Souhaitez-vous catégoriser cette activité ? Vous n’avez pas à le faire, mais cela nous permettra de faire des statistiques plus tard (optionnel)',
    'activities_add_date_occured' => 'Cette activité s\'est produite le…',
    'activities_add_participants' => 'Qui, à part {name}, a participé à l’activité ? (optionnel)',
    'activities_add_emotions_title' => 'Voulez vous enregistrer ce que vous avez ressenti au cours de cette activité ? (optionnel)',
    'activities_blank_title' => 'Gardez une trace de ce que vous avez fait avec {name} dans le passé, et de ce dont vous avez parlé',
    'activities_blank_add_activity' => 'Ajouter une activité',
    'activities_add_success' => 'L’activité a été ajoutée avec succès',
    'activities_add_error' => 'Erreur lors de l’ajout de l’activité',
    'activities_update_success' => 'L’activité a été mise à jour avec succès',
    'activities_delete_success' => 'L’activité a été supprimée avec succès',
    'activities_who_was_involved' => 'Qui était impliqué ?',
    'activities_activity' => 'Catégorie d’activité',
    'activities_view_activities_report' => 'Afficher les rapports d’activités',
    'activities_profile_title' => 'Rapports d’activités entre :name et vous',
    'activities_profile_subtitle' => 'Vous avez enregistré :total_activities activité avec :name au total et :activities_last_twelve_months au cours des 12 derniers mois.|Vous avez enregistré :total_activities activités avec :name au total et :activities_last_twelve_months au cours des 12 derniers mois.',
    'activities_profile_year_summary_activity_types' => 'Voici un aperçu du type d\'activités que vous avez réalisées ensemble en :year',
    'activities_profile_year_summary' => 'Voici ce que vous avez fait ensemble en :year',
    'activities_profile_number_occurences' => ':value activité|:value activités',
    'activities_list_participants' => 'Participants ({total}) :',
    'activities_list_emotions' => 'Émotions ressenties :',
    'activities_list_date' => 'Arrivé le',
    'activities_list_category' => 'Catégorie :',

    // notes
    'notes_create_success' => 'La note a été ajoutée avec succès',
    'notes_update_success' => 'La note a été modifiée avec succès',
    'notes_delete_success' => 'La note a été supprimée avec succès',
    'notes_add_cta' => 'Ajouter une note',
    'notes_favorite' => 'Ajouter/retirer des favoris',
    'notes_delete_title' => 'Supprimer une note',
    'notes_delete_confirmation' => 'Êtes-vous sûr de vouloir supprimer cette note ? La suppression est permanente',

    // gifts
    'gifts_title' => 'Cadeaux',
    'gifts_add_success' => 'Le cadeau a été ajouté avec succès',
    'gifts_delete_success' => 'Le cadeau a été supprimé',
    'gifts_delete_confirmation' => 'Etes-vous sûr de vouloir supprimer ce cadeau ?',
    'gifts_add_gift' => 'Ajouter un cadeau',
    'gifts_link' => 'Lien',
    'gifts_for' => 'Pour : {name}',
    'gifts_delete_cta' => 'Supprimer',
    'gifts_add_title' => 'Gestion des cadeaux pour :name',
    'gifts_add_gift_idea' => 'Idée de cadeau',
    'gifts_add_gift_already_offered' => 'Cadeau déjà offert',
    'gifts_add_gift_received' => 'Cadeau reçu',
    'gifts_add_gift_title' => 'Quel est ce cadeau ?',
    'gifts_add_gift_name' => 'Cadeau',
    'gifts_add_link' => 'Lien de la page web (optionnel)',
    'gifts_add_value' => 'Valeur (optionnel)',
    'gifts_add_comment' => 'Commentaire (optionnel)',
    'gifts_add_recipient' => 'Destinataire (optionnel)',
    'gifts_add_recipient_field' => 'Destinataire',
    'gifts_add_photo' => 'Photo (optionnelle)',
    'gifts_add_photo_title' => 'Ajouter une photo pour ce cadeau',
    'gifts_add_someone' => 'Ce cadeau est destiné à quelqu’un de la famille de {name} en particulier',
    'gifts_delete_title' => 'Supprimer un cadeau',
    'gifts_ideas' => 'Idées cadeaux',
    'gifts_offered' => 'Cadeaux déjà offerts',
    'gifts_offered_as_an_idea' => 'Marquer comme idée',
    'gifts_received' => 'Cadeaux reçus',
    'gifts_view_comment' => 'Voir commentaire',
    'gifts_mark_offered' => 'Marquer comme offert',
    'gifts_update_success' => 'Le cadeau a été mis à jour avec succès',
    'gifts_add_date' => 'Date (facultatif)',

    // debts
    'debt_delete_confirmation' => 'Êtes-vous sûr de vouloir effacer cette dette ?',
    'debt_delete_success' => 'La dette a été effacée avec succès',
    'debt_add_success' => 'La dette a été ajoutée avec succès',
    'debt_title' => 'Dettes',
    'debt_add_cta' => 'Ajouter une dette',
    'debt_you_owe' => 'Vous devez :amount',
    'debt_they_owe' => ':name vous doit :amount',
    'debt_add_title' => 'Gestion des dettes',
    'debt_add_you_owe' => 'Vous devez à :name',
    'debt_add_they_owe' => ':name vous doit',
    'debt_add_amount' => 'la somme de',
    'debt_add_reason' => 'pour la raison suivante (optionnelle)',
    'debt_add_add_cta' => 'Ajouter la dette',
    'debt_edit_update_cta' => 'Mettre à jour la dette',
    'debt_edit_success' => 'La dette a été modifiée avec succès',
    'debts_blank_title' => 'Gérez les dettes que vous devez à :name ou que :name vous doit',

    // tags
    'tag_edit' => 'Modifier le tag',
    'tag_add' => 'Ajouter des étiquettes',
    'tag_add_search' => 'Ajouter ou rechercher une étiquette',
    'tag_no_tags' => 'Aucune étiquette',

    // Introductions
    'introductions_sidebar_title' => 'Comment vous vous êtes rencontré',
    'introductions_blank_cta' => 'Indiquez comment vous avez rencontré :name',
    'introductions_title_edit' => 'Comment avez-vous rencontré :name ?',
    'introductions_additional_info' => 'Expliquez quand et comment vous vous êtes rencontrés',
    'introductions_edit_met_through' => 'Est-ce que quelqu’un vous a introduit à cette personne ?',
    'introductions_no_met_through' => 'Personne',
    'introductions_first_met_date' => 'Date de la rencontre',
    'introductions_no_first_met_date' => 'Je ne connais pas la date de cette rencontre',
    'introductions_first_met_date_known' => 'Voici la date de notre rencontre',
    'introductions_add_reminder' => 'Ajouter un rappel pour célébrer la rencontre à la date anniversaire, rappelant chaque année quand cet évènement s’est passé',
    'introductions_update_success' => 'Vous avez mis à jour avec succès vos informations de rencontre',
    'introductions_met_through' => 'Rencontré·e via <a href=":url">:name</a>',
    'introductions_met_date' => 'Rencontré le :date',
    'introductions_reminder_title' => 'Anniversaire de la date de la première rencontre',

    // Deceased
    'deceased_reminder_title' => 'Anniversaire de la mort de :name',
    'deceased_mark_person_deceased' => 'Indiquer cette personne comme décédée',
    'deceased_know_date' => 'Je connais la date de décès de cette personne',
    'deceased_add_reminder' => 'Ajouter un rappel pour cette date',
    'deceased_label' => 'Décédé',
    'deceased_date_label' => 'Date de décès',
    'deceased_label_with_date' => 'Décédé le :date',
    'deceased_age' => 'Age au moment du décès',

    // Contact information
    'contact_info_title' => 'Coordonnées',
    'contact_info_form_content' => 'Contenu',
    'contact_info_form_contact_type' => 'Type de contact',
    'contact_info_form_personalize' => 'Personaliser',
    'contact_info_address' => 'Habite à',

    // Addresses
    'contact_address_title' => 'Adresses',
    'contact_address_form_name' => 'Nom (optionnel)',
    'contact_address_form_street' => 'Rue et numéro (optionnel)',
    'contact_address_form_city' => 'Ville (optionnel)',
    'contact_address_form_province' => 'Province (optionnel)',
    'contact_address_form_postal_code' => 'Code postal (optionnel)',
    'contact_address_form_country' => 'Pays (optionnel)',
    'contact_address_form_latitude' => 'Latitude (chiffres uniquement) (optionnel)',
    'contact_address_form_longitude' => 'Longitude (chiffres uniquement) (optionnel)',

    // Pets
    'pets_kind' => 'Sorte d’animal',
    'pets_name' => 'Nom (optionnel)',
    'pets_create_success' => 'L’animal a été ajouté avec succès',
    'pets_update_success' => 'L’animal a été mis à jour',
    'pets_delete_success' => 'L’animal a été supprimé',
    'pets_title' => 'Animaux de compagnie',
    'pets_reptile' => 'Reptile',
    'pets_bird' => 'Oiseau',
    'pets_cat' => 'Chat',
    'pets_dog' => 'Chien',
    'pets_fish' => 'Poisson',
    'pets_hamster' => 'Hamster',
    'pets_horse' => 'Cheval',
    'pets_rabbit' => 'Lapin',
    'pets_rat' => 'Rat',
    'pets_small_animal' => 'Petit animal',
    'pets_other' => 'Autre',

    // life events
    'life_event_list_tab_life_events' => 'Évènements marquants',
    'life_event_list_tab_other' => 'Notes, rappels…',
    'life_event_list_title' => 'Évènements marquants',
    'life_event_blank' => 'Prenez des notes sur ce qui arrive dans la vie de {name} pour votre référence future.',
    'life_event_list_cta' => 'Ajouter un évènement marquant',
    'life_event_create_category' => 'Toutes les catégories',
    'life_event_create_life_event' => 'Ajouter l’évènement marquant',
    'life_event_create_default_title' => 'Titre (optionnel)',
    'life_event_create_default_story' => 'Histoire (optionnel)',
    'life_event_create_date' => 'Vous n’avez pas à renseigner le mois ou le jour – seule l’année est obligatoire.',
    'life_event_create_default_description' => 'Ajouter des informations sur ce que vous savez',
    'life_event_create_add_yearly_reminder' => 'Ajouter un rappel annuel pour cet évènement',
    'life_event_create_success' => 'L’évènement a été sauvegardé',
    'life_event_delete_title' => 'Supprimer l’évènement',
    'life_event_delete_description' => 'Êtes-vous sûr de vouloir supprimer cet évènement marquant ? La suppression est permanente.',
    'life_event_delete_success' => 'L’évènement marquant a été supprimé',
    'life_event_date_it_happened' => 'Date de l’évènement',
    'life_event_category_work_education' => 'Travail & formation',
    'life_event_category_family_relationships' => 'Famille & relations',
    'life_event_category_home_living' => 'Foyer & vie domestique',
    'life_event_category_health_wellness' => 'Santé & bien-être',
    'life_event_category_travel_experiences' => 'Voyages & expériences',
    'life_event_sentence_new_job' => 'A commencé un nouveau travail',
    'life_event_sentence_retirement' => 'A pris sa retraite',
    'life_event_sentence_new_school' => 'A commencé l’école',
    'life_event_sentence_study_abroad' => 'A étudier à l’étranger',
    'life_event_sentence_volunteer_work' => 'A commencé à faire du bénévolat',
    'life_event_sentence_published_book_or_paper' => 'A publié un document',
    'life_event_sentence_military_service' => 'A démarré le service militaire',
    'life_event_sentence_new_relationship' => 'A commencé une relation',
    'life_event_sentence_engagement' => 'S’est fiancé',
    'life_event_sentence_marriage' => 'S’est marié',
    'life_event_sentence_anniversary' => 'Anniversaire',
    'life_event_sentence_expecting_a_baby' => 'Attend un bébé',
    'life_event_sentence_new_child' => 'A eu un enfant',
    'life_event_sentence_new_family_member' => 'Nouveau membre dans la famille',
    'life_event_sentence_new_pet' => 'A eu un animal de compagnie',
    'life_event_sentence_end_of_relationship' => 'Fin d’une relation',
    'life_event_sentence_loss_of_a_loved_one' => 'A perdu un être cher',
    'life_event_sentence_moved' => 'A déménagé',
    'life_event_sentence_bought_a_home' => 'A acheté une maison',
    'life_event_sentence_home_improvement' => 'A fait des rénovations',
    'life_event_sentence_holidays' => 'Est allé en vacances',
    'life_event_sentence_new_vehicle' => 'Acquisition dʼun nouveau véhicule',
    'life_event_sentence_new_roommate' => 'A eu un colocataire',
    'life_event_sentence_overcame_an_illness' => 'A surmonté une maladie',
    'life_event_sentence_quit_a_habit' => 'A quitté une habitude',
    'life_event_sentence_new_eating_habits' => 'A commencé de nouvelles habitudes alimentaires',
    'life_event_sentence_weight_loss' => 'A perdu du poids',
    'life_event_sentence_wear_glass_or_contact' => 'A commencé à porter des lunettes ou des lentilles de contact',
    'life_event_sentence_broken_bone' => 'S’est cassé un os',
    'life_event_sentence_removed_braces' => 'S’est fait retiré un appareil dentaire',
    'life_event_sentence_surgery' => 'A eu une chirurgie',
    'life_event_sentence_dentist' => 'Est allé chez le dentiste',
    'life_event_sentence_new_sport' => 'A commencé un sport',
    'life_event_sentence_new_hobby' => 'A commencé un passe-temps',
    'life_event_sentence_new_instrument' => 'A commencé à apprendre un nouvel instrument',
    'life_event_sentence_new_language' => 'A commencé à apprendre une nouvelle langue',
    'life_event_sentence_tattoo_or_piercing' => 'S’est fait tatoué ou percé',
    'life_event_sentence_new_license' => 'A eu le permis',
    'life_event_sentence_travel' => 'A voyagé',
    'life_event_sentence_achievement_or_award' => 'A eu une récompense ou un prix',
    'life_event_sentence_changed_beliefs' => 'A changé de croyances',
    'life_event_sentence_first_word' => 'A parlé pour la première fois',
    'life_event_sentence_first_kiss' => 'A eu son premier baiser',

    // documents
    'document_list_title' => 'Documents',
    'document_list_cta' => 'Télécharger un document',
    'document_list_blank_desc' => 'Ici vous pouvez stocker les documents reliés à cette personne.',
    'document_upload_zone_cta' => 'Télécharger un fichier',
    'document_upload_zone_progress' => 'Téléchargement du document…',
    'document_upload_zone_error' => 'Une erreur est survenue durant le téléchargement du document. Veuillez réessayer plus tard.',

    // Photos
    'photo_title' => 'Photos',
    'photo_list_title' => 'Photos associées',
    'photo_list_cta' => 'Télécharger une photo',
    'photo_list_blank_desc' => 'Vous pouvez enregistrer des images sur ce contact. Téléchargez-en une maintenant !',
    'photo_upload_zone_cta' => 'Télécharger une photo',
    'photo_current_profile_pic' => 'Photo de profil actuelle',
    'photo_make_profile_pic' => 'Utiliser comme photo de profil',
    'photo_delete' => 'Supprimer la photo',
    'photo_next' => 'Photo suivante ❯',
    'photo_previous' => '❮ Photo précédente',

    // Avatars
    'avatar_change_title' => 'Changer de photo de profil',
    'avatar_question' => 'Quelle photo de profil souhaitez-vous utiliser ?',
    'avatar_default_avatar' => 'La photo de profil par défaut',
    'avatar_adorable_avatar' => 'La photo de profil Adorable',
    'avatar_gravatar' => 'Le Gravatar associé à l’adresse courriel de cette personne. <a href="https://gravatar.com/">Gravatar</a> est un système global qui permet aux utilisateurs d’associer des adresses courriel avec des photos.',
    'avatar_current' => 'Conserver la photo de profil actuelle',
    'avatar_photo' => 'À partir d’une photo que vous téléchargez',
    'avatar_crop_new_avatar_photo' => 'Recadrer la nouvelle photo de profil',

    // emotions
    'emotion_this_made_me_feel' => 'Cela vous fait sentir …',

    // logs
    'auditlogs_link' => 'Historique',
    'auditlogs_title' => 'Tout ce qui est arrivé à :name',
    'auditlogs_breadcrumb' => 'Historique',
    'auditlogs_author' => 'Par :name le :date',

    // contact field label
    'contact_field_label_home' => 'Domicile',
    'contact_field_label_work' => 'Bureau',
    'contact_field_label_cell' => 'Portable',
    'contact_field_label_fax' => 'Fax',
    'contact_field_label_pager' => 'Bipeur',
    'contact_field_label_main' => 'Principal',
    'contact_field_label_other' => 'Autre',
    'contact_field_label_personal' => 'Personnalisé',
];
