/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.usage;

import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.usage.UseSet;
import jadx.core.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public class UsageInfo {
    private final RootNode root;
    private final UseSet<ClassNode, ClassNode> clsDeps = new UseSet();
    private final UseSet<ClassNode, ClassNode> clsUsage = new UseSet();
    private final UseSet<ClassNode, MethodNode> clsUseInMth = new UseSet();
    private final UseSet<FieldNode, MethodNode> fieldUsage = new UseSet();
    private final UseSet<MethodNode, MethodNode> mthUsage = new UseSet();

    public UsageInfo(RootNode root) {
        this.root = root;
    }

    public void apply() {
        this.clsDeps.visit((cls, deps) -> cls.setDependencies(UsageInfo.sortedList(deps)));
        this.clsUsage.visit((cls, deps) -> cls.setUseIn(UsageInfo.sortedList(deps)));
        this.clsUseInMth.visit((cls, methods) -> cls.setUseInMth(UsageInfo.sortedList(methods)));
        this.fieldUsage.visit((field, methods) -> field.setUseIn(UsageInfo.sortedList(methods)));
        this.mthUsage.visit((mth, methods) -> mth.setUseIn(UsageInfo.sortedList(methods)));
    }

    public void clsUse(ClassNode cls, ArgType useType) {
        this.processType(useType, depCls -> this.clsUse(cls, (ClassNode)depCls));
    }

    public void clsUse(MethodNode mth, ArgType useType) {
        this.processType(useType, depCls -> this.clsUse(mth, (ClassNode)depCls));
    }

    public void clsUse(MethodNode mth, ClassNode useCls) {
        ClassNode parentClass = mth.getParentClass();
        this.clsUse(parentClass, useCls);
        if (parentClass != useCls) {
            this.clsUseInMth.add(useCls, mth);
        }
    }

    public void clsUse(ClassNode cls, ClassNode depCls) {
        ClassNode topParentClass = cls.getTopParentClass();
        this.clsDeps.add(topParentClass, depCls.getTopParentClass());
        this.clsUsage.add(depCls, cls);
        this.clsUsage.add(depCls, topParentClass);
    }

    public void methodUse(MethodNode mth, MethodNode useMth) {
        this.clsUse(mth, useMth.getParentClass());
        this.mthUsage.add(useMth, mth);
        this.clsUse(mth, useMth.getReturnType());
        useMth.getMethodInfo().getArgumentsTypes().forEach(argType -> this.clsUse(mth, (ArgType)argType));
    }

    public void fieldUse(MethodNode mth, FieldNode useFld) {
        this.clsUse(mth, useFld.getParentClass());
        this.fieldUsage.add(useFld, mth);
        this.clsUse(mth, useFld.getType());
    }

    private void processType(ArgType type, Consumer<ClassNode> consumer) {
        if (type == null) {
            return;
        }
        if (type.isArray()) {
            this.processType(type.getArrayRootElement(), consumer);
            return;
        }
        if (type.isObject() && !type.isGenericType()) {
            ClassNode clsNode = this.root.resolveClass(type);
            if (clsNode != null) {
                consumer.accept(clsNode);
            }
            List<ArgType> genericTypes = type.getGenericTypes();
            if (type.isGeneric() && Utils.notEmpty(genericTypes)) {
                for (ArgType argType : genericTypes) {
                    this.processType(argType, consumer);
                }
            }
        }
    }

    private static <T extends Comparable<T>> List<T> sortedList(Set<T> deps) {
        ArrayList<T> list = new ArrayList<T>(deps);
        Collections.sort(list);
        return list;
    }
}

