/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class NoWhitespaceBeforeCheck
extends Check {
    private boolean mAllowLineBreaks = false;

    public int[] getDefaultTokens() {
        return new int[]{45, 25, 26};
    }

    public int[] getAcceptableTokens() {
        return new int[]{45, 25, 26, 59};
    }

    public void visitToken(DetailAST aAST) {
        String[] lines = this.getLines();
        String line = lines[aAST.getLineNo() - 1];
        int before = aAST.getColumnNo() - 1;
        if (before < 0 || Character.isWhitespace(line.charAt(before))) {
            boolean flag = !this.mAllowLineBreaks;
            int i = 0;
            while (!flag && i < before) {
                if (!Character.isWhitespace(line.charAt(i))) {
                    flag = true;
                }
                ++i;
            }
            if (flag) {
                this.log(aAST.getLineNo(), before, "ws.preceeded", (Object)aAST.getText());
            }
        }
    }

    public void setAllowLineBreaks(boolean aAllowLineBreaks) {
        this.mAllowLineBreaks = aAllowLineBreaks;
    }
}

