/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.duo.conf;

import com.google.inject.Inject;
import inet.ipaddr.IPAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.environment.Environment;
import org.apache.guacamole.properties.GuacamoleProperty;
import org.apache.guacamole.properties.IPAddressListProperty;
import org.apache.guacamole.properties.IntegerGuacamoleProperty;
import org.apache.guacamole.properties.StringGuacamoleProperty;
import org.apache.guacamole.properties.URIGuacamoleProperty;

public class ConfigurationService {
    @Inject
    private Environment environment;
    private static final StringGuacamoleProperty DUO_API_HOSTNAME = new StringGuacamoleProperty(){

        public String getName() {
            return "duo-api-hostname";
        }
    };
    private static final StringGuacamoleProperty DUO_CLIENT_ID = new StringGuacamoleProperty(){

        public String getName() {
            return "duo-client-id";
        }
    };
    private static final StringGuacamoleProperty DUO_CLIENT_SECRET = new StringGuacamoleProperty(){

        public String getName() {
            return "duo-client-secret";
        }
    };
    private static final URIGuacamoleProperty DUO_REDIRECT_URI = new URIGuacamoleProperty(){

        public String getName() {
            return "duo-redirect-uri";
        }
    };
    private static final IntegerGuacamoleProperty DUO_AUTH_TIMEOUT = new IntegerGuacamoleProperty(){

        public String getName() {
            return "duo-auth-timeout";
        }
    };
    private static final IPAddressListProperty DUO_BYPASS_HOSTS = new IPAddressListProperty(){

        public String getName() {
            return "duo-bypass-hosts";
        }
    };
    private static final IPAddressListProperty DUO_ENFORCE_HOSTS = new IPAddressListProperty(){

        public String getName() {
            return "duo-enforce-hosts";
        }
    };

    public String getAPIHostname() throws GuacamoleException {
        return (String)this.environment.getRequiredProperty((GuacamoleProperty)DUO_API_HOSTNAME);
    }

    public String getClientId() throws GuacamoleException {
        return (String)this.environment.getRequiredProperty((GuacamoleProperty)DUO_CLIENT_ID);
    }

    public String getClientSecret() throws GuacamoleException {
        return (String)this.environment.getRequiredProperty((GuacamoleProperty)DUO_CLIENT_SECRET);
    }

    public URI getRedirectUri() throws GuacamoleException {
        return (URI)this.environment.getRequiredProperty((GuacamoleProperty)DUO_REDIRECT_URI);
    }

    public int getAuthenticationTimeout() throws GuacamoleException {
        return (Integer)this.environment.getProperty((GuacamoleProperty)DUO_AUTH_TIMEOUT, (Object)5);
    }

    public List<IPAddress> getBypassHosts() throws GuacamoleException {
        return (List)this.environment.getProperty((GuacamoleProperty)DUO_BYPASS_HOSTS, Collections.emptyList());
    }

    public List<IPAddress> getEnforceHosts() throws GuacamoleException {
        return (List)this.environment.getProperty((GuacamoleProperty)DUO_ENFORCE_HOSTS, Collections.emptyList());
    }
}

