/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.io.PrintStream;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.solr.cli.CLIO;
import org.apache.solr.cli.ConfigSetDownloadTool;
import org.apache.solr.cli.ConfigSetUploadTool;
import org.apache.solr.cli.LinkConfigTool;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.ToolBase;
import org.apache.solr.cli.UpdateACLTool;
import org.apache.solr.cli.ZkCpTool;
import org.apache.solr.cli.ZkLsTool;
import org.apache.solr.cli.ZkMkrootTool;
import org.apache.solr.cli.ZkMvTool;

public class ZkToolHelp
extends ToolBase {
    public ZkToolHelp() {
        this(CLIO.getOutStream());
    }

    public ZkToolHelp(PrintStream stdout) {
        super(stdout);
    }

    @Override
    public List<Option> getOptions() {
        return List.of(Option.builder().longOpt("print-zk-subcommand-usage").desc("Reminds user to prepend zk to invoke the command.").required(false).build(), Option.builder().longOpt("print-long-zk-usage").required(false).desc("Invokes the detailed help for zk commands.").build());
    }

    @Override
    public String getName() {
        return "zk-tool-help";
    }

    @Override
    public void runImpl(CommandLine cli) throws Exception {
        SolrCLI.raiseLogLevelUnlessVerbose(cli);
        if (cli.hasOption("print-zk-subcommand-usage")) {
            String scriptCommand = cli.getArgs()[0];
            SolrCLI.print("You must invoke this subcommand using the zk command.   bin/solr zk " + scriptCommand + ".");
        }
        if (cli.hasOption("print-long-zk-usage")) {
            SolrCLI.print("usage:");
            SolrCLI.print(new ZkLsTool().getUsage());
            SolrCLI.print(new ZkCpTool().getUsage());
            SolrCLI.print(new ZkMvTool().getUsage());
            SolrCLI.print(new ConfigSetUploadTool().getUsage());
            SolrCLI.print(new ConfigSetDownloadTool().getUsage());
            SolrCLI.print(new ZkMkrootTool().getUsage());
            SolrCLI.print(new LinkConfigTool().getUsage());
            SolrCLI.print(new UpdateACLTool().getUsage());
            SolrCLI.print("");
            SolrCLI.print("Pass --help or -h after any COMMAND to see command-specific usage information such as: ./solr zk ls --help");
        }
    }
}

