/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.graphic.gantt;

import com.projectlibre1.field.Field;
import com.projectlibre1.field.FieldConverter;
import com.projectlibre1.functor.IntervalConsumer;
import com.projectlibre1.functor.ScheduleIntervalGenerator;
import com.projectlibre1.graphic.configuration.BarFormat;
import com.projectlibre1.graphic.configuration.BarStyles;
import com.projectlibre1.graphic.configuration.GraphicConfiguration;
import com.projectlibre1.graphic.configuration.TexturedShape;
import com.projectlibre1.graphic.configuration.shape.PredefinedPaint;
import com.projectlibre1.options.GanttOption;
import com.projectlibre1.pm.calendar.CalendarService;
import com.projectlibre1.pm.calendar.WorkingCalendar;
import com.projectlibre1.pm.dependency.Dependency;
import com.projectlibre1.pm.graphic.gantt.GanttBarSingleIntervalGenerator;
import com.projectlibre1.pm.graphic.gantt.GanttParams;
import com.projectlibre1.pm.graphic.gantt.link_routing.GanttLinkRouting;
import com.projectlibre1.pm.graphic.graph.GraphParams;
import com.projectlibre1.pm.graphic.graph.GraphRenderer;
import com.projectlibre1.pm.graphic.graph.LinkRouting;
import com.projectlibre1.pm.graphic.model.cache.GraphicDependency;
import com.projectlibre1.pm.graphic.model.cache.GraphicNode;
import com.projectlibre1.pm.graphic.model.cache.NodeModelCache;
import com.projectlibre1.pm.graphic.timescale.CoordinatesConverter;
import com.projectlibre1.pm.scheduling.ScheduleInterval;
import com.projectlibre1.pm.task.Project;
import com.projectlibre1.pm.time.HasStartAndEnd;
import com.projectlibre1.timescale.CalendarUtil;
import com.projectlibre1.timescale.TimeInterval;
import com.projectlibre1.timescale.TimeIterator;
import com.projectlibre1.util.DateTime;
import com.projectlibre1.util.FontUtil;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.ListIterator;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.apache.commons.collections.Closure;

public class GanttRenderer
extends GraphRenderer
implements Serializable {
    private static final long serialVersionUID = -7437190083991277084L;
    protected NodeRenderer nodeRenderer = new NodeRenderer();
    protected LinkRenderer linkRenderer = new LinkRenderer();
    protected HorizontalLineRenderer horizontalLineRenderer = new HorizontalLineRenderer();
    protected AnnotationRenderer annotationRenderer = new AnnotationRenderer();
    protected GraphicConfiguration config;
    protected JComponent container;
    protected BarFormat calendarFormat;
    protected Closure calendarClosure = new Closure(){

        @Override
        public void execute(Object object) {
            GanttRenderer.this.calendarFormat = (BarFormat)object;
        }
    };
    ArrayList nodeList = new ArrayList();

    public GanttRenderer() {
        this.config = GraphicConfiguration.getInstance();
    }

    public GanttRenderer(GraphParams graphParams) {
        super(graphParams);
        this.config = GraphicConfiguration.getInstance();
        if (graphParams instanceof JComponent) {
            this.container = (JComponent)((Object)graphParams);
        }
    }

    @Override
    public void updateShapes(ListIterator listIterator) {
        Rectangle rectangle = ((GanttParams)this.graphInfo).getGanttBounds();
        CoordinatesConverter coordinatesConverter = ((GanttParams)this.graphInfo).getCoord();
        if (coordinatesConverter == null) {
            return;
        }
        double d = ((GanttParams)this.graphInfo).getRowHeight();
        int n = (int)Math.floor(rectangle.getY() / d);
        int n2 = (int)Math.ceil(rectangle.getMaxY() / d);
        double d2 = coordinatesConverter.toTime(rectangle.getX());
        double d3 = coordinatesConverter.toTime(rectangle.getMaxX());
        ListIterator listIterator2 = listIterator;
        while (listIterator2.hasNext()) {
            GraphicNode graphicNode = (GraphicNode)listIterator2.next();
            graphicNode.setRow(listIterator2.previousIndex());
            if (listIterator2.previousIndex() < n || listIterator2.previousIndex() >= n2 || graphicNode.isVoid()) continue;
            this.updateShape(graphicNode);
        }
    }

    @Override
    public void updateShape(GraphicNode graphicNode) {
        if (((GanttParams)this.graphInfo).getCoord() == null) {
            return;
        }
        BarStyles barStyles = this.graphInfo.getBarStyles();
        this.nodeRenderer.initialize(null, graphicNode);
        barStyles.apply(graphicNode.getNode().getImpl(), this.nodeRenderer);
    }

    public void paintNode(Graphics2D graphics2D, GraphicNode graphicNode, boolean bl) {
        BarStyles barStyles = this.graphInfo.getBarStyles();
        this.nodeRenderer.initialize(graphics2D, graphicNode);
        if (bl) {
            this.nodeRenderer.setLayers(1000, 1499);
        } else {
            this.nodeRenderer.setLayers(1, 499);
        }
        barStyles.apply(graphicNode.getNode().getImpl(), this.nodeRenderer);
    }

    public void paintAnnotation(Graphics2D graphics2D, GraphicNode graphicNode) {
        BarStyles barStyles = this.graphInfo.getBarStyles();
        this.annotationRenderer.initialize(graphics2D, graphicNode);
        barStyles.apply(graphicNode.getNode().getImpl(), this.annotationRenderer, false, true, false, false);
    }

    public void paintHorizontalLine(Graphics2D graphics2D, GraphicNode graphicNode) {
        BarStyles barStyles = this.graphInfo.getBarStyles();
        this.horizontalLineRenderer.initialize(graphics2D, graphicNode);
        barStyles.apply(graphicNode.getNode().getImpl(), this.horizontalLineRenderer, false, false, false, true);
    }

    public void paintLink(Graphics2D graphics2D, GraphicDependency graphicDependency) {
        BarStyles barStyles = this.graphInfo.getBarStyles();
        this.linkRenderer.initialize(graphics2D, graphicDependency);
        barStyles.apply(graphicDependency, this.linkRenderer, true, false, false, false);
    }

    protected BarFormat getCalendarFormat() {
        this.calendarFormat = null;
        if (this.calendarFormat == null) {
            BarStyles barStyles = this.graphInfo.getBarStyles();
            barStyles.apply(null, this.calendarClosure, false, false, true, false);
        }
        return this.calendarFormat;
    }

    public void paintNonWorkingDays(Graphics2D graphics2D, Rectangle rectangle) {
        long l;
        HasStartAndEnd hasStartAndEnd;
        BarFormat barFormat = this.getCalendarFormat();
        if (barFormat == null) {
            return;
        }
        Color color = graphics2D.getColor();
        Paint paint = graphics2D.getPaint();
        CoordinatesConverter coordinatesConverter = ((GanttParams)this.graphInfo).getCoord();
        Project project = coordinatesConverter.getProject();
        WorkingCalendar workingCalendar = (WorkingCalendar)project.getWorkCalendar();
        if (coordinatesConverter.getTimescaleManager().isShowWholeDays()) {
            boolean bl = coordinatesConverter.getTimescaleManager().getCurrentScaleIndex() == 0;
            hasStartAndEnd = coordinatesConverter.getTimeIterator(rectangle.getX(), rectangle.getMaxX(), bl);
            l = -1L;
            long l2 = -1L;
            GregorianCalendar gregorianCalendar = DateTime.calendarInstance();
            PredefinedPaint predefinedPaint = (PredefinedPaint)barFormat.getMiddle().getPaint();
            predefinedPaint.applyPaint(graphics2D, this.useTextures());
            while (((TimeIterator)hasStartAndEnd).hasNext()) {
                TimeInterval timeInterval = ((TimeIterator)hasStartAndEnd).next();
                long l3 = timeInterval.getStart();
                if (CalendarService.getInstance().getDay(workingCalendar, l3).isWorking()) {
                    if (l == -1L) continue;
                    this.drawNonWorking(graphics2D, l, l2, gregorianCalendar, coordinatesConverter, rectangle, bl);
                    l2 = -1L;
                    l = -1L;
                    continue;
                }
                if (l == -1L) {
                    l = l3;
                }
                l2 = l3;
            }
            if (l != -1L) {
                this.drawNonWorking(graphics2D, l, l2, gregorianCalendar, coordinatesConverter, rectangle, bl);
                l2 = -1L;
                l = -1L;
            }
        }
        if (this.container != null) {
            int n;
            TimeIterator timeIterator = coordinatesConverter.getTimeIterator(rectangle.getX(), rectangle.getMaxX(), true);
            graphics2D.setPaint(new PredefinedPaint(PredefinedPaint.DOT_LINE2, Color.GRAY, graphics2D.getBackground()));
            while (timeIterator.hasNext()) {
                hasStartAndEnd = timeIterator.next();
                int n2 = (int)Math.round(coordinatesConverter.toX(((TimeInterval)hasStartAndEnd).getStart()));
                graphics2D.drawLine(n2, rectangle.y, n2, rectangle.y + rectangle.height);
            }
            int n3 = (int)Math.round(coordinatesConverter.toX(project.getStart()));
            if ((double)n3 >= rectangle.getX() && (double)n3 <= rectangle.getMaxX()) {
                graphics2D.setPaint(new PredefinedPaint(PredefinedPaint.DASH_LINE, Color.GRAY, graphics2D.getBackground()));
                graphics2D.drawLine(n3, rectangle.y, n3, rectangle.y + rectangle.height);
            }
            if ((l = project.getStatusDate()) != 0L && (double)(n = (int)Math.round(coordinatesConverter.toX(l))) >= rectangle.getX() && (double)n <= rectangle.getMaxX()) {
                graphics2D.setPaint(new PredefinedPaint(PredefinedPaint.DOT_LINE2, Color.GREEN, graphics2D.getBackground()));
                graphics2D.drawLine(n, rectangle.y, n, rectangle.y + rectangle.height);
            }
            if (color != null) {
                graphics2D.setColor(color);
            }
            if (paint != null) {
                graphics2D.setPaint(paint);
            }
        }
    }

    private void drawNonWorking(Graphics2D graphics2D, long l, long l2, Calendar calendar, CoordinatesConverter coordinatesConverter, Rectangle rectangle, boolean bl) {
        calendar.setTimeInMillis(l2);
        if (bl) {
            coordinatesConverter.getTimescaleManager().getScale().increment2(calendar);
        } else {
            coordinatesConverter.getTimescaleManager().getScale().increment1(calendar);
        }
        l2 = calendar.getTimeInMillis();
        graphics2D.fillRect((int)Math.round(coordinatesConverter.toX(l)), rectangle.y, (int)Math.round(coordinatesConverter.toW(l2 - l)), rectangle.height);
    }

    @Override
    public void paint(Graphics graphics) {
        this.paint(graphics, null);
    }

    public void paint(Graphics graphics, Rectangle rectangle) {
        GraphicNode graphicNode;
        Rectangle rectangle2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle rectangle3 = rectangle2 = graphics2D.getClipBounds();
        if (rectangle2 == null) {
            rectangle2 = ((GanttParams)this.getGraphInfo()).getGanttBounds();
            if (rectangle == null) {
                rectangle2 = new Rectangle(0, 1, rectangle2.width, rectangle2.height - 2);
            } else {
                rectangle2 = rectangle;
                graphics2D.setClip(rectangle2);
            }
        }
        this.paintNonWorkingDays(graphics2D, rectangle2);
        double d = ((GanttParams)this.graphInfo).getRowHeight();
        int n = (int)Math.floor(rectangle2.getY() / d);
        int n2 = rectangle == null ? (int)Math.ceil(rectangle2.getMaxY() / d) : (int)Math.floor(rectangle2.getMaxY() / d);
        this.nodeList.clear();
        NodeModelCache nodeModelCache = this.graphInfo.getCache();
        Object object = nodeModelCache.getIterator();
        while (object.hasNext()) {
            graphicNode = (GraphicNode)object.next();
            graphicNode.setRow(object.previousIndex());
            if (object.previousIndex() < n || object.previousIndex() >= n2 || !graphicNode.isSchedule()) continue;
            this.nodeList.add(graphicNode);
            this.paintAnnotation(graphics2D, graphicNode);
            this.paintNode(graphics2D, graphicNode, true);
            this.paintHorizontalLine(graphics2D, graphicNode);
        }
        ListIterator listIterator = nodeModelCache.getEdgesIterator();
        while (listIterator.hasNext()) {
            object = (GraphicDependency)listIterator.next();
            this.paintLink(graphics2D, (GraphicDependency)object);
        }
        listIterator = this.nodeList.listIterator();
        while (listIterator.hasNext()) {
            graphicNode = (GraphicNode)listIterator.next();
            this.paintNode(graphics2D, graphicNode, false);
        }
        if (rectangle != null) {
            graphics2D.setClip(rectangle3);
        }
    }

    private class LinkRenderer
    implements Closure,
    Serializable {
        private static final long serialVersionUID = -2031158189787837110L;
        protected BarFormat format;
        protected GraphicDependency dependency;
        protected Graphics2D g2;
        private double[] extraPoints = new double[3];

        private LinkRenderer() {
        }

        void initialize(Graphics2D graphics2D, GraphicDependency graphicDependency) {
            this.g2 = graphics2D;
            this.dependency = graphicDependency;
        }

        @Override
        public void execute(Object object) {
            AffineTransform affineTransform;
            double d;
            this.format = (BarFormat)object;
            GanttLinkRouting ganttLinkRouting = (GanttLinkRouting)((GanttParams)GanttRenderer.this.graphInfo).getRouting();
            CoordinatesConverter coordinatesConverter = ((GanttParams)GanttRenderer.this.graphInfo).getCoord();
            GraphicNode graphicNode = this.dependency.getPredecessor();
            GraphicNode graphicNode2 = this.dependency.getSuccessor();
            int n = this.dependency.getType();
            int n2 = n == 2 || n == 3 ? -1 : 1;
            int n3 = n == 1 || n == 3 ? -1 : 1;
            double d2 = coordinatesConverter.toX(graphicNode.getStart());
            double d3 = coordinatesConverter.toX(graphicNode.getEnd());
            d3 = CoordinatesConverter.adaptSmallBarEndX(d2, d3, graphicNode, GanttRenderer.this.config);
            double d4 = coordinatesConverter.toX(graphicNode2.getStart());
            double d5 = coordinatesConverter.toX(graphicNode2.getEnd());
            d5 = CoordinatesConverter.adaptSmallBarEndX(d4, d5, graphicNode2, GanttRenderer.this.config);
            double d6 = n2 < 0 ? d2 : d3;
            double d7 = n3 < 0 ? d4 : d5;
            int n4 = ((GanttParams)GanttRenderer.this.graphInfo).getRowHeight();
            int n5 = GanttRenderer.this.config.getGanttBarYOffset() + GanttRenderer.this.config.getGanttBarHeight() / 2;
            int n6 = n4 * graphicNode.getRow();
            int n7 = n4 * graphicNode2.getRow();
            double d8 = Math.max(n6, n7);
            GeneralPath generalPath = this.dependency.getPath();
            ganttLinkRouting.routePath(generalPath, d6, n6 += n5, d7, n7 += n5, d8, (double)n7 + graphicNode2.getGanttShapeHeight() / 2.0, (double)n7 - graphicNode2.getGanttShapeHeight() / 2.0, n);
            Color color = this.g2.getColor();
            Stroke stroke = this.g2.getStroke();
            Dependency dependency = this.dependency.getDependency();
            if (dependency.isDisabled()) {
                this.g2.setStroke(GraphRenderer.DISABLED_LINK_STROKE);
            }
            if (dependency.isCrossProject()) {
                this.g2.setColor(GraphRenderer.EXTERNAL_LINK_COLOR);
            } else {
                this.g2.setColor(this.format.getMiddle().getColor());
            }
            this.g2.draw(generalPath);
            if (this.format.getStart() == null && this.format.getEnd() == null) {
                return;
            }
            if (this.format.getStart() != null) {
                d = ganttLinkRouting.getFirstAngle();
                affineTransform = d == 0.0 ? null : AffineTransform.getRotateInstance(d, ganttLinkRouting.getFirstX(), ganttLinkRouting.getFirstY());
                this.drawLinkArrows(dependency, affineTransform, this.format.getStart());
            }
            if (this.format.getEnd() != null) {
                d = ganttLinkRouting.getLastAngle();
                affineTransform = d == Math.PI || d == -Math.PI ? null : AffineTransform.getRotateInstance(Math.PI - d, ganttLinkRouting.getLastX(), ganttLinkRouting.getLastY());
                this.drawLinkArrows(dependency, affineTransform, this.format.getEnd());
            }
            if (color != null) {
                this.g2.setColor(color);
            }
            if (stroke != null) {
                this.g2.setStroke(stroke);
            }
        }

        private void drawLinkArrows(Dependency dependency, AffineTransform affineTransform, TexturedShape texturedShape) {
            Color color = this.format.getEnd().getColor();
            if (dependency.isCrossProject()) {
                texturedShape.setPaint(GraphRenderer.EXTERNAL_LINK_COLOR);
            }
            this.g2.setColor(texturedShape.getColor());
            LinkRouting linkRouting = ((GanttParams)GanttRenderer.this.graphInfo).getRouting();
            texturedShape.draw(this.g2, linkRouting.getLastX(), linkRouting.getLastY(), affineTransform, GanttRenderer.this.useTextures());
            if (dependency.isCrossProject()) {
                texturedShape.setPaint(color);
            }
        }
    }

    private class HorizontalLineRenderer
    implements Closure,
    Serializable {
        private static final long serialVersionUID = -6350307720624037262L;
        protected BarFormat format;
        GraphicNode node;
        Graphics2D g2;
        protected int yrow;

        private HorizontalLineRenderer() {
        }

        public void initialize(Graphics2D graphics2D, GraphicNode graphicNode) {
            this.g2 = graphics2D;
            this.node = graphicNode;
            int n = ((GanttParams)GanttRenderer.this.graphInfo).getRowHeight();
            GanttRenderer.this.config = ((GanttParams)GanttRenderer.this.graphInfo).getConfiguration();
            this.yrow = (graphicNode.getRow() + 1) * n - 1;
        }

        @Override
        public void execute(Object object) {
            this.format = (BarFormat)object;
            Rectangle rectangle = this.g2.getClipBounds();
            Stroke stroke = this.g2.getStroke();
            Color color = this.g2.getColor();
            this.g2.setColor(this.format.getMiddle().getColor());
            this.g2.drawLine(rectangle.x, this.yrow, rectangle.x + rectangle.width, this.yrow);
            this.g2.setColor(color);
        }
    }

    private class AnnotationRenderer
    implements Closure,
    Serializable {
        private static final long serialVersionUID = -137778741030744803L;
        protected BarFormat format;
        GraphicNode node;
        Graphics2D g2;
        protected int yrow;
        protected JLabel component = new JLabel();
        protected CellRendererPane rendererPane;
        FontMetrics fontMetrics;

        private AnnotationRenderer() {
        }

        public void initialize(Graphics2D graphics2D, GraphicNode graphicNode) {
            this.g2 = graphics2D;
            this.node = graphicNode;
            int n = ((GanttParams)GanttRenderer.this.graphInfo).getRowHeight();
            GanttRenderer.this.config = ((GanttParams)GanttRenderer.this.graphInfo).getConfiguration();
            this.yrow = graphicNode.getRow() * n;
            if (GanttRenderer.this.container != null) {
                this.rendererPane = new CellRendererPane();
                GanttRenderer.this.container.add(this.rendererPane);
            }
            this.component.setFont(FontUtil.getFont(null, 1));
            this.fontMetrics = this.component.getFontMetrics(this.component.getFont());
        }

        @Override
        public void execute(Object object) {
            String string;
            this.format = (BarFormat)object;
            Field field = this.format.getField();
            if (field == null) {
                return;
            }
            Object object2 = field.getValue(this.node.getNode(), GanttRenderer.this.graphInfo.getCache().getModel(), null);
            if (object2 == null) {
                return;
            }
            CoordinatesConverter coordinatesConverter = ((GanttParams)GanttRenderer.this.graphInfo).getCoord();
            if (object2 instanceof Date) {
                Date date = (Date)object2;
                string = DateFormat.getDateInstance(3).format(date);
                int n = string.lastIndexOf(47);
                if (n > 0) {
                    string = string.substring(0, n);
                }
            } else {
                string = FieldConverter.toString(object2, object2.getClass(), null);
            }
            this.component.setText(string);
            int n = this.yrow + GanttRenderer.this.config.getGanttBarYOffset();
            double d = coordinatesConverter.toX(this.node.getStart());
            double d2 = coordinatesConverter.toX(this.node.getEnd());
            d2 = CoordinatesConverter.adaptSmallBarEndX(d, d2, this.node, GanttRenderer.this.config);
            int n2 = (int)Math.ceil(d2) + GanttRenderer.this.config.getGanttBarAnnotationXOffset();
            int n3 = this.fontMetrics.stringWidth(string);
            int n4 = GanttRenderer.this.config.getGanttBarHeight();
            if (GanttRenderer.this.container == null) {
                this.component.setDoubleBuffered(false);
                this.component.setOpaque(false);
                this.component.setForeground(this.format.getMiddle().getColor());
                this.component.setSize(n3, n4);
                this.g2.translate(n2, n);
                this.component.doLayout();
                this.component.print(this.g2);
                this.g2.translate(-n2, -n);
            } else {
                this.rendererPane.paintComponent(this.g2, this.component, GanttRenderer.this.container, n2, n, n3, n4, true);
            }
        }
    }

    private class NodeRenderer
    implements Closure,
    IntervalConsumer,
    Serializable {
        private static final long serialVersionUID = -1348039741030744803L;
        GraphicNode node;
        Graphics2D g2;
        protected GanttBarSingleIntervalGenerator singleIntervalGenerator = new GanttBarSingleIntervalGenerator();
        protected ScheduleInterval interval;
        protected BarFormat format;
        protected int yrow;
        protected int maxLayer = Integer.MAX_VALUE;
        protected int minLayer = 0;

        private NodeRenderer() {
        }

        public void initialize(Graphics2D graphics2D, GraphicNode graphicNode) {
            this.g2 = graphics2D;
            this.node = graphicNode;
            int n = ((GanttParams)GanttRenderer.this.graphInfo).getRowHeight();
            this.yrow = graphicNode.getRow() * n;
            this.setLayers(1, 499);
        }

        public int getMaxLayer() {
            return this.maxLayer;
        }

        public void setMaxLayer(int n) {
            this.maxLayer = n;
        }

        public int getMinLayer() {
            return this.minLayer;
        }

        public void setMinLayer(int n) {
            this.minLayer = n;
        }

        public void setLayers(int n, int n2) {
            this.minLayer = n;
            this.maxLayer = n2;
        }

        @Override
        public void execute(Object object) {
            ScheduleIntervalGenerator scheduleIntervalGenerator;
            this.format = (BarFormat)object;
            if (this.format.getLayer() > this.maxLayer || this.format.getLayer() < this.minLayer) {
                return;
            }
            if (this.format.getScheduleIntervalGenerator() == null) {
                this.singleIntervalGenerator.initialize(GanttRenderer.this.graphInfo.getCache().getModel(), this.format.getFromField(), this.format.getToField());
                scheduleIntervalGenerator = this.singleIntervalGenerator;
            } else {
                scheduleIntervalGenerator = this.format.getScheduleIntervalGenerator();
            }
            scheduleIntervalGenerator.consumeIntervals(this.node, this);
        }

        @Override
        public void consumeInterval(ScheduleInterval scheduleInterval) {
            long l;
            double d;
            CoordinatesConverter coordinatesConverter = ((GanttParams)GanttRenderer.this.graphInfo).getCoord();
            if (scheduleInterval.getEnd() > 100000000000000L) {
                System.out.println("ERROR!!! leads to OutOfMemoryError, consumeInterval interval=" + scheduleInterval.getStart() + ", " + CalendarUtil.toString(scheduleInterval.getStart()) + ", " + scheduleInterval.getEnd() + ", " + CalendarUtil.toString(scheduleInterval.getEnd()) + "...");
                return;
            }
            double d2 = coordinatesConverter.toX(scheduleInterval.getStart());
            double d3 = CoordinatesConverter.adaptSmallBarEndX(d2, coordinatesConverter.toX(scheduleInterval.getEnd()), this.node, GanttRenderer.this.config) - d2;
            double d4 = this.yrow + GanttRenderer.this.config.getGanttBarYOffset();
            int n = this.format.getRow();
            if (n == 1) {
                d = GanttRenderer.this.config.getGanttBarHeight();
            } else {
                d = GanttRenderer.this.config.getBaselineHeight();
                d4 += (double)(GanttRenderer.this.config.getGanttBarHeight() + GanttRenderer.this.config.getBaselineHeight() * (n - 2));
            }
            d4 += d / 2.0;
            double d5 = d;
            if (this.format.getMiddle() != null) {
                Shape shape;
                if (this.g2 == null && this.format.isMain()) {
                    shape = this.format.getMiddle().toGeneralPath(d3, d, d2, d4, null);
                    Rectangle2D rectangle2D = shape.getBounds2D();
                    this.node.setGanttShapeOffset(rectangle2D.getY() - d4 + d / 2.0);
                    this.node.setGanttShapeHeight(rectangle2D.getHeight());
                } else {
                    shape = this.format.getMiddle().draw(this.g2, d3, d, d2, d4, GanttRenderer.this.useTextures());
                }
            }
            if (this.g2 == null) {
                return;
            }
            if (this.format.getStart() != null) {
                this.format.getStart().draw(this.g2, d5, d, d2, d4, GanttRenderer.this.useTextures());
            }
            if (this.format.getEnd() != null) {
                this.format.getEnd().draw(this.g2, d5, d, d2 + d3, d4, GanttRenderer.this.useTextures());
            }
            if (this.format.isMain() && !this.node.isSummary() && this.node.isStarted() && (l = this.node.getCompleted()) >= scheduleInterval.getStart()) {
                double d6 = coordinatesConverter.toX(l) - d2;
                if (d6 > d3 && !GanttOption.getInstance().isCompletionIsContiguous()) {
                    d6 = d3;
                }
                d6 = CoordinatesConverter.adaptSmallBarEndX(d2, d2 + d6, this.node, GanttRenderer.this.config) - d2;
                Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d4 - (double)(GanttRenderer.this.config.getGanttProgressBarHeight() / 2), d6, GanttRenderer.this.config.getGanttProgressBarHeight());
                this.g2.setColor(Color.BLACK);
                this.g2.fill(double_);
            }
        }
    }
}

