/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec4(-64, 72, 88, -76) | (~ ivec4(-64, 72, 88, -76))) => ivec4(-1, -1, -1, -1)
 * (ivec4(-64, 72, 88, -76) | (~ ivec4(64, 72, 88, 76))) => ivec4(-1, -1, -1, -73)
 * (ivec4(-64, 72, 88, -76) | (~ ivec4(-24, 40, -23, 64))) => ivec4(-41, -33, 94, -65)
 * (ivec4(-64, 72, 88, -76) | (~ ivec4(24, 40, 23, 64))) => ivec4(-25, -33, -8, -65)
 * (ivec4(64, 72, 88, 76) | (~ ivec4(-64, 72, 88, -76))) => ivec4(127, -1, -1, 79)
 * (ivec4(64, 72, 88, 76) | (~ ivec4(64, 72, 88, 76))) => ivec4(-1, -1, -1, -1)
 * (ivec4(64, 72, 88, 76) | (~ ivec4(-24, 40, -23, 64))) => ivec4(87, -33, 94, -1)
 * (ivec4(64, 72, 88, 76) | (~ ivec4(24, 40, 23, 64))) => ivec4(-25, -33, -8, -1)
 * (ivec4(-24, 40, -23, 64) | (~ ivec4(-64, 72, 88, -76))) => ivec4(-1, -65, -17, 75)
 * (ivec4(-24, 40, -23, 64) | (~ ivec4(64, 72, 88, 76))) => ivec4(-1, -65, -17, -13)
 * (ivec4(-24, 40, -23, 64) | (~ ivec4(-24, 40, -23, 64))) => ivec4(-1, -1, -1, -1)
 * (ivec4(-24, 40, -23, 64) | (~ ivec4(24, 40, 23, 64))) => ivec4(-17, -1, -23, -1)
 * (ivec4(24, 40, 23, 64) | (~ ivec4(-64, 72, 88, -76))) => ivec4(63, -65, -73, 75)
 * (ivec4(24, 40, 23, 64) | (~ ivec4(64, 72, 88, 76))) => ivec4(-65, -65, -73, -13)
 * (ivec4(24, 40, 23, 64) | (~ ivec4(-24, 40, -23, 64))) => ivec4(31, -1, 23, -1)
 * (ivec4(24, 40, 23, 64) | (~ ivec4(24, 40, 23, 64))) => ivec4(-1, -1, -1, -1)
 */
#version 130

void main()
{
  float[all(equal((ivec4(-64, 72, 88, -76) | (~ ivec4(-64, 72, 88, -76))), ivec4(-1, -1, -1, -1))) ? 1 : -1] array0;
  float[all(equal((ivec4(-64, 72, 88, -76) | (~ ivec4(64, 72, 88, 76))), ivec4(-1, -1, -1, -73))) ? 1 : -1] array1;
  float[all(equal((ivec4(-64, 72, 88, -76) | (~ ivec4(-24, 40, -23, 64))), ivec4(-41, -33, 94, -65))) ? 1 : -1] array2;
  float[all(equal((ivec4(-64, 72, 88, -76) | (~ ivec4(24, 40, 23, 64))), ivec4(-25, -33, -8, -65))) ? 1 : -1] array3;
  float[all(equal((ivec4(64, 72, 88, 76) | (~ ivec4(-64, 72, 88, -76))), ivec4(127, -1, -1, 79))) ? 1 : -1] array4;
  float[all(equal((ivec4(64, 72, 88, 76) | (~ ivec4(64, 72, 88, 76))), ivec4(-1, -1, -1, -1))) ? 1 : -1] array5;
  float[all(equal((ivec4(64, 72, 88, 76) | (~ ivec4(-24, 40, -23, 64))), ivec4(87, -33, 94, -1))) ? 1 : -1] array6;
  float[all(equal((ivec4(64, 72, 88, 76) | (~ ivec4(24, 40, 23, 64))), ivec4(-25, -33, -8, -1))) ? 1 : -1] array7;
  float[all(equal((ivec4(-24, 40, -23, 64) | (~ ivec4(-64, 72, 88, -76))), ivec4(-1, -65, -17, 75))) ? 1 : -1] array8;
  float[all(equal((ivec4(-24, 40, -23, 64) | (~ ivec4(64, 72, 88, 76))), ivec4(-1, -65, -17, -13))) ? 1 : -1] array9;
  float[all(equal((ivec4(-24, 40, -23, 64) | (~ ivec4(-24, 40, -23, 64))), ivec4(-1, -1, -1, -1))) ? 1 : -1] array10;
  float[all(equal((ivec4(-24, 40, -23, 64) | (~ ivec4(24, 40, 23, 64))), ivec4(-17, -1, -23, -1))) ? 1 : -1] array11;
  float[all(equal((ivec4(24, 40, 23, 64) | (~ ivec4(-64, 72, 88, -76))), ivec4(63, -65, -73, 75))) ? 1 : -1] array12;
  float[all(equal((ivec4(24, 40, 23, 64) | (~ ivec4(64, 72, 88, 76))), ivec4(-65, -65, -73, -13))) ? 1 : -1] array13;
  float[all(equal((ivec4(24, 40, 23, 64) | (~ ivec4(-24, 40, -23, 64))), ivec4(31, -1, 23, -1))) ? 1 : -1] array14;
  float[all(equal((ivec4(24, 40, 23, 64) | (~ ivec4(24, 40, 23, 64))), ivec4(-1, -1, -1, -1))) ? 1 : -1] array15;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length());
}
