"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BaseSelectors = void 0;
var _state_adapter = require("./state_adapter");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class BaseSelectors {
  constructor(adapterOrObservable) {
    _defineProperty(this, "changeHandlers", new Set());
    _defineProperty(this, "rafHandle", void 0);
    _defineProperty(this, "unsubscribe", void 0);
    _defineProperty(this, "stateAdapter", void 0);
    _defineProperty(this, "emitChange", () => {
      // Cancel any pending RAF to debounce multiple rapid changes
      if (this.rafHandle !== undefined) {
        cancelAnimationFrame(this.rafHandle);
      }

      // Schedule state update on next animation frame
      this.rafHandle = requestAnimationFrame(() => {
        this.changeHandlers.forEach(handler => handler());
        this.rafHandle = undefined;
      });
    });
    if ((0, _state_adapter.isStateAdapter)(adapterOrObservable)) {
      this.stateAdapter = adapterOrObservable;
    } else {
      this.stateAdapter = new _state_adapter.BehaviorSubjectAdapter(adapterOrObservable);
    }

    // Subscribe to state changes and emit change notifications
    this.unsubscribe = this.stateAdapter.subscribe(() => {
      this.emitChange();
    });
  }
  subscribe(onStoreChange) {
    this.changeHandlers.add(onStoreChange);
    return () => {
      this.changeHandlers.delete(onStoreChange);
    };
  }
  getSnapshot() {
    return this.getState();
  }
  destroy() {
    if (this.rafHandle !== undefined) {
      cancelAnimationFrame(this.rafHandle);
    }
    if (this.unsubscribe) {
      this.unsubscribe();
    }
    this.changeHandlers.clear();
  }
  getState() {
    return this.stateAdapter.getState();
  }
}
exports.BaseSelectors = BaseSelectors;